/*
 * Decompiled with CFR 0.152.
 */
package me.andy.statsmod;

import me.andy.statsmod.command.CommandRegistry;
import me.andy.statsmod.command.StatsmodCommand;
import me.andy.statsmod.config.ConfigManager;
import me.andy.statsmod.config.ReadmeGenerator;
import me.andy.statsmod.stats.StatTracker;
import me.andy.statsmod.stats.StatisticsManager;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Statsmod
implements ModInitializer {
    public static final String MOD_ID = "statsmod";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"statsmod");
    public static final String PERM_PLAYER = "statsmod.player";
    public static final String PERM_ADMINS = "statsmod.admins";
    public static final String PERM_COMMAND_BASE = "statsmod.command.base";
    public static final String PERM_COMMAND_STATS = "statsmod.command.stats";
    public static final String PERM_COMMAND_PROFILE = "statsmod.command.profile";
    public static final String PERM_COMMAND_PROFILES = "statsmod.command.profiles";
    public static final String PERM_COMMAND_OTHERS = "statsmod.command.others";
    public static final String PERM_GENRES = "statsmod.genres";
    public static final String PERM_TYPES = "statsmod.types";
    public static final String PERM_GENRE_BASE = "statsmod.genre.";
    public static final String PERM_TYPE_BASE = "statsmod.type.";
    public static final String PERM_ADMIN_RELOAD = "statsmod.admin.reload";
    public static final String PERM_ADMIN_DEBUG = "statsmod.admin.debug";
    public static final String PERM_ADMIN_MIGRATE = "statsmod.admin.migrate";
    public static final String PERM_ADMIN_SET = "statsmod.admin.set";
    public static final String PERM_ADMIN_RESET_PLAYER = "statsmod.admin.reset.player";
    public static final String PERM_ADMIN_RESET_GENRE = "statsmod.admin.reset.genre";
    public static final String PERM_ADMIN_RESET_ALL = "statsmod.admin.reset.all";
    private static StatisticsManager statisticsManager;
    private static ConfigManager configManager;

    public void onInitialize() {
        LOGGER.info("Initializing StatsMod...");
        configManager = new ConfigManager();
        configManager.loadConfigs();
        ReadmeGenerator.generate();
        statisticsManager = new StatisticsManager();
        StatsmodCommand.init();
        CommandRegistry.registerCommands();
        StatTracker.register();
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onServerStopping);
        LOGGER.info("StatsMod initialized successfully!");
    }

    private void onServerStopping(MinecraftServer server) {
        LOGGER.info("Server stopping, saving all player stats...");
        if (statisticsManager != null) {
            statisticsManager.saveAllOnlinePlayerData(server);
        }
        LOGGER.info("All player stats saved.");
    }

    public static StatisticsManager getStatisticsManager() {
        return statisticsManager;
    }

    public static ConfigManager getConfigManager() {
        return configManager;
    }
}

