/*
 * Decompiled with CFR 0.152.
 */
package me.andy.statsmod.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import java.util.UUID;
import me.andy.statsmod.Statsmod;
import me.andy.statsmod.config.SettingsConfig;
import me.andy.statsmod.stats.PlayerData;
import me.andy.statsmod.stats.storage.DatabaseStorage;
import me.andy.statsmod.stats.storage.FileStorage;
import me.andy.statsmod.stats.storage.IDataStorage;
import me.andy.statsmod.util.PermissionUtil;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class AdminCommands {
    public static void registerAdminCommands(LiteralArgumentBuilder<class_2168> parent) {
        parent.requires(source -> PermissionUtil.checkPermission(source, "statsmod.admins", 2));
        parent.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> PermissionUtil.checkPermission(source, "statsmod.admin.reload", 2))).executes(context -> {
            Statsmod.getConfigManager().loadConfigs();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7aStatsMod configurations reloaded."), true);
            return 1;
        }));
        parent.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"migrate").requires(source -> PermissionUtil.checkPermission(source, "statsmod.admin.migrate", 4))).executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a7eStarting data migration from files to database..."), true);
            new Thread(() -> {
                FileStorage fileStorage = new FileStorage();
                fileStorage.init();
                Map<UUID, PlayerData> allData = fileStorage.loadAllPlayerData();
                IDataStorage dbStorage = Statsmod.getStatisticsManager().getStorage();
                SettingsConfig settings = Statsmod.getConfigManager().getSettingsConfig();
                if (settings.database == null || !settings.database.enabled || !(dbStorage instanceof DatabaseStorage)) {
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"\u00a7cDatabase storage is not enabled in settings.yml! Cannot migrate."));
                    return;
                }
                allData.values().forEach(dbStorage::savePlayerData);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7aData migration complete! " + allData.size() + " players migrated.")), true);
            }).start();
            return 1;
        }));
        parent.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").requires(source -> PermissionUtil.checkPermission(source, "statsmod.admin.debug", 2))).executes(context -> {
            SettingsConfig settings = Statsmod.getConfigManager().getSettingsConfig();
            settings.debug_mode = !settings.debug_mode;
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7aDebug mode set to: \u00a7e" + settings.debug_mode)), true);
            return 1;
        }));
        parent.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(source -> PermissionUtil.checkPermission(source, "statsmod.admin.set", 2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"stat_key", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"value", (ArgumentType)LongArgumentType.longArg((long)0L)).executes(context -> {
            class_3222 target = class_2186.method_9315((CommandContext)context, (String)"player");
            String statKey = StringArgumentType.getString((CommandContext)context, (String)"stat_key");
            long value = LongArgumentType.getLong((CommandContext)context, (String)"value");
            Statsmod.getStatisticsManager().setStat(target, statKey, value);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("\u00a7aSet %s's stat \u00a7e%s\u00a7a to \u00a7b%d", target.method_7334().name(), statKey, value)), true);
            return 1;
        })))));
        LiteralArgumentBuilder resetNode = class_2170.method_9247((String)"reset");
        resetNode.then(class_2170.method_9247((String)"player").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(source -> PermissionUtil.checkPermission(source, "statsmod.admin.reset.player", 3))).executes(context -> {
            class_3222 target = class_2186.method_9315((CommandContext)context, (String)"player");
            Statsmod.getStatisticsManager().resetAllStats(target);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7cReset all stats for player " + target.method_7334().name())), true);
            return 1;
        })).then(class_2170.method_9247((String)"genre").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"genre_id", (ArgumentType)StringArgumentType.string()).requires(source -> PermissionUtil.checkPermission(source, "statsmod.admin.reset.genre", 3))).executes(context -> {
            class_3222 target = class_2186.method_9315((CommandContext)context, (String)"player");
            String genreId = StringArgumentType.getString((CommandContext)context, (String)"genre_id");
            Statsmod.getStatisticsManager().resetGenreForPlayer(target, genreId);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7cReset genre '" + genreId + "' for player " + target.method_7334().name())), true);
            return 1;
        })))));
        resetNode.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"server").then(class_2170.method_9247((String)"genre").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"genre_id", (ArgumentType)StringArgumentType.string()).requires(source -> PermissionUtil.checkPermission(source, "statsmod.admin.reset.genre", 4))).executes(context -> {
            String genreId = StringArgumentType.getString((CommandContext)context, (String)"genre_id");
            Statsmod.getStatisticsManager().resetGenreForAllPlayers(genreId);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7cReset genre '" + genreId + "' for ALL players.")), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"all").requires(source -> PermissionUtil.checkPermission(source, "statsmod.admin.reset.all", 4))).executes(context -> {
            Statsmod.getStatisticsManager().resetAllServerStats();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"\u00a74\u00a7lWARNING: All statistics for all players have been wiped."), true);
            return 1;
        })));
        parent.then((ArgumentBuilder)resetNode);
    }
}

