/*
 * Decompiled with CFR 0.152.
 */
package me.andy.statsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.andy.statsmod.Statsmod;
import me.andy.statsmod.config.SettingsConfig;
import me.andy.statsmod.config.TypeFormattingConfig;
import me.andy.statsmod.stats.PlayerData;
import me.andy.statsmod.util.InteractiveTextParser;
import me.andy.statsmod.util.PermissionUtil;
import me.andy.statsmod.util.PlaceholderContext;
import me.andy.statsmod.util.PlaceholderUtil;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class BiomesCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"biomes").requires(source -> PermissionUtil.checkPermission(source, "statsmod.type.biomes", 0))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            return BiomesCommand.showStats((class_2168)context.getSource(), player, 1);
        })).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            int page = IntegerArgumentType.getInteger((CommandContext)context, (String)"page");
            return BiomesCommand.showStats((class_2168)context.getSource(), player, page);
        }))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(source -> PermissionUtil.checkPermission(source, "statsmod.command.others", 0))).executes(context -> {
            class_3222 target = class_2186.method_9315((CommandContext)context, (String)"player");
            return BiomesCommand.showStats((class_2168)context.getSource(), target, 1);
        })).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            class_3222 target = class_2186.method_9315((CommandContext)context, (String)"player");
            int page = IntegerArgumentType.getInteger((CommandContext)context, (String)"page");
            return BiomesCommand.showStats((class_2168)context.getSource(), target, page);
        })));
        dispatcher.register(command);
    }

    private static int showStats(class_2168 source, class_3222 target, int page) {
        TypeFormattingConfig.TypeConfig typeConfig = Statsmod.getConfigManager().getTypeFormattingConfig().types.get("biomes");
        if (typeConfig == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Missing 'biomes' configuration in types.yml!"));
            return 0;
        }
        SettingsConfig settings = Statsmod.getConfigManager().getSettingsConfig();
        PlayerData playerData = Statsmod.getStatisticsManager().getPlayerData(target.method_5667());
        List relevantStats = playerData.getAllStats().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("visited_biome:") && (Long)entry.getValue() > 0L).sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        if (relevantStats.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"No biomes visited yet."), false);
            return 1;
        }
        int pageSize = settings.page_size;
        int totalPages = (int)Math.ceil((double)relevantStats.size() / (double)pageSize);
        int actualPage = Math.max(1, Math.min(page, totalPages > 0 ? totalPages : 1));
        int startIndex = (actualPage - 1) * pageSize;
        PlaceholderContext headerCtx = new PlaceholderContext.Builder(source, target).withType("biomes", typeConfig.display_name).build();
        Function<String, String> headerReplacer = PlaceholderUtil.createReplacer(headerCtx);
        source.method_9226(() -> class_2561.method_43470((String)" "), false);
        source.method_9226(() -> InteractiveTextParser.parse(typeConfig.header, headerReplacer), false);
        for (int i = startIndex; i < Math.min(startIndex + pageSize, relevantStats.size()); ++i) {
            Map.Entry statEntry = (Map.Entry)relevantStats.get(i);
            String statKey = (String)statEntry.getKey();
            PlaceholderContext lineCtx = new PlaceholderContext.Builder(source, target).withItem(statKey, InteractiveTextParser.getDisplayName(statKey)).build();
            Function<String, String> lineReplacer = PlaceholderUtil.createReplacer(lineCtx);
            source.method_9226(() -> InteractiveTextParser.parse(typeConfig.line_format, lineReplacer), false);
        }
        PlaceholderContext footerCtx = new PlaceholderContext.Builder(source, target).withType("biomes", typeConfig.display_name).withPagination(actualPage, totalPages).build();
        Function<String, String> footerReplacer = PlaceholderUtil.createReplacer(footerCtx);
        source.method_9226(() -> InteractiveTextParser.parse(typeConfig.footer, footerReplacer), false);
        source.method_9226(() -> class_2561.method_43470((String)" "), false);
        return 1;
    }
}

