/*
 * Decompiled with CFR 0.152.
 */
package me.andy.statsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Map;
import me.andy.statsmod.Statsmod;
import me.andy.statsmod.command.BiomesCommand;
import me.andy.statsmod.command.DamagedCommand;
import me.andy.statsmod.command.FlownCommand;
import me.andy.statsmod.command.GenreCommand;
import me.andy.statsmod.command.ProfileCommand;
import me.andy.statsmod.command.StatsCommand;
import me.andy.statsmod.command.TopCommand;
import me.andy.statsmod.command.TypeCommand;
import me.andy.statsmod.config.ConfigManager;
import me.andy.statsmod.config.GenreFormattingConfig;
import me.andy.statsmod.config.TypeFormattingConfig;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;

public class CommandRegistry {
    public static void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            StatsCommand.register((CommandDispatcher<class_2168>)dispatcher);
            ProfileCommand.register((CommandDispatcher<class_2168>)dispatcher);
            TopCommand.register((CommandDispatcher<class_2168>)dispatcher);
            FlownCommand.register((CommandDispatcher<class_2168>)dispatcher);
            DamagedCommand.register((CommandDispatcher<class_2168>)dispatcher);
            BiomesCommand.register((CommandDispatcher<class_2168>)dispatcher);
            CommandRegistry.registerGenreCommands((CommandDispatcher<class_2168>)dispatcher);
            CommandRegistry.registerTypeCommands((CommandDispatcher<class_2168>)dispatcher);
        });
    }

    private static void registerGenreCommands(CommandDispatcher<class_2168> dispatcher) {
        ConfigManager configManager = Statsmod.getConfigManager();
        if (configManager == null || configManager.getGenreFormattingConfig() == null) {
            return;
        }
        Map<String, GenreFormattingConfig.GenreConfig> genres = configManager.getGenreFormattingConfig().genres;
        if (genres == null || genres.isEmpty()) {
            return;
        }
        for (Map.Entry<String, GenreFormattingConfig.GenreConfig> entry : genres.entrySet()) {
            String genreId = entry.getKey();
            GenreFormattingConfig.GenreConfig genreConfig = entry.getValue();
            LiteralArgumentBuilder<class_2168> mainCommand = GenreCommand.buildCommand(genreId);
            dispatcher.register(mainCommand);
            if (genreConfig.aliases == null || genreConfig.aliases.isEmpty()) continue;
            for (String alias : genreConfig.aliases) {
                if (alias.isBlank()) continue;
                dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)alias).redirect((CommandNode)mainCommand.build()));
            }
        }
    }

    private static void registerTypeCommands(CommandDispatcher<class_2168> dispatcher) {
        ConfigManager configManager = Statsmod.getConfigManager();
        if (configManager == null || configManager.getTypeFormattingConfig() == null) {
            return;
        }
        Map<String, TypeFormattingConfig.TypeConfig> types = configManager.getTypeFormattingConfig().types;
        if (types == null || types.isEmpty()) {
            return;
        }
        for (Map.Entry<String, TypeFormattingConfig.TypeConfig> entry : types.entrySet()) {
            String typeId = entry.getKey();
            dispatcher.register(TypeCommand.buildCommand(typeId));
        }
    }
}

