/*
 * Decompiled with CFR 0.152.
 */
package me.andy.statsmod.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.andy.statsmod.Statsmod;
import me.andy.statsmod.config.CommandFormat;
import me.andy.statsmod.config.GenreFormattingConfig;
import me.andy.statsmod.config.SettingsConfig;
import me.andy.statsmod.stats.PlayerData;
import me.andy.statsmod.stats.StatisticsManager;
import me.andy.statsmod.util.InteractiveTextParser;
import me.andy.statsmod.util.PermissionUtil;
import me.andy.statsmod.util.PlaceholderContext;
import me.andy.statsmod.util.PlaceholderUtil;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class GenreCommand {
    private static final Pattern STAT_PLACEHOLDER_PATTERN = Pattern.compile("%([a-zA-Z_]+)_value%|%(value)%|%(played_formatted)%");

    public static LiteralArgumentBuilder<class_2168> buildCommand(String genreId) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)genreId).requires(source -> PermissionUtil.checkPermission(source, "statsmod.genre." + genreId, 0) || PermissionUtil.checkPermission(source, "statsmod.genres", 0))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            return GenreCommand.showStats((class_2168)context.getSource(), player, genreId, 1);
        })).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            int page = IntegerArgumentType.getInteger((CommandContext)context, (String)"page");
            return GenreCommand.showStats((class_2168)context.getSource(), player, genreId, page);
        }))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(source -> PermissionUtil.checkPermission(source, "statsmod.command.others", 0))).executes(context -> {
            class_3222 target = class_2186.method_9315((CommandContext)context, (String)"player");
            return GenreCommand.showStats((class_2168)context.getSource(), target, genreId, 1);
        })).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            class_3222 target = class_2186.method_9315((CommandContext)context, (String)"player");
            int page = IntegerArgumentType.getInteger((CommandContext)context, (String)"page");
            return GenreCommand.showStats((class_2168)context.getSource(), target, genreId, page);
        })));
        return command;
    }

    private static int showStats(class_2168 source, class_3222 target, String genreId, int page) {
        GenreFormattingConfig.GenreConfig genreConfig = Statsmod.getConfigManager().getGenreFormattingConfig().genres.get(genreId);
        if (genreConfig == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Could not find configuration for genre '" + genreId + "'. It may have been removed or renamed in genres.yml.")));
            return 0;
        }
        StatisticsManager statsManager = Statsmod.getStatisticsManager();
        SettingsConfig settings = Statsmod.getConfigManager().getSettingsConfig();
        PlayerData playerData = statsManager.getPlayerData(target.method_5667());
        List<String> rawTrackedIds = Statsmod.getConfigManager().getGenreBlocksConfig().get(genreConfig.listed_blocks_key);
        if (rawTrackedIds == null || rawTrackedIds.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This genre has no statistics to track. Please check genre_blocks.yml."));
            return 0;
        }
        List trackedIds = rawTrackedIds.stream().filter(s -> s != null && !s.startsWith("#")).collect(Collectors.toList());
        if (trackedIds.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This genre has no valid statistics to track after filtering."));
            return 0;
        }
        int pageSize = settings.page_size;
        int totalPages = (int)Math.ceil((double)trackedIds.size() / (double)pageSize);
        int actualPage = Math.max(1, Math.min(page, totalPages > 0 ? totalPages : 1));
        int startIndex = (actualPage - 1) * pageSize;
        CommandFormat format = new CommandFormat(genreConfig.header, genreConfig.line_format, genreConfig.footer);
        PlaceholderContext headerCtx = new PlaceholderContext.Builder(source, target).withGenre(genreId, genreConfig.display_name).build();
        Function<String, String> headerReplacer = PlaceholderUtil.createReplacer(headerCtx);
        String processedHeader = headerReplacer.apply(format.header);
        long genreBroken = statsManager.getGenreStatisticTotal(target.method_5667(), genreId, "broken:");
        long genrePlaced = statsManager.getGenreStatisticTotal(target.method_5667(), genreId, "placed:");
        long genrePickedUp = statsManager.getGenreStatisticTotal(target.method_5667(), genreId, "pickedup:");
        long genreHarvested = statsManager.getGenreStatisticTotal(target.method_5667(), genreId, "harvested:");
        processedHeader = processedHeader.replace("%genre_total_broken%", String.valueOf(genreBroken));
        processedHeader = processedHeader.replace("%genre_total_placed%", String.valueOf(genrePlaced));
        processedHeader = processedHeader.replace("%genre_total_pickedup%", String.valueOf(genrePickedUp));
        String finalProcessedHeader = processedHeader = processedHeader.replace("%genre_total_harvested%", String.valueOf(genreHarvested));
        source.method_9226(() -> InteractiveTextParser.parse(finalProcessedHeader, s -> s), false);
        for (int i = startIndex; i < Math.min(startIndex + pageSize, trackedIds.size()); ++i) {
            String currentTrackedId = (String)trackedIds.get(i);
            String displayName = InteractiveTextParser.getDisplayName(currentTrackedId);
            PlaceholderContext lineCtx = new PlaceholderContext.Builder(source, target).withGenre(genreId, genreConfig.display_name).withItem(currentTrackedId, displayName).withStat(currentTrackedId).build();
            Function<String, String> lineReplacer = PlaceholderUtil.createReplacer(lineCtx);
            String processedLine = lineReplacer.apply(format.line_format);
            Matcher matcher = STAT_PLACEHOLDER_PATTERN.matcher(processedLine);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String typePrefix = matcher.group(1);
                String valuePlaceholder = matcher.group(2);
                String formattedTimePlaceholder = matcher.group(3);
                String replacementValue = "0";
                if (formattedTimePlaceholder != null) {
                    replacementValue = currentTrackedId.equals("played") ? PlaceholderUtil.formatDuration(playerData.getStat(currentTrackedId)) : "0s";
                } else if (valuePlaceholder != null) {
                    long value = playerData.getStat(currentTrackedId);
                    replacementValue = currentTrackedId.equals("played") ? PlaceholderUtil.formatDuration(value) : String.valueOf(value);
                } else if (typePrefix != null) {
                    String fullStatKey = typePrefix + ":" + currentTrackedId;
                    replacementValue = String.valueOf(playerData.getStat(fullStatKey));
                }
                matcher.appendReplacement(sb, Matcher.quoteReplacement(replacementValue));
            }
            matcher.appendTail(sb);
            source.method_9226(() -> InteractiveTextParser.parse(sb.toString(), s -> s), false);
        }
        PlaceholderContext footerCtx = new PlaceholderContext.Builder(source, target).withGenre(genreId, genreConfig.display_name).withPagination(actualPage, totalPages).build();
        Function<String, String> footerReplacer = PlaceholderUtil.createReplacer(footerCtx);
        source.method_9226(() -> InteractiveTextParser.parse(format.footer, footerReplacer), false);
        source.method_9226(() -> class_2561.method_43470((String)" "), false);
        return 1;
    }
}

