/*
 * Decompiled with CFR 0.152.
 */
package me.andy.statsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import me.andy.statsmod.Statsmod;
import me.andy.statsmod.command.AdminCommands;
import me.andy.statsmod.util.InteractiveTextParser;
import me.andy.statsmod.util.PermissionUtil;
import me.andy.statsmod.util.PlaceholderContext;
import me.andy.statsmod.util.PlaceholderUtil;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7225;

public class StatsmodCommand {
    private static List<List<String>> ALL_HELP_PAGES = Collections.emptyList();
    private static final List<String> PAGE1_HELP_LINES = List.of("", "&6&m                        &r  &6StatsMod Commands:  &6&m                        ", "&7Click commands to auto-fill chat.", "&b&lGeneral &7- &a/profile &7| &a/top 'genre'", "&b&lGathering &7- &a/mining &7| &a/digging &7| &a/woodcutting &7| &a/farming", "&b&lProduction &7- &a/crafting &7| &a/smelting &7| &a/brewing &7| &a/enchanting", "&b&lOther &7- &a/combat &7| &a/husbandry &7| &a/fishing &7| &a/exploration", "", "&dClick for Admin Commands &7(Page 2)<action:run_command,/statsmod page 2>", "&7/sm is an alias. &6[Discord Link]<action:open_url,https://discord.gg/GpryZU8QHK>");
    private static final List<String> PAGE2_HELP_LINES = List.of("", "&c&m                        &r  &cAdmin Commands:  &c&m                        ", "&7Click commands to suggest them in chat.", "&d/statsmod reload{Reloads all configs of StatsMod after edits.}<action:suggest_command,/statsmod reload>", "&d/statsmod debug{Toggles extra console logging for developers.}<action:suggest_command,/statsmod debug>", "&d/statsmod migrate{Copies all data from files to the database.}<action:suggest_command,/statsmod migrate>", "&d/statsmod reset...{Resets stats for a player, a genre, or the server.}<action:suggest_command,/statsmod reset>", "&d/statsmod set...{Manually sets a specific stat for a player.}<action:suggest_command,/statsmod set>", "", "&aClick to go back &7(Page 1)<action:run_command,/statsmod page 1>", "&6[Discord Link]<action:open_url,https://discord.gg/GpryZU8QHK>");

    private static void initializeHelpPages() {
        ALL_HELP_PAGES = new ArrayList<List<String>>();
        try {
            Statsmod.LOGGER.info("Initializing StatsMod help pages.");
            ArrayList<List<String>> tempCombinedPages = new ArrayList<List<String>>();
            tempCombinedPages.add(PAGE1_HELP_LINES);
            tempCombinedPages.add(PAGE2_HELP_LINES);
            ALL_HELP_PAGES = List.copyOf(tempCombinedPages);
            Statsmod.LOGGER.info("Total StatsMod help pages loaded: {}", (Object)ALL_HELP_PAGES.size());
        }
        catch (Throwable e) {
            Statsmod.LOGGER.error("CRITICAL ERROR during StatsMod help page initialization. Command will likely fail.", e);
            ALL_HELP_PAGES = List.of(List.of("&cAn internal error occurred while loading help pages."));
        }
    }

    public static void init() {
        CommandRegistrationCallback.EVENT.register(StatsmodCommand::register);
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7225.class_7874 registryAccess, class_2170.class_5364 environment) {
        StatsmodCommand.initializeHelpPages();
        LiteralArgumentBuilder statsmodCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"statsmod").requires(source -> PermissionUtil.checkPermission(source, "statsmod.command.base", 0))).executes(context -> StatsmodCommand.showHelpPage((CommandContext<class_2168>)context, 1))).then(class_2170.method_9247((String)"page").then(class_2170.method_9244((String)"page_num", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> StatsmodCommand.showHelpPage((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"page_num")))));
        AdminCommands.registerAdminCommands((LiteralArgumentBuilder<class_2168>)statsmodCommand);
        LiteralCommandNode mainStatsmodCommandNode = dispatcher.register(statsmodCommand);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sm").requires(source -> PermissionUtil.checkPermission(source, "statsmod.command.base", 0))).executes(context -> StatsmodCommand.showHelpPage((CommandContext<class_2168>)context, 1))).redirect((CommandNode)mainStatsmodCommandNode));
    }

    private static int showHelpPage(CommandContext<class_2168> context, int pageNum) {
        class_2168 source = (class_2168)context.getSource();
        if (ALL_HELP_PAGES.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"StatsMod help pages could not be loaded. Check server console for errors."));
            return 0;
        }
        int totalPages = ALL_HELP_PAGES.size();
        int actualPageNum = Math.max(1, Math.min(pageNum, totalPages));
        List<String> rawHelpLines = ALL_HELP_PAGES.get(actualPageNum - 1);
        source.method_9226(() -> class_2561.method_43470((String)" "), false);
        class_3222 player = null;
        try {
            player = source.method_9207();
        }
        catch (Exception exception) {
            // empty catch block
        }
        PlaceholderContext ctx = new PlaceholderContext.Builder(source, player).build();
        Function<String, String> replacer = PlaceholderUtil.createReplacer(ctx);
        for (String line : rawHelpLines) {
            source.method_9226(() -> InteractiveTextParser.parse(line, replacer), false);
        }
        source.method_9226(() -> class_2561.method_43470((String)" "), false);
        return 1;
    }
}

