/*
 * Decompiled with CFR 0.152.
 */
package me.andy.statsmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.andy.statsmod.Statsmod;
import me.andy.statsmod.config.CommandFormat;
import me.andy.statsmod.config.GenreFormattingConfig;
import me.andy.statsmod.config.SettingsConfig;
import me.andy.statsmod.config.TopFormattingConfig;
import me.andy.statsmod.config.TypeFormattingConfig;
import me.andy.statsmod.stats.PlayerData;
import me.andy.statsmod.stats.StatisticsManager;
import me.andy.statsmod.util.InteractiveTextParser;
import me.andy.statsmod.util.PlaceholderContext;
import me.andy.statsmod.util.PlaceholderUtil;
import net.minecraft.class_11560;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class TopCommand {
    private static final Set<String> NON_PREFIXED_STATS = Set.of("played", "biomes", "distance", "walked", "sprinted", "crouched", "swum", "flown", "elytra", "deaths", "players_killed", "total_broken", "total_placed", "total_mobs_killed", "total_crafted", "total_harvested", "total_animals_bred", "total_fished", "total_smelted", "total_brewed", "total_enchanted", "total_pickedup", "total_traded", "damaged:dealt", "damaged:taken");
    private static final SuggestionProvider<class_2168> TOP_COMMAND_SUGGESTIONS = (context, builder) -> {
        TypeFormattingConfig typeConfig;
        GenreFormattingConfig genreConfig = Statsmod.getConfigManager().getGenreFormattingConfig();
        if (genreConfig != null && genreConfig.genres != null) {
            genreConfig.genres.keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        }
        if ((typeConfig = Statsmod.getConfigManager().getTypeFormattingConfig()) != null && typeConfig.types != null) {
            typeConfig.types.keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        }
        builder.suggest("damaged");
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"top").then(class_2170.method_9244((String)"identifier", (ArgumentType)StringArgumentType.greedyString()).suggests(TOP_COMMAND_SUGGESTIONS).executes(context -> {
            String identifier = StringArgumentType.getString((CommandContext)context, (String)"identifier");
            class_2168 source = (class_2168)context.getSource();
            GenreFormattingConfig genreFormattingConfig = Statsmod.getConfigManager().getGenreFormattingConfig();
            TypeFormattingConfig typeFormattingConfig = Statsmod.getConfigManager().getTypeFormattingConfig();
            if ("flown".equalsIgnoreCase(identifier)) {
                return TopCommand.showSpecificTopList(source, "flown");
            }
            if ("damaged".equalsIgnoreCase(identifier)) {
                return TopCommand.showDamagedTopList(source);
            }
            if (genreFormattingConfig.genres.containsKey(identifier)) {
                return TopCommand.showGenreTopList(source, identifier, genreFormattingConfig.genres.get(identifier));
            }
            if (typeFormattingConfig.types.containsKey(identifier)) {
                return TopCommand.showTypeTopList(source, identifier);
            }
            return TopCommand.showSpecificTopList(source, identifier);
        })));
    }

    private static int showDamagedTopList(class_2168 source) {
        return TopCommand.showSpecificTopList(source, "damaged:dealt");
    }

    private static int showGenreTopList(class_2168 source, String genreId, GenreFormattingConfig.GenreConfig genreConfig) {
        SettingsConfig settings = Statsmod.getConfigManager().getSettingsConfig();
        TopFormattingConfig topConfig = Statsmod.getConfigManager().getTopFormattingConfig();
        StatisticsManager statsManager = Statsmod.getStatisticsManager();
        CommandFormat format = topConfig.formats.getOrDefault(genreId, topConfig.formats.get("default"));
        if (format == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Error: No top list format found for genre '" + genreId + "' or default.")));
            return 0;
        }
        String rankingStat = genreConfig.ranking_stat;
        if (rankingStat == null || rankingStat.isBlank()) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Error: Ranking statistic for genre '" + genreId + "' is not defined in genres.yml.")));
            return 0;
        }
        LinkedHashMap playerTotals = new LinkedHashMap();
        statsManager.getAllPlayerData().forEach((uuid, playerData) -> {
            long total = statsManager.getGenreStatisticTotal((UUID)uuid, genreId, rankingStat.replace("total_", "") + ":");
            if (total > 0L) {
                playerTotals.put(uuid, total);
            }
        });
        List sortedPlayers = playerTotals.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).collect(Collectors.toList());
        PlaceholderContext headerCtx = new PlaceholderContext.Builder(source, null).withGenre(genreId, genreConfig.display_name).build();
        source.method_9226(() -> InteractiveTextParser.parse(format.header, PlaceholderUtil.createReplacer(headerCtx)), false);
        int rankLimit = Math.min(settings.top_list_size, sortedPlayers.size());
        for (int i = 0; i < rankLimit; ++i) {
            Map.Entry entry = (Map.Entry)sortedPlayers.get(i);
            String playerName = source.method_9211().method_73550().comp_4407().method_14512((UUID)entry.getKey()).map(class_11560::comp_4423).orElse("Unknown Player");
            long value = (Long)entry.getValue();
            int rank = i + 1;
            PlaceholderContext lineCtx = new PlaceholderContext.Builder(source, null).withGenre(genreId, genreConfig.display_name).withRank(rank).withValue(value).build();
            Function<String, String> lineReplacer = s -> PlaceholderUtil.createReplacer(lineCtx).apply((String)s).replace("%player%", playerName);
            source.method_9226(() -> InteractiveTextParser.parse(format.line_format, lineReplacer), false);
        }
        source.method_9226(() -> InteractiveTextParser.parse(format.footer, s -> s), false);
        source.method_9226(() -> class_2561.method_43470((String)" "), false);
        return 1;
    }

    private static int showTypeTopList(class_2168 source, String typeId) {
        SettingsConfig settings = Statsmod.getConfigManager().getSettingsConfig();
        TopFormattingConfig topConfig = Statsmod.getConfigManager().getTopFormattingConfig();
        TypeFormattingConfig typeConfig = Statsmod.getConfigManager().getTypeFormattingConfig();
        String displayName = typeConfig.types.get((Object)typeId).display_name;
        CommandFormat format = topConfig.formats.getOrDefault(typeId, topConfig.formats.get("default"));
        LinkedHashMap<UUID, Long> playerTotals = new LinkedHashMap<UUID, Long>();
        boolean isPrefixed = !NON_PREFIXED_STATS.contains(typeId);
        String prefix = typeId + ":";
        for (Map.Entry<UUID, PlayerData> playerEntry : Statsmod.getStatisticsManager().getAllPlayerData().entrySet()) {
            long total = isPrefixed ? playerEntry.getValue().getAllStats().entrySet().stream().filter(statEntry -> ((String)statEntry.getKey()).startsWith(prefix)).mapToLong(Map.Entry::getValue).sum() : playerEntry.getValue().getStat(typeId);
            if (total <= 0L) continue;
            playerTotals.put(playerEntry.getKey(), total);
        }
        List sortedPlayers = playerTotals.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).collect(Collectors.toList());
        if (sortedPlayers.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)("\u00a7cNo data found for statistic type: " + displayName)), false);
            return 1;
        }
        source.method_9226(() -> class_2561.method_43470((String)" "), false);
        PlaceholderContext headerCtx = new PlaceholderContext.Builder(source, null).withType(typeId, displayName).withItem("", displayName).build();
        source.method_9226(() -> InteractiveTextParser.parse(format.header, PlaceholderUtil.createReplacer(headerCtx)), false);
        int rankLimit = Math.min(settings.top_list_size, sortedPlayers.size());
        for (int i = 0; i < rankLimit; ++i) {
            Map.Entry entry = (Map.Entry)sortedPlayers.get(i);
            String playerName = source.method_9211().method_73550().comp_4407().method_14512((UUID)entry.getKey()).map(class_11560::comp_4423).orElse("Unknown Player");
            long value = (Long)entry.getValue();
            int rank = i + 1;
            PlaceholderContext lineCtx = new PlaceholderContext.Builder(source, null).withType(typeId, displayName).withItem("", displayName).withRank(rank).withValue(value).build();
            Function<String, String> lineReplacer = s -> PlaceholderUtil.createReplacer(lineCtx).apply((String)s).replace("%player%", playerName);
            source.method_9226(() -> InteractiveTextParser.parse(format.line_format, lineReplacer), false);
        }
        source.method_9226(() -> InteractiveTextParser.parse(format.footer, s -> s), false);
        source.method_9226(() -> class_2561.method_43470((String)" "), false);
        return 1;
    }

    private static int showSpecificTopList(class_2168 source, String statKey) {
        SettingsConfig settings = Statsmod.getConfigManager().getSettingsConfig();
        TopFormattingConfig topConfig = Statsmod.getConfigManager().getTopFormattingConfig();
        String effectiveStatKey = "flown".equals(statKey) ? "elytra" : statKey;
        CommandFormat format = topConfig.formats.getOrDefault(statKey, topConfig.formats.get("default"));
        if (format == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Error: No top list format found for statistic '" + statKey + "' or default.")));
            return 0;
        }
        String displayName = "flown".equals(statKey) ? "Elytra Flight" : InteractiveTextParser.getDisplayName(statKey);
        List sortedPlayers = Statsmod.getStatisticsManager().getAllPlayerData().entrySet().stream().filter(entry -> ((PlayerData)entry.getValue()).getStat(effectiveStatKey) > 0L).sorted(Comparator.comparingLong(entry -> -((PlayerData)entry.getValue()).getStat(effectiveStatKey))).collect(Collectors.toList());
        if (sortedPlayers.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)("\u00a7cNo data found for statistic: " + displayName)), false);
            return 1;
        }
        source.method_9226(() -> class_2561.method_43470((String)" "), false);
        PlaceholderContext headerCtx = new PlaceholderContext.Builder(source, null).withStat(effectiveStatKey).withItem(effectiveStatKey, displayName).build();
        source.method_9226(() -> InteractiveTextParser.parse(format.header, PlaceholderUtil.createReplacer(headerCtx)), false);
        int rankLimit = Math.min(settings.top_list_size, sortedPlayers.size());
        for (int i = 0; i < rankLimit; ++i) {
            Map.Entry entry2 = (Map.Entry)sortedPlayers.get(i);
            String playerName = source.method_9211().method_73550().comp_4407().method_14512((UUID)entry2.getKey()).map(class_11560::comp_4423).orElse("Unknown Player");
            long value = ((PlayerData)entry2.getValue()).getStat(effectiveStatKey);
            int rank = i + 1;
            PlaceholderContext lineCtx = new PlaceholderContext.Builder(source, null).withStat(effectiveStatKey).withItem(effectiveStatKey, displayName).withRank(rank).withValue(value).build();
            Function<String, String> lineReplacer = s -> {
                String processed = PlaceholderUtil.createReplacer(lineCtx).apply((String)s).replace("%player%", playerName);
                if ("played".equals(effectiveStatKey)) {
                    processed = processed.replace(String.valueOf(value), PlaceholderUtil.formatDuration(value));
                }
                return processed;
            };
            source.method_9226(() -> InteractiveTextParser.parse(format.line_format, lineReplacer), false);
        }
        source.method_9226(() -> InteractiveTextParser.parse(format.footer, s -> s), false);
        source.method_9226(() -> class_2561.method_43470((String)" "), false);
        return 1;
    }
}

