/*
 * Decompiled with CFR 0.152.
 */
package me.andy.statsmod.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.andy.statsmod.Statsmod;
import me.andy.statsmod.config.CommandFormat;
import me.andy.statsmod.config.SettingsConfig;
import me.andy.statsmod.config.TypeFormattingConfig;
import me.andy.statsmod.stats.PlayerData;
import me.andy.statsmod.util.InteractiveTextParser;
import me.andy.statsmod.util.PermissionUtil;
import me.andy.statsmod.util.PlaceholderContext;
import me.andy.statsmod.util.PlaceholderUtil;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class TypeCommand {
    private static final Set<String> NON_PREFIXED_STATS = Set.of("distance", "walked", "sprinted", "crouched", "swum", "flown", "elytra", "played", "biomes", "deaths", "players_killed");

    public static LiteralArgumentBuilder<class_2168> buildCommand(String typeId) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)typeId).requires(source -> PermissionUtil.checkPermission(source, "statsmod.type." + typeId, 0) || PermissionUtil.checkPermission(source, "statsmod.types", 0))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            return TypeCommand.showStats((class_2168)context.getSource(), player, typeId, 1);
        })).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            int page = IntegerArgumentType.getInteger((CommandContext)context, (String)"page");
            return TypeCommand.showStats((class_2168)context.getSource(), player, typeId, page);
        }))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(source -> PermissionUtil.checkPermission(source, "statsmod.command.others", 0))).executes(context -> {
            class_3222 target = class_2186.method_9315((CommandContext)context, (String)"player");
            return TypeCommand.showStats((class_2168)context.getSource(), target, typeId, 1);
        })).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            class_3222 target = class_2186.method_9315((CommandContext)context, (String)"player");
            int page = IntegerArgumentType.getInteger((CommandContext)context, (String)"page");
            return TypeCommand.showStats((class_2168)context.getSource(), target, typeId, page);
        })));
    }

    private static int showStats(class_2168 source, class_3222 target, String typeId, int page) {
        TypeFormattingConfig.TypeConfig typeConfig = Statsmod.getConfigManager().getTypeFormattingConfig().types.get(typeId);
        if (typeConfig == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Could not find configuration for type '" + typeId + "'. It may have been removed.")));
            return 0;
        }
        SettingsConfig settings = Statsmod.getConfigManager().getSettingsConfig();
        PlayerData playerData = Statsmod.getStatisticsManager().getPlayerData(target.method_5667());
        boolean isNonPrefixed = NON_PREFIXED_STATS.contains(typeId) || typeId.startsWith("total_");
        String prefix = typeId + ":";
        List relevantStats = (isNonPrefixed ? playerData.getAllStats().entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(typeId) && (Long)entry.getValue() > 0L) : playerData.getAllStats().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(prefix) && (Long)entry.getValue() > 0L)).sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toList());
        if (relevantStats.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"No stats found for this type."), false);
            return 1;
        }
        int pageSize = settings.page_size;
        int totalPages = (int)Math.ceil((double)relevantStats.size() / (double)pageSize);
        int actualPage = Math.max(1, Math.min(page, totalPages > 0 ? totalPages : 1));
        int startIndex = (actualPage - 1) * pageSize;
        CommandFormat format = new CommandFormat(typeConfig.header, typeConfig.line_format, typeConfig.footer);
        PlaceholderContext headerCtx = new PlaceholderContext.Builder(source, target).withType(typeId, typeConfig.display_name).build();
        source.method_9226(() -> InteractiveTextParser.parse(format.header, PlaceholderUtil.createReplacer(headerCtx)), false);
        for (int i = startIndex; i < Math.min(startIndex + pageSize, relevantStats.size()); ++i) {
            Map.Entry statEntry = (Map.Entry)relevantStats.get(i);
            String statKey = (String)statEntry.getKey();
            long value = (Long)statEntry.getValue();
            PlaceholderContext lineCtx = new PlaceholderContext.Builder(source, target).withStat(statKey).withItem(statKey, InteractiveTextParser.getDisplayName(statKey)).withValue(value).build();
            Function<String, String> lineReplacer = s -> {
                String processed = PlaceholderUtil.createReplacer(lineCtx).apply((String)s);
                if (statKey.equals("played")) {
                    processed = processed.replace(String.valueOf(value), PlaceholderUtil.formatDuration(value));
                }
                return processed;
            };
            source.method_9226(() -> InteractiveTextParser.parse(format.line_format, lineReplacer), false);
        }
        PlaceholderContext footerCtx = new PlaceholderContext.Builder(source, target).withType(typeId, typeConfig.display_name).withPagination(actualPage, totalPages).build();
        source.method_9226(() -> InteractiveTextParser.parse(format.footer, PlaceholderUtil.createReplacer(footerCtx)), false);
        source.method_9226(() -> class_2561.method_43470((String)" "), false);
        return 1;
    }
}

