/*
 * Decompiled with CFR 0.152.
 */
package me.andy.statsmod.config;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.andy.statsmod.Statsmod;
import me.andy.statsmod.config.CommandFormat;
import me.andy.statsmod.config.GenreFormattingConfig;
import me.andy.statsmod.config.ProfileFormattingConfig;
import me.andy.statsmod.config.SettingsConfig;
import me.andy.statsmod.config.StatsCommandFormattingConfig;
import me.andy.statsmod.config.TopFormattingConfig;
import me.andy.statsmod.config.TypeFormattingConfig;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class ConfigManager {
    private final Path configDir = Path.of("config/StatsMod", new String[0]);
    private SettingsConfig settingsConfig;
    private Map<String, List<String>> genreBlocksConfig;
    private GenreFormattingConfig genreFormattingConfig;
    private TypeFormattingConfig typeFormattingConfig;
    private TopFormattingConfig topFormattingConfig;
    private ProfileFormattingConfig profileFormattingConfig;
    private StatsCommandFormattingConfig statsCommandFormattingConfig;
    private static final Set<String> ENTITY_EXCLUSIONS = Set.of("minecraft:player", "minecraft:item", "minecraft:experience_orb", "minecraft:marker", "minecraft:area_effect_cloud", "minecraft:item_frame", "minecraft:glow_item_frame", "minecraft:painting", "minecraft:fishing_bobber");

    public SettingsConfig getSettingsConfig() {
        return this.settingsConfig;
    }

    public Map<String, List<String>> getGenreBlocksConfig() {
        return this.genreBlocksConfig;
    }

    public GenreFormattingConfig getGenreFormattingConfig() {
        return this.genreFormattingConfig;
    }

    public TypeFormattingConfig getTypeFormattingConfig() {
        return this.typeFormattingConfig;
    }

    public TopFormattingConfig getTopFormattingConfig() {
        return this.topFormattingConfig;
    }

    public ProfileFormattingConfig getProfileFormattingConfig() {
        return this.profileFormattingConfig;
    }

    public StatsCommandFormattingConfig getStatsCommandFormattingConfig() {
        return this.statsCommandFormattingConfig;
    }

    public void loadConfigs() {
        try {
            Files.createDirectories(this.configDir, new FileAttribute[0]);
            this.settingsConfig = this.loadConfig("settings.yml", SettingsConfig.class);
            this.genreBlocksConfig = this.loadGenreBlocksConfig("genre_blocks.yml");
            this.genreFormattingConfig = this.loadConfig("genres.yml", GenreFormattingConfig.class);
            this.typeFormattingConfig = this.loadConfig("types.yml", TypeFormattingConfig.class);
            this.topFormattingConfig = this.loadConfig("top.yml", TopFormattingConfig.class);
            this.profileFormattingConfig = this.loadConfig("profile.yml", ProfileFormattingConfig.class);
            this.statsCommandFormattingConfig = this.loadConfig("stats_command.yml", StatsCommandFormattingConfig.class);
            Statsmod.LOGGER.info("All configurations loaded successfully.");
        }
        catch (IOException e) {
            Statsmod.LOGGER.error("Failed to load configurations", (Throwable)e);
        }
    }

    private <T> T loadConfig(String fileName, Class<T> clazz) throws IOException {
        File configFile = this.configDir.resolve(fileName).toFile();
        if (!configFile.exists()) {
            Statsmod.LOGGER.info("Default config not found, creating '{}'", (Object)fileName);
            this.generateDefaultConfig(fileName);
        }
        try (FileReader reader = new FileReader(configFile);){
            Yaml yaml = new Yaml((BaseConstructor)new Constructor(clazz, new LoaderOptions()));
            Object object = yaml.load((Reader)reader);
            return (T)object;
        }
    }

    private Map<String, List<String>> loadGenreBlocksConfig(String fileName) throws IOException {
        File configFile = this.configDir.resolve(fileName).toFile();
        if (!configFile.exists()) {
            Statsmod.LOGGER.info("Default config not found, creating '{}'", (Object)fileName);
            this.generateDefaultConfig(fileName);
        }
        try (FileReader reader = new FileReader(configFile);){
            Yaml yaml = new Yaml(new LoaderOptions());
            Map map = (Map)yaml.load((Reader)reader);
            return map;
        }
    }

    private void generateDefaultConfig(String fileName) throws IOException {
        Object configObject = null;
        ArrayList<String> comments = new ArrayList<String>();
        switch (fileName) {
            case "settings.yml": {
                configObject = this.generateDefaultSettingsConfig();
                comments.add("# General settings for the StatsMod.");
                break;
            }
            case "genre_blocks.yml": {
                configObject = this.generateDefaultGenreBlocksConfig();
                comments.add("# This file lists the block, item, and entity IDs used by the different genres in genres.yml.");
                break;
            }
            case "genres.yml": {
                configObject = this.generateDefaultGenreFormattingConfig();
                comments.add("# Configuration for genre-based statistics commands (e.g., /mining, /combat).");
                comments.add("# Each entry defines a genre, its display name, the list of IDs it tracks (from genre_blocks.yml), and its command formatting.");
                break;
            }
            case "types.yml": {
                configObject = this.generateDefaultTypeFormattingConfig();
                comments.add("# Configuration for specific statistic types commands (e.g., /broken, /crafted).");
                comments.add("# Each entry defines a type, its display name, and its command formatting.");
                break;
            }
            case "top.yml": {
                configObject = this.generateDefaultTopFormattingConfig();
                comments.add("# Configuration for the /top command's display formats.");
                comments.add("# Define custom formats for specific genres or statistic types.");
                comments.add("# If a specific format is not found, a general 'default' will be used.");
                break;
            }
            case "profile.yml": {
                configObject = this.generateDefaultProfileFormattingConfig();
                comments.add("# Configuration for the /profile command layout.");
                comments.add("# You can use various placeholders like %player%, %total_broken%, %played_formatted%, etc.");
                comments.add("# You can also show a player's top stat in a genre, e.g., %mining_top_display_name% and %mining_top_value%.");
                break;
            }
            case "stats_command.yml": {
                configObject = this.generateDefaultStatsCommandFormattingConfig();
                comments.add("# This file configures the main /stats help command.");
            }
        }
        if (configObject != null) {
            if (fileName.equals("top.yml")) {
                this.writeTopConfigWithComments((TopFormattingConfig)configObject, comments);
                return;
            }
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            options.setPrettyFlow(true);
            options.setIndent(2);
            options.setSplitLines(false);
            Representer representer = new Representer(options);
            representer.addClassTag(configObject.getClass(), Tag.MAP);
            Yaml yaml = new Yaml(representer, options);
            try (FileWriter writer = new FileWriter(this.configDir.resolve(fileName).toFile());){
                for (String comment : comments) {
                    writer.write(comment + "\n");
                }
                if (!comments.isEmpty()) {
                    writer.write("\n");
                }
                yaml.dump(configObject, (Writer)writer);
            }
        }
    }

    private void writeTopConfigWithComments(TopFormattingConfig topConfig, List<String> headerComments) throws IOException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        options.setIndent(2);
        options.setSplitLines(false);
        Representer representer = new Representer(options);
        representer.addClassTag(CommandFormat.class, Tag.MAP);
        Yaml yaml = new Yaml(representer, options);
        try (FileWriter writer = new FileWriter(this.configDir.resolve("top.yml").toFile());){
            for (String comment : headerComments) {
                writer.write(comment + "\n");
            }
            writer.write("\nformats:\n");
            writer.write("  # The 'default' format is a fallback for any stat that doesn't have a specific format defined below.\n");
            writer.write("  # It's used for /top [stat_id] when a more specific genre or type format isn't available.\n");
            String defaultYaml = yaml.dump(Map.of("default", topConfig.formats.get("default")));
            writer.write(this.indent(defaultYaml, 2));
            writer.write("\n");
            writer.write("  # --- Genre Top Formats ---\n");
            List<String> genreKeys = List.of("mining", "digging", "woodcutting", "building", "crafting", "smelting", "brewing", "enchanting", "combat", "farming", "husbandry", "fishing", "exploration");
            LinkedHashMap genreFormats = new LinkedHashMap();
            genreKeys.forEach(key -> genreFormats.put(key, topConfig.formats.get(key)));
            String genresYaml = yaml.dump(genreFormats);
            writer.write(this.indent(genresYaml, 2));
            writer.write("\n");
            writer.write("  # --- Type Top Formats (for individual stat keys like \"broken:minecraft:stone\") ---\n");
            writer.write("  # The formats below are for general types (e.g., /top broken). For specific items, you can add a new entry.\n");
            writer.write("  # The 'default' format is usually sufficient, as it uses %display_name%.\n");
            writer.write("  # Example for a specific stat:\n");
            writer.write("  # \"broken:minecraft:diamond_ore\":\n");
            writer.write("  #   header: \"&b--- Top Diamond Miners ---\"\n");
            writer.write("  #   line_format: \"&e#%rank%. &a%player% &7- &b%value% Diamond Ore Broken\"\n");
            writer.write("  #   footer: \"&7May their picks never break.\"\n\n");
            List<String> typeKeys = List.of("broken", "placed", "killed", "died", "crafted", "smelted", "brewed", "enchanted", "used", "pickedup", "bred", "harvested", "fished", "traded", "damaged", "played", "distance", "walked", "sprinted", "crouched", "swum", "flown", "elytra", "biomes", "total_broken", "total_placed", "total_mobs_killed", "players_killed", "deaths", "total_crafted", "total_harvested", "total_animals_bred", "total_fished", "total_traded");
            LinkedHashMap typeFormats = new LinkedHashMap();
            typeKeys.forEach(key -> {
                if (topConfig.formats.containsKey(key)) {
                    typeFormats.put(key, topConfig.formats.get(key));
                }
            });
            String typesYaml = yaml.dump(typeFormats);
            writer.write(this.indent(typesYaml, 2));
        }
    }

    private String indent(String text, int spaces) {
        String indentation = " ".repeat(spaces);
        return Arrays.stream(text.split("\n")).map(line -> indentation + line).collect(Collectors.joining("\n"));
    }

    private String capitalizeFully(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return Arrays.stream(str.split(" ")).map(word -> {
            if (word.isEmpty()) {
                return word;
            }
            return word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase();
        }).collect(Collectors.joining(" "));
    }

    private SettingsConfig generateDefaultSettingsConfig() {
        SettingsConfig config = new SettingsConfig();
        config.debug_mode = false;
        config.page_size = 14;
        config.top_list_size = 14;
        config.database = new SettingsConfig.DatabaseConfig();
        config.database.enabled = false;
        config.database.type = "sqlite";
        config.database.url = "stats.db";
        config.database.username = "";
        config.database.password = "";
        return config;
    }

    private Map<String, List<String>> generateDefaultGenreBlocksConfig() {
        LinkedHashMap<String, List<String>> blocks = new LinkedHashMap<String, List<String>>();
        blocks.put("mining", this.getMiningBlocks());
        blocks.put("digging", this.getDiggingBlocks());
        blocks.put("woodcutting", this.getWoodcuttingBlocks());
        blocks.put("building", this.getBuildingBlocks());
        blocks.put("craftable_items", this.getCraftableItems());
        blocks.put("smeltable_items", this.getSmeltableItems());
        blocks.put("brewable_items", this.getBrewableItems());
        blocks.put("enchantable_items", this.getEnchantableItems());
        blocks.put("killable_entities", this.getKillableEntitiesAndDeathReasons());
        blocks.put("farming_blocks", this.getFarmingBlocks());
        blocks.put("breedable_animals", this.getBreedableAnimals());
        blocks.put("fished_items", this.getFishedItems());
        blocks.put("exploration_stats", this.getExplorationStats());
        return blocks;
    }

    private GenreFormattingConfig generateDefaultGenreFormattingConfig() {
        GenreFormattingConfig config = new GenreFormattingConfig();
        config.genres = new LinkedHashMap<String, GenreFormattingConfig.GenreConfig>();
        GenreFormattingConfig.GenreConfig mining = new GenreFormattingConfig.GenreConfig();
        mining.display_name = "Mining";
        mining.aliases = new ArrayList<String>();
        mining.listed_blocks_key = "mining";
        mining.ranking_stat = "total_broken";
        mining.header = "&6--- %genre_display_name% for %player% ---\\n&7Broken: &b%genre_total_broken% &7| Placed: &b%genre_total_placed% &7| Picked Up: &b%genre_total_pickedup%";
        mining.line_format = "&e%display_name%<action:run_command,top broken:%item_id%> &7- Broken: &b%broken_value% &7| Placed: &b%placed_value% &7| Picked Up: &b%pickedup_value%";
        mining.footer = "&a[Prev]<action:run_command,%genre_id% %player% %prev_page%>  &7Page &b%current_page%/%total_pages%  <&a[Next]<action:run_command,%genre_id% %player% %next_page%>";
        config.genres.put("mining", mining);
        GenreFormattingConfig.GenreConfig digging = new GenreFormattingConfig.GenreConfig();
        digging.display_name = "Digging";
        digging.aliases = new ArrayList<String>();
        digging.listed_blocks_key = "digging";
        digging.ranking_stat = "total_broken";
        digging.header = "&6--- %genre_display_name% for %player% ---\\n&7Broken: &b%genre_total_broken% &7| Placed: &b%genre_total_placed% &7| Picked Up: &b%genre_total_pickedup%";
        digging.line_format = "&e%display_name%<action:run_command,top broken:%item_id%> &7- Broken: &b%broken_value% &7| Placed: &b%placed_value% &7| Picked Up: &b%pickedup_value%";
        digging.footer = "&a[Prev]<action:run_command,%genre_id% %player% %prev_page%>  &7Page &b%current_page%/%total_pages%  <&a[Next]<action:run_command,%genre_id% %player% %next_page%>";
        config.genres.put("digging", digging);
        GenreFormattingConfig.GenreConfig woodcutting = new GenreFormattingConfig.GenreConfig();
        woodcutting.display_name = "Woodcutting";
        woodcutting.aliases = new ArrayList<String>();
        woodcutting.listed_blocks_key = "woodcutting";
        woodcutting.ranking_stat = "total_broken";
        woodcutting.header = "&6--- %genre_display_name% for %player% ---\\n&7Broken: &b%genre_total_broken% &7| Placed: &b%genre_total_placed% &7| Picked Up: &b%genre_total_pickedup%";
        woodcutting.line_format = "&e%display_name%<action:run_command,top broken:%item_id%> &7- Broken: &b%broken_value% &7| Placed: &b%placed_value% &7| Picked Up: &b%pickedup_value%";
        woodcutting.footer = "&a[Prev]<action:run_command,%genre_id% %player% %prev_page%>  &7Page &b%current_page%/%total_pages%  <&a[Next]<action:run_command,%genre_id% %player% %next_page%>";
        config.genres.put("woodcutting", woodcutting);
        GenreFormattingConfig.GenreConfig building = new GenreFormattingConfig.GenreConfig();
        building.display_name = "Building";
        building.aliases = new ArrayList<String>();
        building.listed_blocks_key = "building";
        building.ranking_stat = "total_placed";
        building.header = "&6--- %genre_display_name% for %player% ---\\n&7Placed: &b%genre_total_placed% &7| Broken: &b%genre_total_broken% &7| Picked Up: &b%genre_total_pickedup%";
        building.line_format = "&e%display_name%<action:run_command,top placed:%item_id%> &7- Placed: &b%placed_value% &7| Broken: &b%broken_value% &7| Picked Up: &b%pickedup_value%";
        building.footer = "&a[Prev]<action:run_command,%genre_id% %player% %prev_page%>  &7Page &b%current_page%/%total_pages%  <&a[Next]<action:run_command,%genre_id% %player% %next_page%>";
        config.genres.put("building", building);
        GenreFormattingConfig.GenreConfig crafting = new GenreFormattingConfig.GenreConfig();
        crafting.display_name = "Crafting";
        crafting.aliases = new ArrayList<String>();
        crafting.listed_blocks_key = "craftable_items";
        crafting.ranking_stat = "total_crafted";
        crafting.header = "&6--- %genre_display_name% for %player% ---\\n&7Total Crafted: &b%total_crafted%";
        crafting.line_format = "&e%display_name%<action:run_command,top crafted:%item_id%> &7- Crafted: &b%crafted_value%";
        crafting.footer = "&a[Prev]<action:run_command,%genre_id% %player% %prev_page%>  &7Page &b%current_page%/%total_pages%  <&a[Next]<action:run_command,%genre_id% %player% %next_page%>";
        config.genres.put("crafting", crafting);
        GenreFormattingConfig.GenreConfig smelting = new GenreFormattingConfig.GenreConfig();
        smelting.display_name = "Smelting";
        smelting.aliases = List.of("smelted");
        smelting.listed_blocks_key = "smeltable_items";
        smelting.ranking_stat = "total_smelted";
        smelting.header = "&6--- %genre_display_name% for %player% ---\\n&7Total Smelted: &b%total_smelted%";
        smelting.line_format = "&e%display_name%<action:run_command,top smelted:%item_id%> &7- Smelted: &b%smelted_value%";
        smelting.footer = "&a[Prev]<action:run_command,%genre_id% %player% %prev_page%>  &7Page &b%current_page%/%total_pages%  <&a[Next]<action:run_command,%genre_id% %player% %next_page%>";
        config.genres.put("smelting", smelting);
        GenreFormattingConfig.GenreConfig brewing = new GenreFormattingConfig.GenreConfig();
        brewing.display_name = "Brewing";
        brewing.aliases = List.of("brewed");
        brewing.listed_blocks_key = "brewable_items";
        brewing.ranking_stat = "total_brewed";
        brewing.header = "&6--- %genre_display_name% for %player% ---\\n&7Total Brewed: &b%total_brewed%";
        brewing.line_format = "&e%display_name%<action:run_command,top brewed:%item_id%> &7- Brewed: &b%brewed_value%";
        brewing.footer = "&a[Prev]<action:run_command,%genre_id% %player% %prev_page%>  &7Page &b%current_page%/%total_pages%  <&a[Next]<action:run_command,%genre_id% %player% %next_page%>";
        config.genres.put("brewing", brewing);
        GenreFormattingConfig.GenreConfig enchanting = new GenreFormattingConfig.GenreConfig();
        enchanting.display_name = "Enchanting";
        enchanting.aliases = List.of("enchanted");
        enchanting.listed_blocks_key = "enchantable_items";
        enchanting.ranking_stat = "total_enchanted";
        enchanting.header = "&6--- %genre_display_name% for %player% ---\\n&7Total Enchanted: &b%total_enchanted%";
        enchanting.line_format = "&e%display_name%<action:run_command,top enchanted:%item_id%> &7- Enchanted: &b%enchanted_value%";
        enchanting.footer = "&a[Prev]<action:run_command,%genre_id% %player% %prev_page%>  &7Page &b%current_page%/%total_pages%  <&a[Next]<action:run_command,%genre_id% %player% %next_page%>";
        config.genres.put("enchanting", enchanting);
        GenreFormattingConfig.GenreConfig combat = new GenreFormattingConfig.GenreConfig();
        combat.display_name = "Combat";
        combat.aliases = new ArrayList<String>();
        combat.listed_blocks_key = "killable_entities";
        combat.ranking_stat = "total_mobs_killed";
        combat.header = "&c--- %genre_display_name% for %player% ---\\n&7Kills: &b%total_mobs_killed% &7| Deaths: &b%deaths% &7| Player Kills: &b%players_killed%";
        combat.line_format = "&e%display_name%<action:run_command,top killed:%item_id%> &7- Killed: &b%killed_value% &7| Died To: &b%died_value%";
        combat.footer = "&a[Prev]<action:run_command,%genre_id% %player% %prev_page%>  &7Page &b%current_page%/%total_pages%  <&a[Next]<action:run_command,%genre_id% %player% %next_page%>";
        config.genres.put("combat", combat);
        GenreFormattingConfig.GenreConfig farming = new GenreFormattingConfig.GenreConfig();
        farming.display_name = "Farming";
        farming.aliases = new ArrayList<String>();
        farming.listed_blocks_key = "farming_blocks";
        farming.ranking_stat = "total_harvested";
        farming.header = "&2--- %genre_display_name% for %player% ---\\n&7Harvested: &b%genre_total_harvested% &7| Placed: &b%genre_total_placed% &7| Broken: &b%genre_total_broken%";
        farming.line_format = "&e%display_name%<action:run_command,top harvested:%item_id%> &7- Harvested: &b%harvested_value% &7| Placed: &b%placed_value% &7| Broken: &b%broken_value%";
        farming.footer = "&a[Prev]<action:run_command,%genre_id% %player% %prev_page%>  &7Page &b%current_page%/%total_pages%  <&a[Next]<action:run_command,%genre_id% %player% %next_page%>";
        config.genres.put("farming", farming);
        GenreFormattingConfig.GenreConfig husbandry = new GenreFormattingConfig.GenreConfig();
        husbandry.display_name = "Husbandry";
        husbandry.aliases = new ArrayList<String>();
        husbandry.listed_blocks_key = "breedable_animals";
        husbandry.ranking_stat = "total_animals_bred";
        husbandry.header = "&6--- %genre_display_name% for %player% ---\\n&7Bred: &b%total_animals_bred% &7| Killed: &b%total_mobs_killed%";
        husbandry.line_format = "&e%display_name%<action:run_command,top bred:%item_id%> &7- Bred: &b%bred_value% &7| Killed: &b%killed_value%";
        husbandry.footer = "&a[Prev]<action:run_command,%genre_id% %player% %prev_page%>  &7Page &b%current_page%/%total_pages%  <&a[Next]<action:run_command,%genre_id% %player% %next_page%>";
        config.genres.put("husbandry", husbandry);
        GenreFormattingConfig.GenreConfig fishing = new GenreFormattingConfig.GenreConfig();
        fishing.display_name = "Fishing";
        fishing.aliases = new ArrayList<String>();
        fishing.listed_blocks_key = "fished_items";
        fishing.ranking_stat = "total_fished";
        fishing.header = "&9--- %genre_display_name% for %player% ---\\n&7Total Fished: &b%total_fished%";
        fishing.line_format = "&e%display_name%<action:run_command,top fished:%item_id%> &7- Fished: &b%fished_value%";
        fishing.footer = "&a[Prev]<action:run_command,%genre_id% %player% %prev_page%>  &7Page &b%current_page%/%total_pages%  <&a[Next]<action:run_command,%genre_id% %player% %next_page%>";
        config.genres.put("fishing", fishing);
        GenreFormattingConfig.GenreConfig exploration = new GenreFormattingConfig.GenreConfig();
        exploration.display_name = "Exploration";
        exploration.aliases = new ArrayList<String>();
        exploration.listed_blocks_key = "exploration_stats";
        exploration.ranking_stat = "distance";
        exploration.header = "&3--- %genre_display_name% for %player% ---\\n&7Time Played: &b%played_formatted% &7| Unique Biomes: &b%biomes%";
        exploration.line_format = "&e%display_name%<action:run_command,top %stat_id%> &7- &b%value%";
        exploration.footer = "&a[Prev]<action:run_command,%genre_id% %player% %prev_page%>  &7Page &b%current_page%/%total_pages%  <&a[Next]<action:run_command,%genre_id% %player% %next_page%>";
        config.genres.put("exploration", exploration);
        return config;
    }

    private TypeFormattingConfig generateDefaultTypeFormattingConfig() {
        String[] types;
        TypeFormattingConfig config = new TypeFormattingConfig();
        config.types = new LinkedHashMap<String, TypeFormattingConfig.TypeConfig>();
        for (String type : types = new String[]{"broken", "placed", "killed", "died", "crafted", "smelted", "brewed", "enchanted", "used", "pickedup", "bred", "harvested", "fished", "traded", "played", "distance", "walked", "sprinted", "crouched", "swum", "biomes", "damaged", "flown"}) {
            TypeFormattingConfig.TypeConfig typeConfig = new TypeFormattingConfig.TypeConfig();
            typeConfig.display_name = this.capitalizeFully(type.replace("_", " "));
            switch (type) {
                case "biomes": {
                    typeConfig.header = "&6--- %type_display_name% Visited by %player% (%biomes%) ---";
                    typeConfig.line_format = "&e- %display_name%";
                    typeConfig.footer = "&a[Prev]<action:run_command,/%type_id% %player% %prev_page%>  &7Page &b%current_page%/%total_pages%  <&a[Next]<action:run_command,/%type_id% %player% %next_page%>";
                    break;
                }
                case "damaged": {
                    typeConfig.header = "&6--- %type_display_name% Stats for %player% ---";
                    typeConfig.line_format = "&e%display_name% &7- &b%value%";
                    typeConfig.footer = "&a[Prev]<action:run_command,/%type_id% %player% %prev_page%>  &7Page &b%current_page%/%total_pages%  <&a[Next]<action:run_command,/%type_id% %player% %next_page%>";
                    break;
                }
                case "flown": {
                    typeConfig.header = "&6--- %type_display_name% Stats for %player% ---";
                    typeConfig.line_format = "&e%display_name% &7- &b%value% meters";
                    typeConfig.footer = "&a[Prev]<action:run_command,/%type_id% %player% %prev_page%>  &7Page &b%current_page%/%total_pages%  <&a[Next]<action:run_command,/%type_id% %player% %next_page%>";
                    break;
                }
                default: {
                    typeConfig.header = String.format("&6--- %s Stats for %%player%% ---", typeConfig.display_name);
                    typeConfig.line_format = "&e%display_name%<action:run_command,top %stat_id%> &7- &b%value%";
                    typeConfig.footer = "&a[Prev]<action:run_command,%type_id% %player% %prev_page%>  &7Page &b%current_page%/%total_pages%  <&a[Next]<action:run_command,/%type_id% %player% %next_page%>";
                }
            }
            if ("played".equals(type)) {
                typeConfig.line_format = "&e%display_name%<action:run_command,top %stat_id%> &7- &b%value%";
            } else if (Arrays.asList("distance", "walked", "sprinted", "crouched", "swum").contains(type)) {
                typeConfig.line_format = "&e%display_name%<action:run_command,top %stat_id%> &7- &b%value% meters";
            }
            config.types.put(type, typeConfig);
        }
        return config;
    }

    private TopFormattingConfig generateDefaultTopFormattingConfig() {
        TopFormattingConfig config = new TopFormattingConfig();
        config.formats = new LinkedHashMap<String, CommandFormat>();
        config.formats.put("default", new CommandFormat("&6--- Top Players for %display_name% ---", "&b#%rank%. &e%player% &7- &b%value%", "&7Top players leaderboard."));
        config.formats.put("damaged", new CommandFormat("&c--- Top Damage Dealers ---", "&b#%rank%. &e%player% &7- &c%value% Dealt", "&7The server's heavy hitters."));
        config.formats.put("traded", new CommandFormat("&a--- Top Traders ---", "&b#%rank%. &e%player% &7- &a%value% Items Traded", "&7The savviest merchants."));
        config.formats.put("mining", new CommandFormat("&6--- Top Mining ---", "&b#%rank%. &e%player% &7- &b%value% Blocks Broken", "&7Overall mining leaders."));
        config.formats.put("digging", new CommandFormat("&6--- Top Digging ---", "&b#%rank%. &e%player% &7- &b%value% Blocks Dug", "&7Overall digging leaders."));
        config.formats.put("woodcutting", new CommandFormat("&6--- Top Woodcutting ---", "&b#%rank%. &e%player% &7- &b%value% Logs Chopped", "&7Overall woodcutting leaders."));
        config.formats.put("building", new CommandFormat("&6--- Top Building ---", "&b#%rank%. &e%player% &7- &b%value% Blocks Placed", "&7Overall building leaders."));
        config.formats.put("crafting", new CommandFormat("&6--- Top Crafting ---", "&b#%rank%. &e%player% &7- &b%value% Items Crafted", "&7Overall crafting leaders."));
        config.formats.put("smelting", new CommandFormat("&6--- Top Smelting ---", "&b#%rank%. &e%player% &7- &b%value% Items Smelted", "&7Overall smelting leaders."));
        config.formats.put("brewing", new CommandFormat("&d--- Top Alchemists ---", "&b#%rank%. &e%player% &7- &d%value% Potions Brewed", "&7Overall brewing leaders."));
        config.formats.put("enchanting", new CommandFormat("&5--- Top Enchanters ---", "&b#%rank%. &e%player% &7- &5%value% Items Enchanted", "&7Overall enchanting leaders."));
        config.formats.put("combat", new CommandFormat("&c--- Top Combat Warriors ---", "&b#%rank%. &e%player% &7- &c%value% Mobs Killed", "&7Overall combat leaders."));
        config.formats.put("farming", new CommandFormat("&2--- Top Farming ---", "&b#%rank%. &e%player% &7- &b%value% Crops Harvested", "&7Overall farming leaders."));
        config.formats.put("husbandry", new CommandFormat("&6--- Top Husbandry ---", "&b#%rank%. &e%player% &7- &b%value% Animals Bred", "&7Overall husbandry leaders."));
        config.formats.put("fishing", new CommandFormat("&9--- Top Anglers ---", "&b#%rank%. &e%player% &7- &9%value% Items Fished", "&7Overall fishing leaders."));
        config.formats.put("exploration", new CommandFormat("&3--- Top Exploration ---", "&b#%rank%. &e%player% &7- &b%value% Meters Traveled", "&7Overall exploration leaders."));
        config.formats.put("broken", new CommandFormat("&6--- Top Players for %display_name% ---", "&b#%rank%. &e%player% &7- &b%value% %display_name%", "&7Leaders in this specific broken stat."));
        config.formats.put("placed", new CommandFormat("&6--- Top Players for %display_name% ---", "&b#%rank%. &e%player% &7- &b%value% %display_name%", "&7Leaders in this specific placed stat."));
        config.formats.put("killed", new CommandFormat("&c--- Top Players for %display_name% Kills ---", "&b#%rank%. &e%player% &7- &c%value% %display_name% Kills", "&7Leaders in killing this entity."));
        config.formats.put("died", new CommandFormat("&c--- Most Deaths by %display_name% ---", "&b#%rank%. &e%player% &7- &c%value% Deaths by %display_name%", "&7Unlucky players."));
        config.formats.put("crafted", new CommandFormat("&6--- Top Players for %display_name% Crafted ---", "&b#%rank%. &e%player% &7- &b%value% %display_name% Crafted", "&7Leaders in crafting this item."));
        config.formats.put("smelted", new CommandFormat("&6--- Top Players for %display_name% Smelted ---", "&b#%rank%. &e%player% &7- &b%value% %display_name% Smelted", "&7Leaders in smelting this item."));
        config.formats.put("brewed", new CommandFormat("&d--- Top Brewers of %display_name% ---", "&b#%rank%. &e%player% &7- &d%value% Brewed", "&7Leaders in brewing this potion."));
        config.formats.put("enchanted", new CommandFormat("&5--- Top Enchanters of %display_name% ---", "&b#%rank%. &e%player% &7- &5%value% Enchanted", "&7Leaders in enchanting this item."));
        config.formats.put("used", new CommandFormat("&6--- Top Players for %display_name% Used ---", "&b#%rank%. &e%player% &7- &b%value% %display_name% Used", "&7Leaders in using this item."));
        config.formats.put("pickedup", new CommandFormat("&6--- Top Players for %display_name% Picked Up ---", "&b#%rank%. &e%player% &7- &b%value% %display_name% Picked Up", "&7Leaders in picking up this item."));
        config.formats.put("bred", new CommandFormat("&6--- Top Players for %display_name% Bred ---", "&b#%rank%. &e%player% &7- &b%value% %display_name% Bred", "&7Leaders in breeding this animal."));
        config.formats.put("harvested", new CommandFormat("&2--- Top Players for %display_name% Harvested ---", "&b#%rank%. &e%player% &7- &b%value% %display_name% Harvested", "&7Leaders in harvesting this crop."));
        config.formats.put("fished", new CommandFormat("&9--- Top Fishers of %display_name% ---", "&b#%rank%. &e%player% &7- &9%value% Fished", "&7Leaders in fishing this item."));
        config.formats.put("played", new CommandFormat("&6--- Top Players by Time Played ---", "&b#%rank%. &e%player% &7- &b%value%", "&7The most dedicated players."));
        config.formats.put("distance", new CommandFormat("&6--- Top Players by Distance Traveled ---", "&b#%rank%. &e%player% &7- &b%value% meters", "&7The most adventurous players."));
        config.formats.put("walked", new CommandFormat("&6--- Top Players by Distance Walked ---", "&b#%rank%. &e%player% &7- &b%value% meters", "&7The most persistent walkers."));
        config.formats.put("sprinted", new CommandFormat("&6--- Top Players by Distance Sprint ---", "&b#%rank%. &e%player% &7- &b%value% meters", "&7The fastest runners."));
        config.formats.put("crouched", new CommandFormat("&6--- Top Players by Distance Crouched ---", "&b#%rank%. &e%player% &7- &b%value% meters", "&7The stealthiest players."));
        config.formats.put("swum", new CommandFormat("&6--- Top Players by Distance Swum ---", "&b#%rank%. &e%player% &7- &b%value% meters", "&7The most aquatic players."));
        config.formats.put("flown", new CommandFormat("&6--- Top Players by Elytra Flight ---", "&b#%rank%. &e%player% &7- &b%value% meters", "&7The highest elytra flyers."));
        config.formats.put("elytra", new CommandFormat("&6--- Top Players by Elytra Flight ---", "&b#%rank%. &e%player% &7- &b%value% meters", "&7The highest elytra flyers."));
        config.formats.put("biomes", new CommandFormat("&6--- Top Players by Unique Biomes Visited ---", "&b#%rank%. &e%player% &7- &b%value% biomes", "&7The most well-traveled players."));
        config.formats.put("total_broken", new CommandFormat("&6--- Top Players by Total Blocks Broken ---", "&b#%rank%. &e%player% &7- &b%value% blocks", "&7The most diligent miners."));
        config.formats.put("total_placed", new CommandFormat("&6--- Top Players by Total Blocks Placed ---", "&b#%rank%. &e%player% &7- &b%value% blocks", "&7The most active builders."));
        config.formats.put("total_mobs_killed", new CommandFormat("&c--- Top Players by Total Mobs Killed ---", "&b#%rank%. &e%player% &7- &c%value% mobs", "&7The most dangerous hunters."));
        config.formats.put("players_killed", new CommandFormat("&c--- Top Players by Player Kills ---", "&b#%rank%. &e%player% &7- &c%value% players", "&7The most feared warriors."));
        config.formats.put("deaths", new CommandFormat("&c--- Top Players by Total Deaths ---", "&b#%rank%. &e%player% &7- &c%value% deaths", "&7The most unfortunate players."));
        config.formats.put("total_crafted", new CommandFormat("&6--- Top Players by Total Items Crafted ---", "&b#%rank%. &e%player% &7- &b%value% items", "&7The most productive crafters."));
        config.formats.put("total_smelted", new CommandFormat("&6--- Top Players by Total Items Smelted ---", "&b#%rank%. &e%player% &7- &b%value% items", "&7The most efficient smelters."));
        config.formats.put("total_brewed", new CommandFormat("&d--- Top Players by Total Potions Brewed ---", "&b#%rank%. &e%player% &7- &d%value% potions", "&7The most skilled alchemists."));
        config.formats.put("total_enchanted", new CommandFormat("&5--- Top Players by Total Items Enchanted ---", "&b#%rank%. &e%player% &7- &5%value% items", "&7The most powerful enchanters."));
        config.formats.put("total_harvested", new CommandFormat("&2--- Top Players by Total Crops Harvested ---", "&b#%rank%. &e%player% &7- &b%value% crops", "&7The most efficient farmers."));
        config.formats.put("total_animals_bred", new CommandFormat("&6--- Top Players by Total Animals Bred ---", "&b#%rank%. &e%player% &7- &b%value% animals", "&7The most successful breeders."));
        config.formats.put("total_fished", new CommandFormat("&9--- Top Players by Total Items Fished ---", "&b#%rank%. &e%player% &7- &9%value% items", "&7The most successful anglers."));
        config.formats.put("total_traded", new CommandFormat("&a--- Top Players by Total Items Traded ---", "&b#%rank%. &e%player% &7- &a%value% items", "&7The most successful traders."));
        return config;
    }

    private ProfileFormattingConfig generateDefaultProfileFormattingConfig() {
        ProfileFormattingConfig config = new ProfileFormattingConfig();
        config.lines = List.of("&6--- &e%player%'s Stats Profile &6---", "", "&7Time Played: &b%played_formatted%", "&7Damage Dealt: &b%damaged:dealt%", "&7Damage Taken: &b%damaged:taken%", "&7Total Blocks Broken: &b%total_broken%", "&7Total Blocks Placed: &b%total_placed%", "&7Total Items Crafted: &b%total_crafted%", "&7Total Items Smelted: &b%total_smelted%", "&7Total Potions Brewed: &b%total_brewed%", "&7Total Items Enchanted: &b%total_enchanted%", "&7Total Items Picked Up: &b%total_pickedup%", "&7Total Items Traded: &b%total_traded%", "&7Total Mobs Killed: &b%total_mobs_killed%", "&7Total Player Kills: &b%players_killed%", "&7Total Deaths: &b%deaths%", "&7Total Crops Harvested: &b%total_harvested%", "&7Total Animals Bred: &b%total_animals_bred%", "&7Total Items Fished: &b%total_fished%", "&7Total Distance Traveled: &b%distance% meters", "&7Creative Flight: &b%flown% meters", "&7Distance by Elytra: &b%elytra% meters", "&7Unique Biomes Visited: &b%biomes%", "", "&aMost Mined: &e%mining_top_display_name% &7(&b%mining_top_value%&7)", "&aMost Crafted: &e%crafting_top_display_name% &7(&b%crafting_top_value%&7)", "&aMost Smelted: &e%smelting_top_display_name% &7(&b%smelting_top_value%&7)", "&aMost Killed: &e%combat_top_display_name% &7(&b%combat_top_value%&7)", "&aMost Died To: &e%combat_top_died_display_name% &7(&b%combat_top_died_value%&7)", "&aMost Fished Item: &e%fishing_top_display_name% &7(&b%fishing_top_value%&7)", "", "&6----------------------------------------------------");
        return config;
    }

    private StatsCommandFormattingConfig generateDefaultStatsCommandFormattingConfig() {
        StatsCommandFormattingConfig config = new StatsCommandFormattingConfig();
        ArrayList<String> lines = new ArrayList<String>();
        GenreFormattingConfig genreConf = this.generateDefaultGenreFormattingConfig();
        TypeFormattingConfig typeConf = this.generateDefaultTypeFormattingConfig();
        lines.add("&6&m                    &r &6[ StatsMod Commands ] &m                    ");
        lines.add("");
        lines.add("&e&lGenres:");
        ArrayList<String> genreCommands = new ArrayList<String>();
        if (genreConf != null && genreConf.genres != null) {
            for (Map.Entry<String, GenreFormattingConfig.GenreConfig> entry : genreConf.genres.entrySet()) {
                String id = entry.getKey();
                String name = entry.getValue().display_name;
                genreCommands.add(String.format("&a[%s]{Click to view %s stats}<action:run_command,/%s>", name, name.toLowerCase(), id));
            }
        }
        lines.addAll(this.groupCommandsIntoLines(genreCommands, 4));
        lines.add("");
        lines.add("&e&lStatistic Types:");
        ArrayList<String> typeCommands = new ArrayList<String>();
        if (typeConf != null && typeConf.types != null) {
            for (Map.Entry<String, TypeFormattingConfig.TypeConfig> entry : typeConf.types.entrySet()) {
                String id = entry.getKey();
                String name = entry.getValue().display_name;
                typeCommands.add(String.format("&b[%s]{Click to view %s stats}<action:run_command,/%s>", name, name.toLowerCase(), id));
            }
        }
        typeCommands.add(String.format("&b[%s]{Click to view %s stats}<action:run_command,/%s>", "Damaged", "damage", "damaged"));
        typeCommands.add(String.format("&b[%s]{Click to view %s stats}<action:run_command,/%s>", "Flown", "flight", "flown"));
        typeCommands.add(String.format("&b[%s]{Click to view %s stats}<action:run_command,/%s>", "Biomes", "biomes", "biomes"));
        lines.addAll(this.groupCommandsIntoLines(typeCommands, 3));
        while (lines.size() < 17) {
            lines.add("");
        }
        lines.add("&6&m                                                                                ");
        config.lines = lines;
        return config;
    }

    private List<String> groupCommandsIntoLines(List<String> commands, int commandsPerLine) {
        ArrayList<String> lines = new ArrayList<String>();
        if (commands.isEmpty()) {
            return lines;
        }
        StringBuilder currentLine = new StringBuilder();
        for (int i = 0; i < commands.size(); ++i) {
            boolean isLastCommand;
            currentLine.append(commands.get(i));
            boolean isLastInLine = (i + 1) % commandsPerLine == 0;
            boolean bl = isLastCommand = i == commands.size() - 1;
            if (isLastInLine || isLastCommand) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder();
                continue;
            }
            currentLine.append(" ");
        }
        return lines;
    }

    private List<String> getSmeltableItems() {
        return List.of("minecraft:iron_ingot", "minecraft:gold_ingot", "minecraft:copper_ingot", "minecraft:netherite_scrap", "minecraft:diamond", "minecraft:emerald", "minecraft:lapis_lazuli", "minecraft:redstone", "minecraft:coal", "minecraft:glass", "minecraft:white_terracotta", "minecraft:orange_terracotta", "minecraft:magenta_terracotta", "minecraft:light_blue_terracotta", "minecraft:yellow_terracotta", "minecraft:lime_terracotta", "minecraft:pink_terracotta", "minecraft:gray_terracotta", "minecraft:light_gray_terracotta", "minecraft:cyan_terracotta", "minecraft:purple_terracotta", "minecraft:blue_terracotta", "minecraft:brown_terracotta", "minecraft:green_terracotta", "minecraft:red_terracotta", "minecraft:black_terracotta", "minecraft:green_dye", "minecraft:lime_dye", "minecraft:popped_chorus_fruit", "minecraft:smooth_stone", "minecraft:smooth_sandstone", "minecraft:smooth_red_sandstone", "minecraft:smooth_quartz_block", "minecraft:charcoal", "minecraft:dried_kelp", "minecraft:brick", "minecraft:nether_brick", "minecraft:cracked_stone_bricks", "minecraft:cracked_deepslate_bricks", "minecraft:cracked_deepslate_tiles", "minecraft:cracked_nether_bricks", "minecraft:cracked_polished_blackstone_bricks", "minecraft:terracotta", "minecraft:cooked_porkchop", "minecraft:cooked_beef", "minecraft:cooked_chicken", "minecraft:cooked_cod", "minecraft:cooked_salmon", "minecraft:cooked_mutton", "minecraft:cooked_rabbit", "minecraft:baked_potato");
    }

    private List<String> getBrewableItems() {
        return class_7923.field_41179.method_10235().stream().map(class_2960::toString).sorted().collect(Collectors.toList());
    }

    private List<String> getEnchantableItems() {
        return List.of("minecraft:book", "minecraft:wooden_sword", "minecraft:stone_sword", "minecraft:iron_sword", "minecraft:golden_sword", "minecraft:diamond_sword", "minecraft:netherite_sword", "minecraft:wooden_pickaxe", "minecraft:stone_pickaxe", "minecraft:iron_pickaxe", "minecraft:golden_pickaxe", "minecraft:diamond_pickaxe", "minecraft:netherite_pickaxe", "minecraft:wooden_axe", "minecraft:stone_axe", "minecraft:iron_axe", "minecraft:golden_axe", "minecraft:diamond_axe", "minecraft:netherite_axe", "minecraft:wooden_shovel", "minecraft:stone_shovel", "minecraft:iron_shovel", "minecraft:golden_shovel", "minecraft:diamond_shovel", "minecraft:netherite_shovel", "minecraft:wooden_hoe", "minecraft:stone_hoe", "minecraft:iron_hoe", "minecraft:golden_hoe", "minecraft:diamond_hoe", "minecraft:netherite_hoe", "minecraft:leather_helmet", "minecraft:leather_chestplate", "minecraft:leather_leggings", "minecraft:leather_boots", "minecraft:chainmail_helmet", "minecraft:chainmail_chestplate", "minecraft:chainmail_leggings", "minecraft:chainmail_boots", "minecraft:iron_helmet", "minecraft:iron_chestplate", "minecraft:iron_leggings", "minecraft:iron_boots", "minecraft:golden_helmet", "minecraft:golden_chestplate", "minecraft:golden_leggings", "minecraft:golden_boots", "minecraft:diamond_helmet", "minecraft:diamond_chestplate", "minecraft:diamond_leggings", "minecraft:diamond_boots", "minecraft:netherite_helmet", "minecraft:netherite_chestplate", "minecraft:netherite_leggings", "minecraft:netherite_boots", "minecraft:shield", "minecraft:bow", "minecraft:crossbow", "minecraft:trident", "minecraft:fishing_rod", "minecraft:shears");
    }

    private List<String> getFishedItems() {
        return List.of("minecraft:cod", "minecraft:salmon", "minecraft:tropical_fish", "minecraft:pufferfish", "minecraft:bow", "minecraft:enchanted_book", "minecraft:fishing_rod", "minecraft:name_tag", "minecraft:nautilus_shell", "minecraft:saddle", "minecraft:bowl", "minecraft:leather", "minecraft:leather_boots", "minecraft:rotten_flesh", "minecraft:stick", "minecraft:string", "minecraft:potion", "minecraft:bone", "minecraft:ink_sac", "minecraft:lily_pad", "minecraft:tripwire_hook", "minecraft:bamboo");
    }

    private List<String> getKillableEntitiesAndDeathReasons() {
        ArrayList<String> combined = new ArrayList<String>(class_7923.field_41177.method_10235().stream().filter(id -> {
            class_1299 type = (class_1299)class_7923.field_41177.method_63535(id);
            return type != null && type.method_5891() != class_1311.field_17715 && !ENTITY_EXCLUSIONS.contains(id.toString());
        }).map(class_2960::toString).sorted().collect(Collectors.toList()));
        combined.addAll(List.of("fall", "flyIntoWall", "drown", "lava", "inFire", "onFire", "outOfWorld", "wither", "freeze", "starve", "cramming", "magic", "indirectMagic", "explosion.player"));
        return combined;
    }

    private List<String> getMiningBlocks() {
        return List.of("minecraft:stone", "minecraft:cobblestone", "minecraft:mossy_cobblestone", "minecraft:stone_bricks", "minecraft:cracked_stone_bricks", "minecraft:chiseled_stone_bricks", "minecraft:granite", "minecraft:diorite", "minecraft:andesite", "minecraft:deepslate", "minecraft:cobbled_deepslate", "minecraft:polished_deepslate", "minecraft:deepslate_bricks", "minecraft:cracked_deepslate_bricks", "minecraft:deepslate_tiles", "minecraft:cracked_deepslate_tiles", "minecraft:chiseled_deepslate", "minecraft:tuff", "minecraft:calcite", "minecraft:obsidian", "minecraft:crying_obsidian", "minecraft:coal_ore", "minecraft:deepslate_coal_ore", "minecraft:iron_ore", "minecraft:deepslate_iron_ore", "minecraft:gold_ore", "minecraft:deepslate_gold_ore", "minecraft:redstone_ore", "minecraft:deepslate_redstone_ore", "minecraft:lapis_ore", "minecraft:deepslate_lapis_ore", "minecraft:diamond_ore", "minecraft:deepslate_diamond_ore", "minecraft:emerald_ore", "minecraft:deepslate_emerald_ore", "minecraft:copper_ore", "minecraft:deepslate_copper_ore", "minecraft:nether_gold_ore", "minecraft:nether_quartz_ore", "minecraft:ancient_debris", "minecraft:netherrack", "minecraft:magma_block", "minecraft:nether_bricks", "minecraft:cracked_nether_bricks", "minecraft:chiseled_nether_bricks", "minecraft:blackstone", "minecraft:polished_blackstone", "minecraft:polished_blackstone_bricks", "minecraft:cracked_polished_blackstone_bricks", "minecraft:chiseled_polished_blackstone", "minecraft:gilded_blackstone", "minecraft:basalt", "minecraft:polished_basalt", "minecraft:smooth_basalt", "minecraft:end_stone", "minecraft:end_stone_bricks", "minecraft:purpur_block", "minecraft:purpur_pillar", "minecraft:ice", "minecraft:packed_ice", "minecraft:blue_ice", "minecraft:amethyst_block", "minecraft:budding_amethyst", "minecraft:amethyst_cluster", "minecraft:coal_block", "minecraft:raw_iron_block", "minecraft:iron_block", "minecraft:raw_gold_block", "minecraft:gold_block", "minecraft:redstone_block", "minecraft:lapis_block", "minecraft:raw_copper_block", "minecraft:copper_block", "minecraft:diamond_block", "minecraft:emerald_block", "minecraft:netherite_block");
    }

    private List<String> getDiggingBlocks() {
        return List.of("minecraft:dirt", "minecraft:grass_block", "minecraft:coarse_dirt", "minecraft:podzol", "minecraft:rooted_dirt", "minecraft:mycelium", "minecraft:mud", "minecraft:muddy_mangrove_roots", "minecraft:sand", "minecraft:red_sand", "minecraft:suspicious_sand", "minecraft:gravel", "minecraft:suspicious_gravel", "minecraft:clay", "minecraft:snow_block", "minecraft:snow", "minecraft:soul_sand", "minecraft:soul_soil", "minecraft:farmland");
    }

    private List<String> getWoodcuttingBlocks() {
        return List.of("minecraft:oak_log", "minecraft:spruce_log", "minecraft:birch_log", "minecraft:jungle_log", "minecraft:acacia_log", "minecraft:dark_oak_log", "minecraft:mangrove_log", "minecraft:cherry_log", "minecraft:crimson_stem", "minecraft:warped_stem", "minecraft:stripped_oak_log", "minecraft:stripped_spruce_log", "minecraft:stripped_birch_log", "minecraft:stripped_jungle_log", "minecraft:stripped_acacia_log", "minecraft:stripped_dark_oak_log", "minecraft:stripped_mangrove_log", "minecraft:stripped_cherry_log", "minecraft:stripped_crimson_stem", "minecraft:stripped_warped_stem", "minecraft:oak_wood", "minecraft:spruce_wood", "minecraft:birch_wood", "minecraft:jungle_wood", "minecraft:acacia_wood", "minecraft:dark_oak_wood", "minecraft:mangrove_wood", "minecraft:cherry_wood", "minecraft:crimson_hyphae", "minecraft:warped_hyphae", "minecraft:stripped_oak_wood", "minecraft:stripped_spruce_wood", "minecraft:stripped_birch_wood", "minecraft:stripped_jungle_wood", "minecraft:stripped_acacia_log", "minecraft:stripped_dark_oak_wood", "minecraft:stripped_mangrove_wood", "minecraft:stripped_cherry_wood", "minecraft:stripped_crimson_hyphae", "minecraft:stripped_warped_hyphae", "minecraft:crafting_table", "minecraft:bookshelf", "minecraft:chest", "minecraft:trapped_chest", "minecraft:barrel", "minecraft:composter", "minecraft:loom", "minecraft:cartography_table", "minecraft:fletching_table", "minecraft:lectern", "minecraft:jukebox", "minecraft:note_block");
    }

    private List<String> getBuildingBlocks() {
        return List.of("minecraft:oak_planks", "minecraft:spruce_planks", "minecraft:birch_planks", "minecraft:jungle_planks", "minecraft:acacia_planks", "minecraft:dark_oak_planks", "minecraft:mangrove_planks", "minecraft:cherry_planks", "minecraft:crimson_planks", "minecraft:warped_planks", "minecraft:bamboo_planks", "minecraft:bamboo_mosaic", "minecraft:stone", "minecraft:stone_bricks", "minecraft:mossy_stone_bricks", "minecraft:cracked_stone_bricks", "minecraft:chiseled_stone_bricks", "minecraft:cobblestone", "minecraft:mossy_cobblestone", "minecraft:granite", "minecraft:polished_granite", "minecraft:diorite", "minecraft:polished_diorite", "minecraft:andesite", "minecraft:polished_andesite", "minecraft:deepslate", "minecraft:cobbled_deepslate", "minecraft:polished_deepslate", "minecraft:deepslate_bricks", "minecraft:cracked_deepslate_bricks", "minecraft:deepslate_tiles", "minecraft:cracked_deepslate_tiles", "minecraft:chiseled_deepslate", "minecraft:tuff", "minecraft:calcite", "minecraft:obsidian", "minecraft:crying_obsidian", "minecraft:coal_ore", "minecraft:deepslate_coal_ore", "minecraft:iron_ore", "minecraft:deepslate_iron_ore", "minecraft:gold_ore", "minecraft:deepslate_gold_ore", "minecraft:redstone_ore", "minecraft:deepslate_redstone_ore", "minecraft:lapis_ore", "minecraft:deepslate_lapis_ore", "minecraft:diamond_ore", "minecraft:deepslate_diamond_ore", "minecraft:emerald_ore", "minecraft:deepslate_emerald_ore", "minecraft:copper_ore", "minecraft:deepslate_copper_ore", "minecraft:nether_gold_ore", "minecraft:nether_quartz_ore", "minecraft:ancient_debris", "minecraft:netherrack", "minecraft:magma_block", "minecraft:nether_bricks", "minecraft:cracked_nether_bricks", "minecraft:chiseled_nether_bricks", "minecraft:blackstone", "minecraft:polished_blackstone", "minecraft:polished_blackstone_bricks", "minecraft:cracked_polished_blackstone_bricks", "minecraft:chiseled_polished_blackstone", "minecraft:gilded_blackstone", "minecraft:basalt", "minecraft:polished_basalt", "minecraft:smooth_basalt", "minecraft:end_stone", "minecraft:end_stone_bricks", "minecraft:purpur_block", "minecraft:purpur_pillar", "minecraft:ice", "minecraft:packed_ice", "minecraft:blue_ice", "minecraft:amethyst_block", "minecraft:budding_amethyst", "minecraft:amethyst_cluster", "minecraft:coal_block", "minecraft:raw_iron_block", "minecraft:iron_block", "minecraft:raw_gold_block", "minecraft:gold_block", "minecraft:redstone_block", "minecraft:lapis_block", "minecraft:raw_copper_block", "minecraft:copper_block", "minecraft:diamond_block", "minecraft:emerald_block", "minecraft:netherite_block");
    }

    private List<String> getCraftableItems() {
        return List.of("minecraft:oak_planks", "minecraft:crafting_table", "minecraft:furnace", "minecraft:blast_furnace", "minecraft:smoker", "minecraft:chest", "minecraft:barrel", "minecraft:ender_chest", "minecraft:shulker_box", "minecraft:anvil", "minecraft:grindstone", "minecraft:stick", "minecraft:torch", "minecraft:soul_torch", "minecraft:ladder", "minecraft:fence", "minecraft:sign", "minecraft:item_frame", "minecraft:glow_item_frame", "minecraft:painting", "minecraft:wooden_sword", "minecraft:stone_sword", "minecraft:iron_sword", "minecraft:golden_sword", "minecraft:diamond_sword", "minecraft:netherite_sword", "minecraft:wooden_pickaxe", "minecraft:stone_pickaxe", "minecraft:iron_pickaxe", "minecraft:golden_pickaxe", "minecraft:diamond_pickaxe", "minecraft:netherite_pickaxe", "minecraft:wooden_axe", "minecraft:stone_axe", "minecraft:iron_axe", "minecraft:golden_axe", "minecraft:diamond_axe", "minecraft:netherite_axe", "minecraft:wooden_shovel", "minecraft:stone_shovel", "minecraft:iron_shovel", "minecraft:golden_shovel", "minecraft:diamond_shovel", "minecraft:netherite_shovel", "minecraft:wooden_hoe", "minecraft:stone_hoe", "minecraft:iron_hoe", "minecraft:golden_hoe", "minecraft:diamond_hoe", "minecraft:netherite_hoe", "minecraft:leather_helmet", "minecraft:leather_chestplate", "minecraft:leather_leggings", "minecraft:leather_boots", "minecraft:chainmail_helmet", "minecraft:chainmail_chestplate", "minecraft:chainmail_leggings", "minecraft:chainmail_boots", "minecraft:iron_helmet", "minecraft:iron_chestplate", "minecraft:iron_leggings", "minecraft:iron_boots", "minecraft:golden_helmet", "minecraft:golden_chestplate", "minecraft:golden_leggings", "minecraft:golden_boots", "minecraft:diamond_helmet", "minecraft:diamond_chestplate", "minecraft:diamond_leggings", "minecraft:diamond_boots", "minecraft:netherite_helmet", "minecraft:netherite_chestplate", "minecraft:netherite_leggings", "minecraft:netherite_boots", "minecraft:shield", "minecraft:bow", "minecraft:crossbow", "minecraft:arrow", "minecraft:spectral_arrow", "minecraft:tipped_arrow", "minecraft:bread", "minecraft:cake", "minecraft:cookie", "minecraft:pumpkin_pie", "minecraft:golden_apple", "minecraft:golden_carrot", "minecraft:bucket", "minecraft:minecart", "minecraft:chest_minecart", "minecraft:furnace_minecart", "minecraft:paper", "minecraft:book", "minecraft:writable_book", "minecraft:bookshelf", "minecraft:lectern", "minecraft:flint_and_steel", "minecraft:shears", "minecraft:tnt", "minecraft:fishing_rod", "minecraft:clock", "minecraft:compass", "minecraft:map", "minecraft:glass_bottle", "minecraft:brewing_stand", "minecraft:cauldron", "minecraft:ender_eye", "minecraft:redstone", "minecraft:repeater", "minecraft:comparator", "minecraft:piston", "minecraft:sticky_piston", "minecraft:observer", "minecraft:dispenser", "minecraft:dropper", "minecraft:hopper", "minecraft:daylight_detector", "minecraft:target", "minecraft:stone_bricks", "minecraft:glass", "minecraft:iron_bars", "minecraft:beacon");
    }

    private List<String> getFarmingBlocks() {
        return List.of("minecraft:wheat", "minecraft:carrots", "minecraft:potatoes", "minecraft:beetroots", "minecraft:melon", "minecraft:pumpkin", "minecraft:carved_pumpkin", "minecraft:jack_o_lantern", "minecraft:sugar_cane", "minecraft:cactus", "minecraft:bamboo", "minecraft:nether_wart", "minecraft:cocoa_beans", "minecraft:sweet_berries", "minecraft:glow_berries", "minecraft:brown_mushroom", "minecraft:red_mushroom", "minecraft:crimson_fungus", "minecraft:warped_fungus");
    }

    private List<String> getBreedableAnimals() {
        return List.of("minecraft:axolotl", "minecraft:bee", "minecraft:camel", "minecraft:cat", "minecraft:chicken", "minecraft:cow", "minecraft:donkey", "minecraft:fox", "minecraft:frog", "minecraft:goat", "minecraft:hoglin", "minecraft:horse", "minecraft:llama", "minecraft:mooshroom", "minecraft:ocelot", "minecraft:panda", "minecraft:pig", "minecraft:rabbit", "minecraft:sheep", "minecraft:sniffer", "minecraft:strider", "minecraft:turtle", "minecraft:wolf");
    }

    private List<String> getExplorationStats() {
        return List.of("walked", "sprinted", "crouched", "swum", "flown", "elytra", "distance", "played", "biomes");
    }
}

