/*
 * Decompiled with CFR 0.152.
 */
package me.andy.statsmod.config;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import me.andy.statsmod.Statsmod;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class ReadmeGenerator {
    private static final Path configDir = Path.of("config/StatsMod", new String[0]);
    private static final File readmeFile = configDir.resolve("README.yml").toFile();

    public static void generate() {
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
            if (readmeFile.exists()) {
                return;
            }
            Statsmod.LOGGER.info("Generating placeholder reference: README.yml...");
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            options.setPrettyFlow(true);
            options.setIndent(2);
            options.setSplitLines(false);
            Representer representer = new Representer(options);
            representer.addClassTag(LinkedHashMap.class, Tag.MAP);
            Yaml yaml = new Yaml(representer, options);
            LinkedHashMap<String, Object> readmeContent = new LinkedHashMap<String, Object>();
            readmeContent.put("title", "StatsMod Placeholder Reference");
            readmeContent.put("description", "This file lists all available placeholders that can be used in your configuration files.");
            readmeContent.put("note", "Placeholders are case-sensitive. Use them exactly as shown below.");
            LinkedHashMap<String, String> generalPlaceholders = new LinkedHashMap<String, String>();
            generalPlaceholders.put("%player%", "The name of the player whose stats are being viewed.");
            generalPlaceholders.put("%newline%", "Forces a new line within a text string in a single config line.");
            readmeContent.put("general_placeholders", generalPlaceholders);
            LinkedHashMap<String, String> paginationPlaceholders = new LinkedHashMap<String, String>();
            paginationPlaceholders.put("%current_page%", "The current page number in a paginated list.");
            paginationPlaceholders.put("%total_pages%", "The total number of pages in a paginated list.");
            paginationPlaceholders.put("%prev_page%", "The previous page number. Used in clickable command actions.");
            paginationPlaceholders.put("%next_page%", "The next page number. Used in clickable command actions.");
            readmeContent.put("pagination_placeholders", paginationPlaceholders);
            LinkedHashMap<String, String> commandContextPlaceholders = new LinkedHashMap<String, String>();
            commandContextPlaceholders.put("%display_name%", "The user-friendly name of the current item/block/entity/stat (e.g., 'Stone', 'Zombie', 'Distance Walked').");
            commandContextPlaceholders.put("%stat_id%", "The full statistic ID being displayed (e.g., 'broken:minecraft:stone', 'dist_walked').");
            commandContextPlaceholders.put("%genre_display_name%", "The display name of the current genre (e.g., 'Mining').");
            commandContextPlaceholders.put("%genre_id%", "The internal ID of the current genre (e.g., 'mining').");
            commandContextPlaceholders.put("%type_id%", "The internal ID of the current type (e.g., 'broken').");
            commandContextPlaceholders.put("%item_id%", "The Minecraft ID of the current block/item/entity being listed (e.g., 'minecraft:stone').");
            commandContextPlaceholders.put("%rank%", "The rank of a player in a /top list.");
            commandContextPlaceholders.put("%value%", "The numerical value of the specific stat being displayed.");
            readmeContent.put("command_context_placeholders", commandContextPlaceholders);
            LinkedHashMap<String, String> statValuePlaceholders = new LinkedHashMap<String, String>();
            statValuePlaceholders.put("description", "These are used in the 'line_format' of genre commands to get specific values for the item on that line.");
            statValuePlaceholders.put("%broken_value%", "Value for 'broken:<id>' stat.");
            statValuePlaceholders.put("%placed_value%", "Value for 'placed:<id>' stat.");
            statValuePlaceholders.put("%killed_value%", "Value for 'killed:<id>' stat.");
            statValuePlaceholders.put("%died_value%", "Value for 'died:<id>' stat.");
            statValuePlaceholders.put("%crafted_value%", "Value for 'crafted:<id>' stat.");
            statValuePlaceholders.put("%smelted_value%", "Value for 'smelted:<id>' stat.");
            statValuePlaceholders.put("%brewed_value%", "Value for 'brewed:<id>' stat.");
            statValuePlaceholders.put("%enchanted_value%", "Value for 'enchanted:<id>' stat.");
            statValuePlaceholders.put("%used_value%", "Value for 'used:<id>' stat.");
            statValuePlaceholders.put("%pickedup_value%", "Value for 'pickedup:<id>' stat.");
            statValuePlaceholders.put("%bred_value%", "Value for 'bred:<id>' stat.");
            statValuePlaceholders.put("%harvested_value%", "Value for 'harvested:<id>' stat.");
            statValuePlaceholders.put("%fished_value%", "Value for 'fished:<id>' stat.");
            statValuePlaceholders.put("%traded_value%", "Value for 'traded:<id>' stat.");
            readmeContent.put("stat_value_placeholders_(for_genre_commands)", statValuePlaceholders);
            LinkedHashMap<String, String> rankingStatPlaceholders = new LinkedHashMap<String, String>();
            rankingStatPlaceholders.put("description", "The 'ranking_stat' in genres.yml determines the leaderboard for '/top <genre>'. It can be a global stat OR a specific stat type.");
            rankingStatPlaceholders.put("behavior_1", "If you use a global key (e.g., 'total_broken'), the leaderboard will show the global ranking for that statistic.");
            rankingStatPlaceholders.put("behavior_2", "If you use a type key (e.g., 'broken'), the leaderboard will be dynamically calculated based only on the items in that genre's list from genre_blocks.yml.");
            rankingStatPlaceholders.put("---", "---");
            rankingStatPlaceholders.put("## Genre-Specific Calculation Keys ##", "(Use these to rank players based only on items in the genre's list)");
            rankingStatPlaceholders.put("broken", "Total blocks broken from this genre's list.");
            rankingStatPlaceholders.put("placed", "Total blocks placed from this genre's list.");
            rankingStatPlaceholders.put("killed", "Total entities killed from this genre's list.");
            rankingStatPlaceholders.put("harvested", "Total crops harvested from this genre's list.");
            rankingStatPlaceholders.put("## Global Stat Keys ##", "(Use these to rank players by their server-wide total for a stat)");
            rankingStatPlaceholders.put("total_broken", "Global total blocks broken.");
            rankingStatPlaceholders.put("total_placed", "Global total blocks placed.");
            rankingStatPlaceholders.put("total_mobs_killed", "Global total mobs killed.");
            rankingStatPlaceholders.put("players_killed", "Global total players killed.");
            rankingStatPlaceholders.put("deaths", "Global total deaths.");
            rankingStatPlaceholders.put("distance", "Total distance traveled (in meters).");
            rankingStatPlaceholders.put("played", "Total time played (in seconds).");
            rankingStatPlaceholders.put("biomes", "Total unique biomes visited.");
            readmeContent.put("ranking_stat_options_(in_genres.yml)", rankingStatPlaceholders);
            LinkedHashMap<String, String> deathReasonKeys = new LinkedHashMap<String, String>();
            deathReasonKeys.put("description", "These keys are used for the 'died:<key>' statistic for non-entity damage sources. You can add them to the 'killable_entities' list in genre_blocks.yml to track them in the /combat command.");
            deathReasonKeys.put("fall", "Fall damage.");
            deathReasonKeys.put("flyIntoWall", "Flying into a wall with Elytra.");
            deathReasonKeys.put("drown", "Drowning in water.");
            deathReasonKeys.put("lava", "Damage from lava.");
            deathReasonKeys.put("inFire", "Standing in a fire block.");
            deathReasonKeys.put("onFire", "Burning from being on fire.");
            deathReasonKeys.put("outOfWorld", "Falling into the void.");
            deathReasonKeys.put("wither", "Damage from the Wither effect.");
            deathReasonKeys.put("freeze", "Freezing in powder snow.");
            deathReasonKeys.put("starve", "Starvation damage.");
            deathReasonKeys.put("cramming", "Entity cramming damage.");
            deathReasonKeys.put("magic", "General magic damage (e.g., instant harming).");
            deathReasonKeys.put("indirectMagic", "Indirect magic (e.g., lingering potions).");
            deathReasonKeys.put("explosion.player", "Explosions from player-lit TNT or beds in the Nether/End.");
            readmeContent.put("non_entity_death_reason_keys", deathReasonKeys);
            LinkedHashMap<String, String> profilePlaceholders = new LinkedHashMap<String, String>();
            profilePlaceholders.put("description", "These placeholders dynamically find a player's top stat within a genre. Used in /profile.");
            profilePlaceholders.put("%<genre_id>_top_display_name%", "Shows the name of the top stat within a genre (e.g., %mining_top_display_name% -> 'Stone').");
            profilePlaceholders.put("%<genre_id>_top_value%", "Shows the value of the top stat within a genre (e.g., %mining_top_value% -> '500').");
            profilePlaceholders.put("%combat_top_died_display_name%", "Shows the name of the entity the player has died to the most.");
            profilePlaceholders.put("%combat_top_died_value%", "Shows the count of deaths to the top entity.");
            readmeContent.put("profile_specific_placeholders", profilePlaceholders);
            LinkedHashMap<String, String> totalStatPlaceholders = new LinkedHashMap<String, String>();
            totalStatPlaceholders.put("description", "These placeholders retrieve a player's total server-wide value for a statistic. Used in /profile and command headers.");
            totalStatPlaceholders.put("%total_broken%", "Total blocks broken.");
            totalStatPlaceholders.put("%total_placed%", "Total blocks placed.");
            totalStatPlaceholders.put("%total_mobs_killed%", "Total mobs killed (non-player).");
            totalStatPlaceholders.put("%players_killed%", "Total players killed.");
            totalStatPlaceholders.put("%deaths%", "Total deaths.");
            totalStatPlaceholders.put("%total_crafted%", "Total items crafted.");
            totalStatPlaceholders.put("%total_smelted%", "Total items smelted.");
            totalStatPlaceholders.put("%total_brewed%", "Total potions brewed.");
            totalStatPlaceholders.put("%total_enchanted%", "Total items enchanted.");
            totalStatPlaceholders.put("%total_harvested%", "Total crops harvested.");
            totalStatPlaceholders.put("%total_animals_bred%", "Total animals bred.");
            totalStatPlaceholders.put("%total_pickedup%", "Total items picked up.");
            totalStatPlaceholders.put("%total_fished%", "Total items fished.");
            totalStatPlaceholders.put("%total_traded%", "Total items traded.");
            totalStatPlaceholders.put("%damaged:dealt%", "Total damage dealt.");
            totalStatPlaceholders.put("%damaged:taken%", "Total damage taken.");
            totalStatPlaceholders.put("%distance%", "Total distance traveled (meters).");
            totalStatPlaceholders.put("%played_formatted%", "Formatted time played (e.g., '1d 2h 3m 4s').");
            totalStatPlaceholders.put("%biomes%", "Total unique biomes visited.");
            totalStatPlaceholders.put("%flown%", "Total distance flown in creative mode (meters).");
            totalStatPlaceholders.put("%elytra%", "Total distance flown with an elytra (meters).");
            readmeContent.put("total_and_formatted_stat_placeholders", totalStatPlaceholders);
            try (FileWriter writer = new FileWriter(readmeFile);){
                yaml.dump(readmeContent, (Writer)writer);
            }
            Statsmod.LOGGER.info("README.yml generated successfully.");
        }
        catch (IOException e) {
            Statsmod.LOGGER.error("Failed to generate README.yml", (Throwable)e);
        }
    }
}

