/*
 * Decompiled with CFR 0.152.
 */
package me.andy.statsmod.stats;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class PlayerData {
    private final UUID playerUuid;
    private final ConcurrentHashMap<String, Long> stats;

    public PlayerData(UUID playerUuid) {
        this.playerUuid = playerUuid;
        this.stats = new ConcurrentHashMap();
    }

    public UUID getPlayerUuid() {
        return this.playerUuid;
    }

    public long getStat(String key) {
        return this.stats.getOrDefault(key, 0L);
    }

    public void setStat(String key, long value) {
        this.stats.put(key, value);
    }

    public void incrementStat(String key, long amount) {
        this.stats.merge(key, amount, Long::sum);
    }

    public void resetAllStats() {
        this.stats.clear();
    }

    public void resetStatsForGenre(List<String> statKeys) {
        statKeys.forEach(this.stats::remove);
    }

    public ConcurrentHashMap<String, Long> getAllStats() {
        return this.stats;
    }
}

