/*
 * Decompiled with CFR 0.152.
 */
package me.andy.statsmod.stats;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.andy.statsmod.Statsmod;
import me.andy.statsmod.stats.StatisticsManager;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_243;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class StatTracker {
    private static final Map<UUID, class_243> lastPlayerPositions = new ConcurrentHashMap<UUID, class_243>();
    private static int tickCounter = 0;
    private static final Map<String, Double> accumulatedDistances = new ConcurrentHashMap<String, Double>();

    public static void register() {
        StatisticsManager statsManager = Statsmod.getStatisticsManager();
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            statsManager.playerLoggedIn(handler.method_32311());
            lastPlayerPositions.put(handler.method_32311().method_5667(), new class_243(handler.method_32311().method_23317(), handler.method_32311().method_23318(), handler.method_32311().method_23321()));
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            statsManager.playerLoggedOut(handler.method_32311());
            UUID uuid = handler.method_32311().method_5667();
            lastPlayerPositions.remove(uuid);
            accumulatedDistances.keySet().removeIf(key -> key.startsWith(uuid.toString()));
        });
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, blockEntity) -> {
            if (!world.method_8608() && player instanceof class_3222) {
                class_2960 blockId = class_7923.field_41175.method_10221((Object)state.method_26204());
                statsManager.incrementStat((class_3222)player, "broken:" + String.valueOf(blockId), 1L);
                statsManager.incrementStat((class_3222)player, "total_broken", 1L);
                class_2248 patt0$temp = state.method_26204();
                if (patt0$temp instanceof class_2302) {
                    class_2302 crop = (class_2302)patt0$temp;
                    if (((Integer)state.method_11654((class_2769)class_2302.field_10835)).intValue() == crop.method_9827()) {
                        statsManager.incrementStat((class_3222)player, "harvested:" + String.valueOf(blockId), 1L);
                        statsManager.incrementStat((class_3222)player, "total_harvested", 1L);
                    }
                }
            }
        });
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_1799 stackInHand;
            if (!world.method_8608() && player instanceof class_3222 && (stackInHand = player.method_5998(hand)).method_7909() instanceof class_1747) {
                class_2960 blockId = class_7923.field_41175.method_10221((Object)((class_1747)stackInHand.method_7909()).method_7711());
                statsManager.incrementStat((class_3222)player, "placed:" + String.valueOf(blockId), 1L);
                statsManager.incrementStat((class_3222)player, "total_placed", 1L);
            }
            return class_1269.field_5811;
        });
        UseItemCallback.EVENT.register((player, world, hand) -> {
            class_1799 stack;
            if (player instanceof class_3222 && !world.method_8608() && !(stack = player.method_5998(hand)).method_7960()) {
                String itemId = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
                statsManager.incrementStat((class_3222)player, "used:" + itemId, 1L);
                statsManager.incrementStat((class_3222)player, "total_used", 1L);
            }
            return class_1269.field_5811;
        });
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            class_1297 patt0$temp = damageSource.method_5529();
            if (patt0$temp instanceof class_3222) {
                class_3222 attacker = (class_3222)patt0$temp;
                class_2960 entityId = class_7923.field_41177.method_10221((Object)entity.method_5864());
                statsManager.incrementStat(attacker, "killed:" + String.valueOf(entityId), 1L);
                if (entity instanceof class_1657) {
                    statsManager.incrementStat(attacker, "players_killed", 1L);
                } else {
                    statsManager.incrementStat(attacker, "total_mobs_killed", 1L);
                }
            }
            if (entity instanceof class_3222) {
                class_3222 victim = (class_3222)entity;
                statsManager.incrementStat(victim, "deaths", 1L);
                class_1297 sourceEntity = damageSource.method_5529();
                if (sourceEntity != null) {
                    class_2960 killerId = class_7923.field_41177.method_10221((Object)sourceEntity.method_5864());
                    statsManager.incrementStat(victim, "died:" + String.valueOf(killerId), 1L);
                } else {
                    damageSource.method_48793().method_40230().ifPresent(key -> {
                        String deathReason = key.method_29177().method_12832();
                        statsManager.incrementStat(victim, "died:" + deathReason, 1L);
                    });
                }
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (++tickCounter >= 20) {
                for (class_3222 player : server.method_3760().method_14571()) {
                    statsManager.incrementStat(player, "played", 1L);
                }
                tickCounter = 0;
            }
            for (class_3222 player : server.method_3760().method_14571()) {
                class_243 lastPos;
                class_243 currentPos = new class_243(player.method_23317(), player.method_23318(), player.method_23321());
                double distance = currentPos.method_1022(lastPos = lastPlayerPositions.getOrDefault(player.method_5667(), currentPos));
                if (distance > 0.0 && distance < 100.0) {
                    String movementStatKey = player.method_6128() ? "elytra" : (player.method_31549().field_7479 ? "flown" : (player.method_5869() && !player.method_24828() ? "swum" : (player.method_5624() ? "sprinted" : (player.method_5715() ? "crouched" : "walked"))));
                    StatTracker.accumulateAndCommitDistance(player, movementStatKey, distance, statsManager);
                    StatTracker.accumulateAndCommitDistance(player, "distance", distance, statsManager);
                }
                lastPlayerPositions.put(player.method_5667(), currentPos);
            }
            if (server.method_3780() % 100 == 0) {
                for (class_3222 player : server.method_3760().method_14571()) {
                    player.method_51469().method_23753(player.method_24515()).method_40230().ifPresentOrElse(key -> {
                        String biomeId = key.method_29177().toString();
                        String biomeStatKey = "visited_biome:" + biomeId;
                        if (statsManager.getPlayerData(player.method_5667()).getStat(biomeStatKey) == 0L) {
                            statsManager.setStat(player, biomeStatKey, 1L);
                            statsManager.incrementStat(player, "biomes", 1L);
                        }
                    }, () -> {
                        if (Statsmod.getConfigManager().getSettingsConfig().debug_mode) {
                            Statsmod.LOGGER.warn("Player {} is in a biome at {} that has no registry key. It will not be tracked.", (Object)player.method_7334().name(), (Object)player.method_24515().toString());
                        }
                    });
                }
            }
        });
    }

    private static void accumulateAndCommitDistance(class_3222 player, String statKey, double distanceToAdd, StatisticsManager statsManager) {
        String accumulatorMapKey = player.method_5667().toString() + "-" + statKey;
        double currentAccumulated = accumulatedDistances.getOrDefault(accumulatorMapKey, 0.0);
        double newTotal = currentAccumulated + distanceToAdd;
        long metersToCommit = (long)newTotal;
        if (metersToCommit > 0L) {
            statsManager.incrementStat(player, statKey, metersToCommit);
            accumulatedDistances.put(accumulatorMapKey, newTotal - (double)metersToCommit);
        } else {
            accumulatedDistances.put(accumulatorMapKey, newTotal);
        }
    }
}

