/*
 * Decompiled with CFR 0.152.
 */
package me.andy.statsmod.stats;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import me.andy.statsmod.Statsmod;
import me.andy.statsmod.api.StatisticEvents;
import me.andy.statsmod.api.TopPlayerEntry;
import me.andy.statsmod.config.GenreFormattingConfig;
import me.andy.statsmod.config.SettingsConfig;
import me.andy.statsmod.stats.PlayerData;
import me.andy.statsmod.stats.storage.DatabaseStorage;
import me.andy.statsmod.stats.storage.FileStorage;
import me.andy.statsmod.stats.storage.IDataStorage;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class StatisticsManager {
    private final ConcurrentHashMap<UUID, PlayerData> playerDataCache = new ConcurrentHashMap();
    private IDataStorage storage;
    private static final Set<String> STANDALONE_STATS = Set.of("played", "biomes", "distance", "walked", "sprinted", "crouched", "swum", "flown", "elytra", "deaths", "players_killed", "total_broken", "total_placed", "total_mobs_killed", "total_crafted", "total_harvested", "total_animals_bred", "total_fished", "total_smelted", "total_brewed", "total_enchanted", "total_pickedup", "total_traded", "damaged:dealt", "damaged:taken");

    public StatisticsManager() {
        SettingsConfig settings = Statsmod.getConfigManager().getSettingsConfig();
        if (settings.database != null && settings.database.enabled) {
            Statsmod.LOGGER.info("Using Database storage.");
            this.storage = new DatabaseStorage(settings.database);
        } else {
            Statsmod.LOGGER.info("Using File storage.");
            this.storage = new FileStorage();
        }
        this.storage.init();
    }

    public Map<UUID, PlayerData> getAllPlayerData() {
        Map<UUID, PlayerData> allLoadedData = this.storage.loadAllPlayerData();
        this.playerDataCache.forEach(allLoadedData::put);
        return allLoadedData;
    }

    public IDataStorage getStorage() {
        return this.storage;
    }

    public PlayerData getPlayerData(UUID uuid) {
        return this.playerDataCache.computeIfAbsent(uuid, this.storage::loadPlayerData);
    }

    public void playerLoggedIn(class_3222 player) {
        this.getPlayerData(player.method_5667());
    }

    public void playerLoggedOut(class_3222 player) {
        PlayerData data = this.playerDataCache.remove(player.method_5667());
        if (data != null) {
            this.storage.savePlayerData(data);
        }
    }

    public void savePlayerData(PlayerData data) {
        if (data != null) {
            this.storage.savePlayerData(data);
        }
    }

    public void saveAllOnlinePlayerData(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            PlayerData data = this.playerDataCache.get(player.method_5667());
            this.savePlayerData(data);
        }
    }

    public void shutdown() {
        if (this.storage != null) {
            this.storage.shutdown();
        }
    }

    public void incrementStat(class_3222 player, String statKey, long amount) {
        PlayerData data = this.getPlayerData(player.method_5667());
        long oldValue = data.getStat(statKey);
        data.incrementStat(statKey, amount);
        long newValue = data.getStat(statKey);
        ((StatisticEvents.StatisticChanged)StatisticEvents.STATISTIC_CHANGED.invoker()).onStatisticChanged(player, statKey, oldValue, newValue);
    }

    public void setStat(class_3222 player, String statKey, long value) {
        PlayerData data = this.getPlayerData(player.method_5667());
        long oldValue = data.getStat(statKey);
        data.setStat(statKey, value);
        ((StatisticEvents.StatisticChanged)StatisticEvents.STATISTIC_CHANGED.invoker()).onStatisticChanged(player, statKey, oldValue, value);
    }

    public void resetAllStats(class_3222 player) {
        PlayerData data = this.getPlayerData(player.method_5667());
        data.resetAllStats();
        this.storage.resetStatsForPlayer(player.method_5667());
    }

    public void resetGenreForPlayer(class_3222 player, String genreId) {
        GenreFormattingConfig.GenreConfig genreConfig = Statsmod.getConfigManager().getGenreFormattingConfig().genres.get(genreId);
        if (genreConfig == null || genreConfig.listed_blocks_key == null) {
            return;
        }
        List<String> statKeys = Statsmod.getConfigManager().getGenreBlocksConfig().get(genreConfig.listed_blocks_key).stream().filter(s -> s != null && !s.startsWith("#")).flatMap(id -> {
            if (genreId.equals("mining") || genreId.equals("digging") || genreId.equals("woodcutting") || genreId.equals("building") || genreId.equals("farming")) {
                return List.of("broken:" + id, "placed:" + id, "pickedup:" + id, "harvested:" + id).stream();
            }
            if (genreId.equals("combat") || genreId.equals("husbandry")) {
                return List.of("killed:" + id, "died:" + id, "bred:" + id).stream();
            }
            if (genreId.equals("crafting")) {
                return List.of("crafted:" + id).stream();
            }
            if (genreId.equals("exploration")) {
                return List.of(id).stream();
            }
            return null;
        }).collect(Collectors.toList());
        PlayerData data = this.getPlayerData(player.method_5667());
        data.resetStatsForGenre(statKeys);
        this.storage.resetGenreForPlayer(player.method_5667(), statKeys);
    }

    public void resetGenreForAllPlayers(String genreId) {
        GenreFormattingConfig.GenreConfig genreConfig = Statsmod.getConfigManager().getGenreFormattingConfig().genres.get(genreId);
        if (genreConfig == null || genreConfig.listed_blocks_key == null) {
            return;
        }
        List<String> statKeys = Statsmod.getConfigManager().getGenreBlocksConfig().get(genreConfig.listed_blocks_key).stream().filter(s -> s != null && !s.startsWith("#")).flatMap(id -> {
            if (genreId.equals("mining") || genreId.equals("digging") || genreId.equals("woodcutting") || genreId.equals("building") || genreId.equals("farming")) {
                return List.of("broken:" + id, "placed:" + id, "pickedup:" + id, "harvested:" + id).stream();
            }
            if (genreId.equals("combat") || genreId.equals("husbandry")) {
                return List.of("killed:" + id, "died:" + id, "bred:" + id).stream();
            }
            if (genreId.equals("crafting")) {
                return List.of("crafted:" + id).stream();
            }
            if (genreId.equals("exploration")) {
                return List.of(id).stream();
            }
            return null;
        }).collect(Collectors.toList());
        this.playerDataCache.values().forEach(pd -> pd.resetStatsForGenre(statKeys));
        this.storage.resetGenreForAllPlayers(statKeys);
    }

    public void resetAllServerStats() {
        this.playerDataCache.clear();
        this.storage.resetAllStatsForAllPlayers();
    }

    public List<TopPlayerEntry> getTopPlayersForGenre(String genreId, int limit) {
        GenreFormattingConfig.GenreConfig genreConfig = Statsmod.getConfigManager().getGenreFormattingConfig().genres.get(genreId);
        if (genreConfig == null) {
            Statsmod.LOGGER.warn("API call to getTopPlayersForGenre failed: Genre '{}' not found.", (Object)genreId);
            return Collections.emptyList();
        }
        String rankingStat = genreConfig.ranking_stat;
        if (rankingStat == null || rankingStat.isBlank()) {
            Statsmod.LOGGER.warn("API call to getTopPlayersForGenre failed: Genre '{}' has no 'ranking_stat' defined in genres.yml.", (Object)genreId);
            return Collections.emptyList();
        }
        if (STANDALONE_STATS.contains(rankingStat)) {
            return this.getTopPlayersForStat(rankingStat, limit);
        }
        Object statPrefix = rankingStat.endsWith(":") ? rankingStat : rankingStat + ":";
        return this.getTopPlayersForGenreAndType(genreId, (String)statPrefix, limit);
    }

    public List<TopPlayerEntry> getTopPlayersForGenreAndType(String genreId, String typeId, int limit) {
        Object statPrefix = typeId.endsWith(":") ? typeId : typeId + ":";
        ConcurrentHashMap playerTotals = new ConcurrentHashMap();
        this.getAllPlayerData().forEach((arg_0, arg_1) -> this.lambda$getTopPlayersForGenreAndType$5(genreId, (String)statPrefix, playerTotals, arg_0, arg_1));
        return playerTotals.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(limit).map(entry -> new TopPlayerEntry((UUID)entry.getKey(), (Long)entry.getValue())).collect(Collectors.toList());
    }

    public List<TopPlayerEntry> getTopPlayersForType(String typeId, int limit) {
        String prefix = typeId.toLowerCase() + ":";
        ConcurrentHashMap playerTotals = new ConcurrentHashMap();
        this.getAllPlayerData().forEach((uuid, playerData) -> {
            long total = playerData.getAllStats().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(prefix)).mapToLong(Map.Entry::getValue).sum();
            if (total > 0L) {
                playerTotals.put(uuid, total);
            }
        });
        return playerTotals.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(limit).map(entry -> new TopPlayerEntry((UUID)entry.getKey(), (Long)entry.getValue())).collect(Collectors.toList());
    }

    public List<TopPlayerEntry> getTopPlayersForStat(String statKey, int limit) {
        return this.getAllPlayerData().entrySet().stream().filter(entry -> ((PlayerData)entry.getValue()).getStat(statKey) > 0L).sorted(Comparator.comparingLong(entry -> -((PlayerData)entry.getValue()).getStat(statKey))).limit(limit).map(entry -> new TopPlayerEntry((UUID)entry.getKey(), ((PlayerData)entry.getValue()).getStat(statKey))).collect(Collectors.toList());
    }

    public long getGenreStatisticTotal(UUID playerUuid, String genreId, String statPrefix) {
        GenreFormattingConfig.GenreConfig genreConfig = Statsmod.getConfigManager().getGenreFormattingConfig().genres.get(genreId);
        if (genreConfig == null || genreConfig.listed_blocks_key == null) {
            return 0L;
        }
        List<String> trackedIds = Statsmod.getConfigManager().getGenreBlocksConfig().get(genreConfig.listed_blocks_key);
        if (trackedIds == null || trackedIds.isEmpty()) {
            return 0L;
        }
        PlayerData playerData = this.getPlayerData(playerUuid);
        return trackedIds.stream().filter(id -> id != null && !id.startsWith("#")).mapToLong(id -> playerData.getStat(statPrefix + id)).sum();
    }

    private /* synthetic */ void lambda$getTopPlayersForGenreAndType$5(String genreId, String statPrefix, Map playerTotals, UUID uuid, PlayerData playerData) {
        long total = this.getGenreStatisticTotal(uuid, genreId, statPrefix);
        if (total > 0L) {
            playerTotals.put(uuid, total);
        }
    }
}

