/*
 * Decompiled with CFR 0.152.
 */
package me.andy.statsmod.stats.storage;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.andy.statsmod.Statsmod;
import me.andy.statsmod.config.SettingsConfig;
import me.andy.statsmod.stats.PlayerData;
import me.andy.statsmod.stats.storage.IDataStorage;

public class DatabaseStorage
implements IDataStorage {
    private HikariDataSource dataSource;
    private final SettingsConfig.DatabaseConfig dbConfig;
    private static final String CREATE_TABLE_SQL = "CREATE TABLE IF NOT EXISTS player_stats (uuid TEXT NOT NULL, stat_key TEXT NOT NULL, stat_value BIGINT NOT NULL, PRIMARY KEY (uuid, stat_key));";
    private static final String SELECT_PLAYER_SQL = "SELECT stat_key, stat_value FROM player_stats WHERE uuid = ?;";
    private static final String REPLACE_STAT_SQL = "INSERT OR REPLACE INTO player_stats (uuid, stat_key, stat_value) VALUES (?, ?, ?);";
    private static final String DELETE_PLAYER_SQL = "DELETE FROM player_stats WHERE uuid = ?;";
    private static final String DELETE_ALL_SQL = "DELETE FROM player_stats;";

    public DatabaseStorage(SettingsConfig.DatabaseConfig config) {
        this.dbConfig = config;
    }

    @Override
    public void init() {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl("jdbc:sqlite:" + this.dbConfig.url);
        config.setUsername(this.dbConfig.username);
        config.setPassword(this.dbConfig.password);
        config.setMaximumPoolSize(10);
        this.dataSource = new HikariDataSource(config);
        try (Connection conn = this.dataSource.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.execute(CREATE_TABLE_SQL);
        }
        catch (SQLException e) {
            Statsmod.LOGGER.error("Failed to create database table", (Throwable)e);
        }
    }

    @Override
    public PlayerData loadPlayerData(UUID uuid) {
        PlayerData playerData = new PlayerData(uuid);
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(SELECT_PLAYER_SQL);){
            ps.setString(1, uuid.toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    playerData.setStat(rs.getString("stat_key"), rs.getLong("stat_value"));
                }
            }
        }
        catch (SQLException e) {
            Statsmod.LOGGER.error("Failed to load player data from database for " + String.valueOf(uuid), (Throwable)e);
        }
        return playerData;
    }

    @Override
    public void savePlayerData(PlayerData playerData) {
        try (Connection conn = this.dataSource.getConnection();){
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(REPLACE_STAT_SQL);){
                for (Map.Entry<String, Long> entry : playerData.getAllStats().entrySet()) {
                    ps.setString(1, playerData.getPlayerUuid().toString());
                    ps.setString(2, entry.getKey());
                    ps.setLong(3, entry.getValue());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            conn.commit();
        }
        catch (SQLException e) {
            Statsmod.LOGGER.error("Failed to save player data to database for " + String.valueOf(playerData.getPlayerUuid()), (Throwable)e);
        }
    }

    @Override
    public Map<UUID, PlayerData> loadAllPlayerData() {
        ConcurrentHashMap<UUID, PlayerData> allData = new ConcurrentHashMap<UUID, PlayerData>();
        String sql = "SELECT uuid, stat_key, stat_value FROM player_stats;";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                UUID uuid = UUID.fromString(rs.getString("uuid"));
                PlayerData pd = allData.computeIfAbsent(uuid, PlayerData::new);
                pd.setStat(rs.getString("stat_key"), rs.getLong("stat_value"));
            }
        }
        catch (SQLException e) {
            Statsmod.LOGGER.error("Failed to load all player data from database", (Throwable)e);
        }
        return allData;
    }

    @Override
    public void resetStatsForPlayer(UUID uuid) {
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(DELETE_PLAYER_SQL);){
            ps.setString(1, uuid.toString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            Statsmod.LOGGER.error("Failed to reset player data in database for " + String.valueOf(uuid), (Throwable)e);
        }
    }

    @Override
    public void resetGenreForPlayer(UUID uuid, List<String> genreStatKeys) {
        if (genreStatKeys.isEmpty()) {
            return;
        }
        String sql = "DELETE FROM player_stats WHERE uuid = ? AND stat_key IN (" + String.join((CharSequence)",", Collections.nCopies(genreStatKeys.size(), "?")) + ");";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            for (int i = 0; i < genreStatKeys.size(); ++i) {
                ps.setString(i + 2, genreStatKeys.get(i));
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            Statsmod.LOGGER.error("Failed to reset genre for player in database", (Throwable)e);
        }
    }

    @Override
    public void resetAllStatsForAllPlayers() {
        try (Connection conn = this.dataSource.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate(DELETE_ALL_SQL);
        }
        catch (SQLException e) {
            Statsmod.LOGGER.error("Failed to wipe all player data from database", (Throwable)e);
        }
    }

    @Override
    public void resetGenreForAllPlayers(List<String> genreStatKeys) {
        if (genreStatKeys.isEmpty()) {
            return;
        }
        String sql = "DELETE FROM player_stats WHERE stat_key IN (" + String.join((CharSequence)",", Collections.nCopies(genreStatKeys.size(), "?")) + ");";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            for (int i = 0; i < genreStatKeys.size(); ++i) {
                ps.setString(i + 1, genreStatKeys.get(i));
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            Statsmod.LOGGER.error("Failed to reset genre for all players in database", (Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
        }
    }
}

