/*
 * Decompiled with CFR 0.152.
 */
package me.andy.statsmod.stats.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import me.andy.statsmod.Statsmod;
import me.andy.statsmod.stats.PlayerData;
import me.andy.statsmod.stats.storage.IDataStorage;

public class FileStorage
implements IDataStorage {
    private final Path dataDir = Path.of("world/statsmod_data", new String[0]);
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Type statMapType = new TypeToken<ConcurrentHashMap<String, Long>>(this){}.getType();

    @Override
    public void init() {
        try {
            Files.createDirectories(this.dataDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            Statsmod.LOGGER.error("Failed to create stats data directory", (Throwable)e);
        }
    }

    private File getPlayerFile(UUID uuid) {
        return this.dataDir.resolve(uuid.toString() + ".json").toFile();
    }

    @Override
    public PlayerData loadPlayerData(UUID uuid) {
        File playerFile = this.getPlayerFile(uuid);
        PlayerData playerData = new PlayerData(uuid);
        if (playerFile.exists()) {
            try (FileReader reader = new FileReader(playerFile);){
                Map stats = (Map)this.gson.fromJson((Reader)reader, this.statMapType);
                if (stats != null) {
                    playerData.getAllStats().putAll(stats);
                }
            }
            catch (IOException e) {
                Statsmod.LOGGER.error("Failed to load player data for " + String.valueOf(uuid), (Throwable)e);
            }
        }
        return playerData;
    }

    @Override
    public void savePlayerData(PlayerData playerData) {
        File playerFile = this.getPlayerFile(playerData.getPlayerUuid());
        try (FileWriter writer = new FileWriter(playerFile);){
            this.gson.toJson(playerData.getAllStats(), (Appendable)writer);
        }
        catch (IOException e) {
            Statsmod.LOGGER.error("Failed to save player data for " + String.valueOf(playerData.getPlayerUuid()), (Throwable)e);
        }
    }

    @Override
    public Map<UUID, PlayerData> loadAllPlayerData() {
        ConcurrentHashMap<UUID, PlayerData> allData = new ConcurrentHashMap<UUID, PlayerData>();
        try (Stream<Path> files = Files.list(this.dataDir);){
            files.filter(path -> path.toString().endsWith(".json")).forEach(path -> {
                try {
                    String fileName = path.getFileName().toString();
                    UUID uuid = UUID.fromString(fileName.substring(0, fileName.length() - 5));
                    allData.put(uuid, this.loadPlayerData(uuid));
                }
                catch (Exception e) {
                    Statsmod.LOGGER.warn("Could not parse UUID from file: " + String.valueOf(path), (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            Statsmod.LOGGER.error("Failed to read stats data directory for full load", (Throwable)e);
        }
        return allData;
    }

    @Override
    public void resetStatsForPlayer(UUID uuid) {
        File playerFile = this.getPlayerFile(uuid);
        if (playerFile.exists()) {
            playerFile.delete();
        }
    }

    @Override
    public void resetGenreForPlayer(UUID uuid, List<String> genreStatKeys) {
        PlayerData playerData = this.loadPlayerData(uuid);
        playerData.resetStatsForGenre(genreStatKeys);
        this.savePlayerData(playerData);
    }

    @Override
    public void resetAllStatsForAllPlayers() {
        block8: {
            try {
                if (!Files.exists(this.dataDir, new LinkOption[0])) break block8;
                try (Stream<Path> files = Files.walk(this.dataDir, new FileVisitOption[0]);){
                    files.sorted(Collections.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
                Files.createDirectories(this.dataDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                Statsmod.LOGGER.error("Failed to wipe all player data files", (Throwable)e);
            }
        }
    }

    @Override
    public void resetGenreForAllPlayers(List<String> genreStatKeys) {
        try (Stream<Path> files = Files.list(this.dataDir);){
            files.filter(path -> path.toString().endsWith(".json")).forEach(path -> {
                try {
                    String fileName = path.getFileName().toString();
                    UUID uuid = UUID.fromString(fileName.substring(0, fileName.length() - 5));
                    this.resetGenreForPlayer(uuid, genreStatKeys);
                }
                catch (Exception e) {
                    Statsmod.LOGGER.warn("Failed to process file for genre reset: " + String.valueOf(path), (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            Statsmod.LOGGER.error("Failed to read stats data directory for genre reset", (Throwable)e);
        }
    }

    @Override
    public void shutdown() {
    }
}

