/*
 * Decompiled with CFR 0.152.
 */
package me.andy.statsmod.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.andy.statsmod.Statsmod;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class InteractiveTextParser {
    private static final Pattern SEGMENT_PATTERN = Pattern.compile("([^<{]+)(?:\\{(.*?)\\})?(?:<action:(run_command|suggest_command|open_url|copy_to_clipboard|change_page),(.+?)>)?");

    public static class_2561 parse(String input, Function<String, String> placeholderReplacer) {
        String processedInput = placeholderReplacer.apply(input);
        processedInput = processedInput.replace("\\n", "\n");
        class_5250 finalMessage = class_2561.method_43473();
        Matcher matcher = SEGMENT_PATTERN.matcher(processedInput);
        while (matcher.find()) {
            class_2558 clickEvent;
            String mainTextStr = matcher.group(1);
            String hoverTextStr = matcher.group(2);
            String actionTypeStr = matcher.group(3);
            String actionValueStr = matcher.group(4);
            class_2583 style = class_2583.field_24360;
            if (hoverTextStr != null && !hoverTextStr.isEmpty()) {
                style = style.method_10949((class_2568)new class_2568.class_10613(class_2561.method_30163((String)hoverTextStr.replace('&', '\u00a7'))));
            }
            if (actionTypeStr != null && actionValueStr != null && (clickEvent = InteractiveTextParser.createClickEvent(actionTypeStr, actionValueStr)) != null) {
                style = style.method_10958(clickEvent);
            }
            String[] lines = mainTextStr.split("\n", -1);
            for (int i = 0; i < lines.length; ++i) {
                if (!lines[i].isEmpty()) {
                    finalMessage.method_10852((class_2561)class_2561.method_43470((String)lines[i].replace('&', '\u00a7')).method_10862(style));
                }
                if (i >= lines.length - 1) continue;
                finalMessage.method_27693("\n");
            }
        }
        return finalMessage;
    }

    private static class_2558 createClickEvent(String actionTypeStr, String actionValueStr) {
        try {
            class_2558.class_2559 action = class_2558.class_2559.valueOf((String)actionTypeStr.trim().toUpperCase(Locale.ROOT));
            String cleanActionValue = actionValueStr.endsWith(">") ? actionValueStr.substring(0, actionValueStr.length() - 1) : actionValueStr;
            String trimmedValue = cleanActionValue.trim();
            return switch (action) {
                case class_2558.class_2559.field_11749 -> new class_2558.class_10608(new URI(trimmedValue));
                case class_2558.class_2559.field_11750 -> {
                    String command = trimmedValue.startsWith("/") ? trimmedValue.substring(1) : trimmedValue;
                    yield new class_2558.class_10609(command);
                }
                case class_2558.class_2559.field_11745 -> new class_2558.class_10610(trimmedValue);
                case class_2558.class_2559.field_11748 -> new class_2558.class_10605(Integer.parseInt(trimmedValue));
                case class_2558.class_2559.field_21462 -> new class_2558.class_10606(trimmedValue);
                default -> null;
            };
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            Statsmod.LOGGER.warn("Failed to parse click action value: type={}, value={}", new Object[]{actionTypeStr, actionValueStr, e});
            return null;
        }
    }

    public static String getDisplayName(String statId) {
        try {
            class_2960 id;
            String[] parts;
            String idPart = statId;
            if (statId.contains(":") && (parts = statId.split(":", 2)).length > 1) {
                idPart = parts[1];
            }
            if (class_7923.field_41175.method_10250(id = class_2960.method_60654((String)idPart))) {
                return ((class_2248)class_7923.field_41175.method_63535(id)).method_9518().getString();
            }
            if (class_7923.field_41178.method_10250(id)) {
                return ((class_1792)class_7923.field_41178.method_63535(id)).method_63680().getString();
            }
            if (class_7923.field_41177.method_10250(id)) {
                return ((class_1299)class_7923.field_41177.method_63535(id)).method_5897().getString();
            }
        }
        catch (Exception e) {
            Statsmod.LOGGER.warn("Could not find display name for id: {}", (Object)statId);
        }
        String cleanId = statId.substring(statId.lastIndexOf(58) + 1).replace('_', ' ');
        CharSequence[] words = cleanId.split(" ");
        for (int i = 0; i < words.length; ++i) {
            if (words[i].isEmpty()) continue;
            words[i] = ((String)words[i]).substring(0, 1).toUpperCase() + ((String)words[i]).substring(1);
        }
        return String.join((CharSequence)" ", words);
    }
}

