/*
 * Decompiled with CFR 0.152.
 */
package me.andy.statsmod.util;

import java.lang.reflect.Method;
import me.andy.statsmod.Statsmod;
import net.minecraft.class_2168;

public class PermissionUtil {
    private static Method permissionsCheckMethod = null;
    private static boolean checkedForPermissionsApi = false;
    private static final String PERMISSIONS_CLASS_NAME = "me.lucko.fabric.api.permissions.v0.Permissions";
    private static final String CHECK_METHOD_NAME = "check";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPermission(class_2168 source, String permissionNode, int defaultOpLevel) {
        if (!checkedForPermissionsApi) {
            try {
                Class<?> permissionsClass = Class.forName(PERMISSIONS_CLASS_NAME);
                permissionsCheckMethod = permissionsClass.getMethod(CHECK_METHOD_NAME, class_2168.class, String.class, Integer.TYPE);
                Statsmod.LOGGER.info("Fabric Permissions API found and 'check' method loaded via reflection.");
            }
            catch (ClassNotFoundException e) {
                Statsmod.LOGGER.warn("Fabric Permissions API ('{}') not found. Permissions will default to OP level checks.", (Object)PERMISSIONS_CLASS_NAME);
            }
            catch (NoSuchMethodException e) {
                Statsmod.LOGGER.warn("Fabric Permissions API found but '{}' method not compatible. Permissions will default to OP level checks. Error: {}", (Object)CHECK_METHOD_NAME, (Object)e.getMessage());
            }
            finally {
                checkedForPermissionsApi = true;
            }
        }
        if (permissionsCheckMethod != null) {
            try {
                return (Boolean)permissionsCheckMethod.invoke(null, source, permissionNode, defaultOpLevel);
            }
            catch (Exception e) {
                Statsmod.LOGGER.error("Error invoking Fabric Permissions API '{}' method via reflection. Falling back to OP level check. Error: {}", (Object)CHECK_METHOD_NAME, (Object)e.getMessage());
                return source.method_9259(defaultOpLevel);
            }
        }
        return source.method_9259(defaultOpLevel);
    }
}

