/*
 * Decompiled with CFR 0.152.
 */
package me.andy.statsmod.util;

import me.andy.statsmod.Statsmod;
import me.andy.statsmod.stats.PlayerData;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

public class PlaceholderContext {
    private final class_2168 source;
    private final class_3222 targetPlayer;
    private final PlayerData playerData;
    private String genreId = "";
    private String genreDisplayName = "";
    private String typeId = "";
    private String typeDisplayName = "";
    private String statId = "";
    private String itemId = "";
    private String displayName = "";
    private long value = 0L;
    private int rank = 0;
    private int currentPage = 0;
    private int totalPages = 0;

    private PlaceholderContext(Builder builder) {
        this.source = builder.source;
        this.targetPlayer = builder.targetPlayer;
        this.playerData = builder.playerData;
        this.genreId = builder.genreId;
        this.genreDisplayName = builder.genreDisplayName;
        this.typeId = builder.typeId;
        this.typeDisplayName = builder.typeDisplayName;
        this.statId = builder.statId;
        this.itemId = builder.itemId;
        this.displayName = builder.displayName;
        this.value = builder.value;
        this.rank = builder.rank;
        this.currentPage = builder.currentPage;
        this.totalPages = builder.totalPages;
    }

    public class_2168 getSource() {
        return this.source;
    }

    public class_3222 getTargetPlayer() {
        return this.targetPlayer;
    }

    public PlayerData getPlayerData() {
        return this.playerData;
    }

    public String getGenreId() {
        return this.genreId;
    }

    public String getGenreDisplayName() {
        return this.genreDisplayName;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getTypeDisplayName() {
        return this.typeDisplayName;
    }

    public String getStatId() {
        return this.statId;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public long getValue() {
        return this.value;
    }

    public int getRank() {
        return this.rank;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public static class Builder {
        private final class_2168 source;
        private final class_3222 targetPlayer;
        private final PlayerData playerData;
        private String genreId = "";
        private String genreDisplayName = "";
        private String typeId = "";
        private String typeDisplayName = "";
        private String statId = "";
        private String itemId = "";
        private String displayName = "";
        private long value = 0L;
        private int rank = 0;
        private int currentPage = 0;
        private int totalPages = 0;

        public Builder(class_2168 source, class_3222 targetPlayer) {
            this.source = source;
            this.targetPlayer = targetPlayer;
            this.playerData = targetPlayer != null ? Statsmod.getStatisticsManager().getPlayerData(targetPlayer.method_5667()) : null;
        }

        public Builder withGenre(String genreId, String genreDisplayName) {
            this.genreId = genreId;
            this.genreDisplayName = genreDisplayName;
            return this;
        }

        public Builder withType(String typeId, String typeDisplayName) {
            this.typeId = typeId;
            this.typeDisplayName = typeDisplayName;
            return this;
        }

        public Builder withStat(String statId) {
            this.statId = statId;
            return this;
        }

        public Builder withItem(String itemId, String displayName) {
            this.itemId = itemId;
            this.displayName = displayName;
            return this;
        }

        public Builder withValue(long value) {
            this.value = value;
            return this;
        }

        public Builder withRank(int rank) {
            this.rank = rank;
            return this;
        }

        public Builder withPagination(int currentPage, int totalPages) {
            this.currentPage = currentPage;
            this.totalPages = totalPages;
            return this;
        }

        public PlaceholderContext build() {
            return new PlaceholderContext(this);
        }
    }
}

