/*
 * Decompiled with CFR 0.152.
 */
package me.andy.statsmod.util;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.andy.statsmod.Statsmod;
import me.andy.statsmod.config.GenreFormattingConfig;
import me.andy.statsmod.stats.PlayerData;
import me.andy.statsmod.util.InteractiveTextParser;
import me.andy.statsmod.util.PlaceholderContext;
import net.minecraft.class_3222;

public class PlaceholderUtil {
    private static final Pattern GENRE_TOP_PATTERN = Pattern.compile("%([a-zA-Z\\d_]+)_top_(display_name|value|died_display_name|died_value)%");

    public static Function<String, String> createReplacer(PlaceholderContext ctx) {
        return s -> {
            String replaced = s;
            PlayerData playerData = ctx.getPlayerData();
            class_3222 targetPlayer = ctx.getTargetPlayer();
            if (targetPlayer != null) {
                replaced = replaced.replace("%player%", targetPlayer.method_7334().name());
            }
            replaced = replaced.replace("\\n", "\n");
            replaced = replaced.replace("%newline%", "\n");
            int prevPage = Math.max(1, ctx.getCurrentPage() - 1);
            int nextPage = Math.min(ctx.getTotalPages(), ctx.getCurrentPage() + 1);
            replaced = replaced.replace("%current_page%", String.valueOf(ctx.getCurrentPage()));
            replaced = replaced.replace("%total_pages%", String.valueOf(ctx.getTotalPages()));
            replaced = replaced.replace("%prev_page%", String.valueOf(prevPage));
            replaced = replaced.replace("%next_page%", String.valueOf(nextPage));
            replaced = replaced.replace("%rank%", String.valueOf(ctx.getRank()));
            replaced = replaced.replace("%value%", String.valueOf(ctx.getValue()));
            replaced = replaced.replace("%genre_id%", ctx.getGenreId());
            replaced = replaced.replace("%genre_display_name%", ctx.getGenreDisplayName());
            replaced = replaced.replace("%type_id%", ctx.getTypeId());
            replaced = replaced.replace("%type_display_name%", ctx.getTypeDisplayName());
            replaced = replaced.replace("%stat_id%", ctx.getStatId());
            replaced = replaced.replace("%item_id%", ctx.getItemId());
            replaced = replaced.replace("%display_name%", ctx.getDisplayName());
            if (playerData != null) {
                replaced = replaced.replace("%total_broken%", String.valueOf(playerData.getStat("total_broken")));
                replaced = replaced.replace("%total_placed%", String.valueOf(playerData.getStat("total_placed")));
                replaced = replaced.replace("%total_mobs_killed%", String.valueOf(playerData.getStat("total_mobs_killed")));
                replaced = replaced.replace("%players_killed%", String.valueOf(playerData.getStat("players_killed")));
                replaced = replaced.replace("%deaths%", String.valueOf(playerData.getStat("deaths")));
                replaced = replaced.replace("%played_formatted%", PlaceholderUtil.formatDuration(playerData.getStat("played")));
                replaced = replaced.replace("%total_crafted%", String.valueOf(playerData.getStat("total_crafted")));
                replaced = replaced.replace("%total_smelted%", String.valueOf(playerData.getStat("total_smelted")));
                replaced = replaced.replace("%total_brewed%", String.valueOf(playerData.getStat("total_brewed")));
                replaced = replaced.replace("%total_enchanted%", String.valueOf(playerData.getStat("total_enchanted")));
                replaced = replaced.replace("%total_harvested%", String.valueOf(playerData.getStat("total_harvested")));
                replaced = replaced.replace("%total_animals_bred%", String.valueOf(playerData.getStat("total_animals_bred")));
                replaced = replaced.replace("%total_pickedup%", String.valueOf(playerData.getStat("total_pickedup")));
                replaced = replaced.replace("%total_traded%", String.valueOf(playerData.getStat("total_traded")));
                replaced = replaced.replace("%distance%", String.valueOf(playerData.getStat("distance")));
                replaced = replaced.replace("%biomes%", String.valueOf(playerData.getStat("biomes")));
                replaced = replaced.replace("%damaged:dealt%", String.valueOf(playerData.getStat("damaged:dealt")));
                replaced = replaced.replace("%damaged:taken%", String.valueOf(playerData.getStat("damaged:taken")));
                replaced = replaced.replace("%total_fished%", String.valueOf(playerData.getStat("total_fished")));
                replaced = replaced.replace("%flown%", String.valueOf(playerData.getStat("flown")));
                replaced = replaced.replace("%elytra%", String.valueOf(playerData.getStat("elytra")));
                replaced = PlaceholderUtil.replaceDynamicGenrePlaceholders(replaced, playerData);
            }
            return replaced;
        };
    }

    private static String replaceDynamicGenrePlaceholders(String input, PlayerData playerData) {
        GenreFormattingConfig genreConfigContainer = Statsmod.getConfigManager().getGenreFormattingConfig();
        if (genreConfigContainer == null) {
            return input;
        }
        Matcher matcher = GENRE_TOP_PATTERN.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            List<String> rawTrackedIds;
            String genreId = matcher.group(1);
            String placeholderType = matcher.group(2);
            GenreFormattingConfig.GenreConfig genreConfig = genreConfigContainer.genres.get(genreId);
            String replacement = "N/A";
            if (genreConfig != null && genreConfig.listed_blocks_key != null && (rawTrackedIds = Statsmod.getConfigManager().getGenreBlocksConfig().get(genreConfig.listed_blocks_key)) != null) {
                List validTrackedIds = rawTrackedIds.stream().filter(s1 -> s1 != null && !s1.startsWith("#")).collect(Collectors.toList());
                if ("combat".equals(genreId) && (placeholderType.equals("died_display_name") || placeholderType.equals("died_value"))) {
                    Optional topDiedStat = validTrackedIds.stream().map(id -> "died:" + id).filter(statKey -> playerData.getStat((String)statKey) > 0L).map(statKey -> Map.entry(statKey, playerData.getStat((String)statKey))).max(Map.Entry.comparingByValue());
                    if (topDiedStat.isPresent()) {
                        replacement = placeholderType.equals("died_display_name") ? InteractiveTextParser.getDisplayName((String)topDiedStat.get().getKey()) : String.valueOf(topDiedStat.get().getValue());
                    }
                } else {
                    Stream statKeysStream = validTrackedIds.stream().flatMap(id -> PlaceholderUtil.getStatKeysForGenre(genreId, id));
                    Optional topStat = statKeysStream.filter(fullStatKey -> fullStatKey != null && playerData.getStat((String)fullStatKey) > 0L).map(fullStatKey -> Map.entry(fullStatKey, playerData.getStat((String)fullStatKey))).max(Map.Entry.comparingByValue());
                    if (topStat.isPresent()) {
                        if (placeholderType.equals("display_name")) {
                            replacement = InteractiveTextParser.getDisplayName((String)topStat.get().getKey());
                        } else if (placeholderType.equals("value")) {
                            replacement = ((String)topStat.get().getKey()).equals("played") ? PlaceholderUtil.formatDuration((Long)topStat.get().getValue()) : String.valueOf(topStat.get().getValue());
                        }
                    }
                }
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static Stream<String> getStatKeysForGenre(String genreId, String id) {
        switch (genreId) {
            case "mining": 
            case "digging": 
            case "woodcutting": 
            case "building": 
            case "farming": {
                return Stream.of("broken:" + id, "placed:" + id, "pickedup:" + id, "harvested:" + id);
            }
            case "crafting": {
                return Stream.of("crafted:" + id);
            }
            case "smelting": {
                return Stream.of("smelted:" + id);
            }
            case "brewing": {
                return Stream.of("brewed:" + id);
            }
            case "enchanting": {
                return Stream.of("enchanted:" + id);
            }
            case "fishing": {
                return Stream.of("fished:" + id);
            }
            case "trading": {
                return Stream.of("traded:" + id);
            }
            case "combat": 
            case "husbandry": {
                return Stream.of("killed:" + id, "bred:" + id);
            }
            case "exploration": {
                return Stream.of(id);
            }
        }
        return Stream.empty();
    }

    public static String formatDuration(long totalSeconds) {
        if (totalSeconds <= 0L) {
            return "0s";
        }
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        if (seconds > 0L || sb.length() == 0) {
            sb.append(seconds).append("s");
        }
        return sb.toString().trim();
    }
}

