/*
 * Decompiled with CFR 0.152.
 */
package dev.huey.dropperautocraft;

import dev.huey.dropperautocraft.Storage;
import dev.huey.dropperautocraft.Utils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Dropper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.InventoryHolder;

public class EventsManager
implements Listener {
    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractAtEntityEvent ev) {
        Player pl = ev.getPlayer();
        Entity entity = ev.getRightClicked();
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        ItemFrame frame = (ItemFrame)entity;
        if (!frame.getItem().getType().isAir()) {
            return;
        }
        Material productType = pl.getInventory().getItemInMainHand().getType();
        if (productType.isAir()) {
            productType = pl.getInventory().getItemInOffHand().getType();
        }
        if (productType.isAir()) {
            return;
        }
        Block block = frame.getWorld().getBlockAt(frame.getLocation().add(frame.getAttachedFace().getDirection()));
        if (block.getType() != Material.DROPPER) {
            return;
        }
        Storage.autoCrafters.add((Pair<Location, Material>)Pair.of((Object)block.getLocation(), (Object)productType));
        Utils.save();
        pl.sendActionBar(Component.text((String)("Constructed an auto-crafter at " + Utils.formatBlockLoc(block.getLocation()))).color((TextColor)NamedTextColor.GREEN));
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent ev) {
        Utils.removeByBlock(ev.getBlock());
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent ev) {
        Utils.removeByFrame((Entity)ev.getEntity());
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent ev) {
        Utils.removeByFrame(ev.getEntity());
    }

    @EventHandler
    public void onBlockDispense(BlockDispenseEvent ev) {
        if (!ev.getBlock().isBlockPowered()) {
            return;
        }
        if (ev.getBlock().getType() != Material.DROPPER) {
            return;
        }
        if (Storage.autoCrafters.stream().noneMatch(pair -> ((Location)pair.getLeft()).distanceSquared(ev.getBlock().getLocation()) < 1.0)) {
            return;
        }
        ev.setCancelled(true);
    }

    @EventHandler
    public void onInventoryMoveitem(InventoryMoveItemEvent ev) {
        InventoryHolder inventoryHolder = ev.getSource().getHolder();
        if (!(inventoryHolder instanceof Dropper)) {
            return;
        }
        Dropper dropper = (Dropper)inventoryHolder;
        if (!dropper.getBlock().isBlockPowered()) {
            return;
        }
        if (Storage.autoCrafters.stream().noneMatch(pair -> ((Location)pair.getLeft()).distanceSquared(dropper.getBlock().getLocation()) < 1.0)) {
            return;
        }
        ev.setCancelled(true);
    }
}

