/*
 * Decompiled with CFR 0.152.
 */
package dev.huey.dropperautocraft;

import dev.huey.dropperautocraft.Storage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dropper;
import org.bukkit.block.data.Directional;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.CraftingRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class Utils {
    static void log(Object any) {
        Storage.plugin.getLogger().info(String.valueOf(any));
    }

    static void warn(Object any) {
        Storage.plugin.getLogger().warning(String.valueOf(any));
    }

    static void error(Object any) {
        Storage.plugin.getLogger().severe(String.valueOf(any));
    }

    static String formatBlockLoc(Location loc) {
        return "(" + loc.getBlockX() + ", " + loc.getBlockY() + ", " + loc.getBlockZ() + ")";
    }

    static void save() {
        File file = new File(Storage.plugin.getDataFolder().getAbsolutePath(), "data.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        List<Location> locs = Storage.autoCrafters.stream().map(p -> (Location)p.getLeft()).toList();
        config.set("locations", locs);
        List<String> materials = Storage.autoCrafters.stream().map(p -> ((Material)p.getRight()).toString()).toList();
        config.set("products", materials);
        try {
            config.save(file);
        }
        catch (IOException e) {
            Utils.error("Cannot save data!");
        }
    }

    static void load() {
        File file = new File(Storage.plugin.getDataFolder().getAbsolutePath(), "data.yml");
        if (!file.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        List locs = (List)config.get("locations");
        List<Material> materials = ((List)config.get("products")).stream().map(Material::getMaterial).toList();
        Storage.autoCrafters.clear();
        for (int i = 0; i < locs.size(); ++i) {
            Storage.autoCrafters.add((Pair<Location, Material>)Pair.of((Object)((Location)locs.get(i)), (Object)materials.get(i)));
        }
    }

    static boolean takeIngredients(Inventory inv, Recipe recipe) {
        List<RecipeChoice> choices = new ArrayList();
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            Map choiceMap = shapedRecipe.getChoiceMap();
            for (String line : shapedRecipe.getShape()) {
                char[] cArray = line.toCharArray();
                int n = cArray.length;
                for (int i = 0; i < n; ++i) {
                    Character c = Character.valueOf(cArray[i]);
                    choices.add((RecipeChoice)choiceMap.get(c));
                }
            }
        }
        if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
            choices = shapelessRecipe.getChoiceList();
        }
        boolean success = true;
        for (RecipeChoice choice : choices) {
            if (choice == null) continue;
            boolean fulfill = false;
            for (int i = 0; i < inv.getSize(); ++i) {
                ItemStack stack = inv.getItem(i);
                if (stack == null || stack.isEmpty() || !choice.test(stack)) continue;
                if (stack.getAmount() == 1) {
                    inv.setItem(i, ItemStack.empty());
                } else {
                    stack.setAmount(stack.getAmount() - 1);
                }
                fulfill = true;
                break;
            }
            if (fulfill) continue;
            success = false;
            break;
        }
        return success;
    }

    static void removeByBlock(Block block) {
        if (block.getType() != Material.DROPPER) {
            return;
        }
        Storage.autoCrafters.removeIf(pair -> ((Location)pair.getLeft()).distanceSquared(block.getLocation()) < 1.0);
        Utils.save();
    }

    static void removeByFrame(Entity entity) {
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        ItemFrame frame = (ItemFrame)entity;
        Utils.removeByBlock(frame.getWorld().getBlockAt(frame.getLocation().add(frame.getAttachedFace().getDirection())));
    }

    static int getDroppableCount(Dropper dropper, Material type) {
        Block targetBlock = dropper.getBlock().getRelative(((Directional)dropper.getBlock().getBlockData()).getFacing());
        BlockState blockState = targetBlock.getState();
        if (!(blockState instanceof InventoryHolder)) {
            return 128;
        }
        InventoryHolder holder = (InventoryHolder)blockState;
        if (type == null || type.isAir()) {
            return 0;
        }
        int space = 0;
        for (ItemStack item : holder.getInventory()) {
            if (item == null || item.getType().isAir()) {
                space += type.getMaxStackSize();
                continue;
            }
            if (item.getType() != type) continue;
            space += type.getMaxStackSize() - item.getAmount();
        }
        return space;
    }

    static void doAutoCraft(Dropper dropper, Material productType) {
        Inventory inv = dropper.getInventory();
        Inventory oldInv = dropper.getSnapshotInventory();
        for (Recipe recipe : Storage.plugin.getServer().getRecipesFor(new ItemStack(productType, 1))) {
            if (!(recipe instanceof CraftingRecipe) || recipe.getResult().getAmount() > Utils.getDroppableCount(dropper, productType)) continue;
            if (Utils.takeIngredients(oldInv, recipe)) {
                inv.clear();
                inv.addItem(new ItemStack[]{recipe.getResult()});
                while (!inv.isEmpty()) {
                    dropper.drop();
                }
                for (int i = 0; i < oldInv.getSize(); ++i) {
                    inv.setItem(i, oldInv.getItem(i));
                }
                break;
            }
            oldInv = dropper.getSnapshotInventory();
        }
    }

    static void runTick() {
        for (Pair<Location, Material> pair : Storage.autoCrafters) {
            Location loc = (Location)pair.getLeft();
            Material productType = (Material)pair.getRight();
            Block block = loc.getWorld().getBlockAt(loc);
            if (block.getType() != Material.DROPPER) {
                Utils.warn("Not dropper at expected location: " + Utils.formatBlockLoc(loc));
                continue;
            }
            if (block.isBlockPowered()) continue;
            Utils.doAutoCraft((Dropper)block.getState(), productType);
        }
        Storage.plugin.getServer().getScheduler().runTaskLater(Storage.plugin, Utils::runTick, 8L);
    }
}

