/*
 * Decompiled with CFR 0.152.
 */
package com.mrpotato.autocomposter;

import com.mrpotato.autocomposter.data.ComposterManager;
import com.mrpotato.autocomposter.listeners.BlockListeners;
import com.mrpotato.autocomposter.listeners.InventoryListeners;
import com.mrpotato.autocomposter.tasks.HologramUpdater;
import com.mrpotato.autocomposter.tasks.PlanterTask;
import com.mrpotato.autocomposter.util.ItemUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class CustomComposterPlugin
extends JavaPlugin {
    private static CustomComposterPlugin instance;
    private ComposterManager composterManager;

    public static CustomComposterPlugin get() {
        return instance;
    }

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.composterManager = new ComposterManager(this);
        this.composterManager.loadAll();
        Bukkit.getPluginManager().registerEvents((Listener)new BlockListeners(this.composterManager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new InventoryListeners(this.composterManager), (Plugin)this);
        this.registerRecipe();
        new PlanterTask(this.composterManager).runTaskTimer((Plugin)this, 20L, 20L);
        new HologramUpdater(this.composterManager).runTaskTimer((Plugin)this, 0L, 20L);
        this.getLogger().info("CustomComposter enabled.");
    }

    public void onDisable() {
        this.composterManager.saveAll();
        this.composterManager.despawnAllHolograms();
        this.getLogger().info("CustomComposter disabled.");
    }

    private void registerRecipe() {
        NamespacedKey key = new NamespacedKey((Plugin)this, "custom_composter");
        ShapedRecipe recipe = new ShapedRecipe(key, ItemUtil.createCustomComposterItem());
        recipe.shape(new String[]{"###", "OCO", "WWW"});
        recipe.setIngredient('#', Material.COAL);
        recipe.setIngredient('O', Material.OAK_LOG);
        recipe.setIngredient('C', Material.COMPOSTER);
        recipe.setIngredient('W', Material.WHEAT_SEEDS);
        Bukkit.addRecipe((Recipe)recipe);
    }

    public ComposterManager manager() {
        return this.composterManager;
    }
}

