/*
 * Decompiled with CFR 0.152.
 */
package com.mrpotato.autocomposter.data;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;

public class ComposterData {
    public Location location;
    public int wheatSeeds = 0;
    public int carrotSeeds = 0;
    public int potatoSeeds = 0;
    public int coal = 0;
    public int plantedSinceCoal = 0;
    public long nextCheckAtMillis = 0L;
    public UUID hologramUuid = null;

    public ComposterData(Location location) {
        this.location = location;
    }

    public int totalSeeds() {
        return this.wheatSeeds + this.carrotSeeds + this.potatoSeeds;
    }

    public void saveTo(ConfigurationSection sec) {
        sec.set("world", (Object)this.location.getWorld().getName());
        sec.set("x", (Object)this.location.getBlockX());
        sec.set("y", (Object)this.location.getBlockY());
        sec.set("z", (Object)this.location.getBlockZ());
        sec.set("wheat", (Object)this.wheatSeeds);
        sec.set("carrot", (Object)this.carrotSeeds);
        sec.set("potato", (Object)this.potatoSeeds);
        sec.set("coal", (Object)this.coal);
        sec.set("plantedSinceCoal", (Object)this.plantedSinceCoal);
        sec.set("nextCheckAt", (Object)this.nextCheckAtMillis);
        sec.set("hologram", this.hologramUuid == null ? null : this.hologramUuid.toString());
    }

    public static ComposterData loadFrom(ConfigurationSection sec) {
        String worldName = sec.getString("world");
        World w = Bukkit.getWorld((String)worldName);
        if (w == null) {
            return null;
        }
        int x = sec.getInt("x");
        int y = sec.getInt("y");
        int z = sec.getInt("z");
        ComposterData data = new ComposterData(new Location(w, (double)x, (double)y, (double)z));
        data.wheatSeeds = sec.getInt("wheat", 0);
        data.carrotSeeds = sec.getInt("carrot", 0);
        data.potatoSeeds = sec.getInt("potato", 0);
        data.coal = sec.getInt("coal", 0);
        data.plantedSinceCoal = sec.getInt("plantedSinceCoal", 0);
        data.nextCheckAtMillis = sec.getLong("nextCheckAt", 0L);
        String h = sec.getString("hologram", null);
        if (h != null) {
            try {
                data.hologramUuid = UUID.fromString(h);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return data;
    }
}

