/*
 * Decompiled with CFR 0.152.
 */
package com.mrpotato.autocomposter.data;

import com.mrpotato.autocomposter.CustomComposterPlugin;
import com.mrpotato.autocomposter.data.ComposterData;
import com.mrpotato.autocomposter.util.ItemUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class ComposterManager {
    private final CustomComposterPlugin plugin;
    private final Map<String, ComposterData> dataByKey = new HashMap<String, ComposterData>();
    private final File dataFile;
    private FileConfiguration dataCfg;
    public static final int RANGE = 12;
    public static final long CHECK_COOLDOWN_MS = 5000L;

    public ComposterManager(CustomComposterPlugin plugin) {
        this.plugin = plugin;
        this.dataFile = new File(plugin.getDataFolder(), "data.yml");
    }

    private String keyFor(Location loc) {
        return loc.getWorld().getName() + "," + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    public boolean isCustomComposter(Block block) {
        if (block == null || block.getType() != Material.COMPOSTER) {
            return false;
        }
        return this.dataByKey.containsKey(this.keyFor(block.getLocation()));
    }

    public ComposterData get(Block block) {
        return this.dataByKey.get(this.keyFor(block.getLocation()));
    }

    public ComposterData add(Block block) {
        ComposterData data = new ComposterData(block.getLocation());
        data.nextCheckAtMillis = System.currentTimeMillis();
        this.dataByKey.put(this.keyFor(block.getLocation()), data);
        this.spawnOrRefreshHologram(data);
        return data;
    }

    public void remove(Block block) {
        ComposterData data = this.dataByKey.remove(this.keyFor(block.getLocation()));
        if (data != null) {
            this.despawnHologram(data);
        }
    }

    public void dropCustomItemNaturally(Block block) {
        block.getWorld().dropItemNaturally(block.getLocation().add(0.5, 0.8, 0.5), ItemUtil.createCustomComposterItem());
    }

    public void spawnOrRefreshHologram(ComposterData data) {
        if (data.location.getWorld() == null) {
            return;
        }
        ArmorStand as = this.findHologram(data);
        if (as == null) {
            Location holoLoc = data.location.clone().add(0.5, 1.75, 0.5);
            as = (ArmorStand)data.location.getWorld().spawn(holoLoc, ArmorStand.class, stand -> {
                stand.setInvisible(true);
                stand.setMarker(true);
                stand.setGravity(false);
                stand.setCustomNameVisible(true);
                stand.setSmall(true);
                stand.setInvulnerable(true);
                stand.setPersistent(true);
            });
            data.hologramUuid = as.getUniqueId();
        }
        this.updateHologramText(data, as);
    }

    public void updateAllHolograms() {
        for (ComposterData data : this.dataByKey.values()) {
            ArmorStand as = this.findOrRespawn(data);
            this.updateHologramText(data, as);
        }
    }

    private void updateHologramText(ComposterData data, ArmorStand as) {
        long now = System.currentTimeMillis();
        long ms = Math.max(0L, data.nextCheckAtMillis - now);
        long s = ms / 1000L;
        NamedTextColor color = s <= 0L ? NamedTextColor.GREEN : NamedTextColor.YELLOW;
        Object status = s <= 0L ? "Ready" : "Cooldown: " + s + "s";
        String stock = "Seeds: " + data.totalSeeds() + "  Coal: " + data.coal;
        as.customName((Component)Component.text((String)((String)status + "  " + stock), (TextColor)color));
    }

    public void despawnAllHolograms() {
        for (ComposterData data : this.dataByKey.values()) {
            this.despawnHologram(data);
        }
    }

    private void despawnHologram(ComposterData data) {
        ArmorStand as = this.findHologram(data);
        if (as != null && !as.isDead()) {
            as.remove();
        }
        data.hologramUuid = null;
    }

    private ArmorStand findHologram(ComposterData data) {
        ArmorStand as;
        if (data.hologramUuid == null || data.location.getWorld() == null) {
            return null;
        }
        Entity e = Bukkit.getEntity((UUID)data.hologramUuid);
        return e instanceof ArmorStand && (as = (ArmorStand)e).isValid() ? as : null;
    }

    private ArmorStand findOrRespawn(ComposterData data) {
        ArmorStand as = this.findHologram(data);
        if (as != null) {
            return as;
        }
        this.spawnOrRefreshHologram(data);
        return this.findHologram(data);
    }

    public void loadAll() {
        this.dataByKey.clear();
        if (!this.dataFile.exists()) {
            this.dataFile.getParentFile().mkdirs();
            this.dataCfg = new YamlConfiguration();
            return;
        }
        this.dataCfg = YamlConfiguration.loadConfiguration((File)this.dataFile);
        ConfigurationSection root = this.dataCfg.getConfigurationSection("composters");
        if (root != null) {
            for (String k : root.getKeys(false)) {
                ComposterData d = ComposterData.loadFrom(root.getConfigurationSection(k));
                if (d == null) continue;
                this.dataByKey.put(k, d);
            }
        }
        Bukkit.getScheduler().runTaskLater((Plugin)CustomComposterPlugin.get(), () -> {
            for (ComposterData data : this.dataByKey.values()) {
                this.spawnOrRefreshHologram(data);
            }
        }, 20L);
    }

    public void saveAll() {
        this.dataCfg = new YamlConfiguration();
        ConfigurationSection root = this.dataCfg.createSection("composters");
        for (Map.Entry<String, ComposterData> e : this.dataByKey.entrySet()) {
            ConfigurationSection sec = root.createSection(e.getKey());
            e.getValue().saveTo(sec);
        }
        try {
            this.dataCfg.save(this.dataFile);
        }
        catch (IOException ex) {
            this.plugin.getLogger().warning("Failed to save data.yml: " + ex.getMessage());
        }
    }

    public Collection<ComposterData> all() {
        return Collections.unmodifiableCollection(this.dataByKey.values());
    }
}

