/*
 * Decompiled with CFR 0.152.
 */
package com.mrpotato.autocomposter.gui;

import com.mrpotato.autocomposter.data.ComposterData;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class ComposterGUI {
    public static final int SLOT_WHEAT = 10;
    public static final int SLOT_POTATO = 11;
    public static final int SLOT_CARROT = 12;
    public static final int SLOT_COAL = 14;

    private ComposterGUI() {
    }

    public static Inventory build(ComposterData data) {
        Inventory inv = Bukkit.createInventory(null, (int)27, (Component)Component.text((String)"Custom Composter", (TextColor)NamedTextColor.DARK_GREEN));
        ItemStack pane = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta pm = pane.getItemMeta();
        pm.displayName((Component)Component.text((String)" "));
        pane.setItemMeta(pm);
        for (int i = 0; i < inv.getSize(); ++i) {
            inv.setItem(i, pane);
        }
        inv.setItem(10, ComposterGUI.stackWithCount(Material.WHEAT_SEEDS, data.wheatSeeds, "Wheat Seeds"));
        inv.setItem(11, ComposterGUI.stackWithCount(Material.POTATO, data.potatoSeeds, "Potato Seeds"));
        inv.setItem(12, ComposterGUI.stackWithCount(Material.CARROT, data.carrotSeeds, "Carrot Seeds"));
        inv.setItem(14, ComposterGUI.stackWithCount(Material.COAL, data.coal, "Fuel (Coal)"));
        return inv;
    }

    private static ItemStack stackWithCount(Material mat, int count, String label) {
        ItemStack it = new ItemStack(mat);
        ItemMeta im = it.getItemMeta();
        im.displayName((Component)Component.text((String)label, (TextColor)NamedTextColor.GREEN));
        im.lore(List.of(Component.text((String)"Click & place items here", (TextColor)NamedTextColor.GRAY), Component.text((String)("Current: " + count), (TextColor)NamedTextColor.GRAY)));
        it.setItemMeta(im);
        it.setAmount(Math.max(1, Math.min(64, count == 0 ? 1 : Math.min(64, count))));
        return it;
    }

    public static boolean isSeed(Material m) {
        return m == Material.WHEAT_SEEDS || m == Material.CARROT || m == Material.POTATO;
    }

    public static boolean isCoal(Material m) {
        return m == Material.COAL;
    }

    public static void applyFromInventory(Inventory inv, ComposterData data) {
        data.wheatSeeds = Math.max(0, inv.getItem(10) != null ? inv.getItem(10).getAmount() : 0);
        data.potatoSeeds = Math.max(0, inv.getItem(11) != null ? inv.getItem(11).getAmount() : 0);
        data.carrotSeeds = Math.max(0, inv.getItem(12) != null ? inv.getItem(12).getAmount() : 0);
        data.coal = Math.max(0, inv.getItem(14) != null ? inv.getItem(14).getAmount() : 0);
    }
}

