/*
 * Decompiled with CFR 0.152.
 */
package com.mrpotato.autocomposter.listeners;

import com.mrpotato.autocomposter.data.ComposterData;
import com.mrpotato.autocomposter.data.ComposterManager;
import com.mrpotato.autocomposter.gui.ComposterGUI;
import com.mrpotato.autocomposter.util.ItemUtil;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;

public class BlockListeners
implements Listener {
    private final ComposterManager manager;

    public BlockListeners(ComposterManager manager) {
        this.manager = manager;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlace(BlockPlaceEvent e) {
        if (!ItemUtil.isCustomComposter(e.getItemInHand())) {
            return;
        }
        Block b = e.getBlockPlaced();
        if (b.getType() != Material.COMPOSTER) {
            b.setType(Material.COMPOSTER, false);
        }
        this.manager.add(b);
        e.getPlayer().sendMessage(String.valueOf(ChatColor.GREEN) + "Placed a Custom Composter.");
    }

    @EventHandler(ignoreCancelled=true)
    public void onBreak(BlockBreakEvent e) {
        Block b = e.getBlock();
        if (b.getType() == Material.COMPOSTER && this.manager.isCustomComposter(b)) {
            e.setDropItems(false);
            this.manager.dropCustomItemNaturally(b);
            this.manager.remove(b);
            e.getPlayer().sendMessage(String.valueOf(ChatColor.YELLOW) + "Custom Composter removed.");
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInteract(PlayerInteractEvent e) {
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block b = e.getClickedBlock();
        if (b == null || b.getType() != Material.COMPOSTER) {
            return;
        }
        if (!this.manager.isCustomComposter(b)) {
            return;
        }
        e.setCancelled(true);
        Player p = e.getPlayer();
        ComposterData data = this.manager.get(b);
        Inventory gui = ComposterGUI.build(data);
        p.openInventory(gui);
    }
}

