/*
 * Decompiled with CFR 0.152.
 */
package com.mrpotato.autocomposter.listeners;

import com.mrpotato.autocomposter.data.ComposterData;
import com.mrpotato.autocomposter.data.ComposterManager;
import com.mrpotato.autocomposter.gui.ComposterGUI;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class InventoryListeners
implements Listener {
    private final ComposterManager manager;

    public InventoryListeners(ComposterManager manager) {
        this.manager = manager;
    }

    private boolean isOurGUI(InventoryView view) {
        return view != null && view.getTitle() != null && ChatColor.stripColor((String)view.getTitle()).equalsIgnoreCase("Custom Composter");
    }

    @EventHandler(ignoreCancelled=true)
    public void onClick(InventoryClickEvent e) {
        boolean topInv;
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        if (!this.isOurGUI(e.getView())) {
            return;
        }
        int slot = e.getRawSlot();
        boolean bl = topInv = slot < e.getView().getTopInventory().getSize();
        if (topInv) {
            if (slot == 10 || slot == 11 || slot == 12) {
                ItemStack cursor = e.getCursor();
                if (cursor != null && cursor.getType() != Material.AIR && !ComposterGUI.isSeed(cursor.getType())) {
                    e.setCancelled(true);
                }
            } else if (slot == 14) {
                ItemStack cursor = e.getCursor();
                if (cursor != null && cursor.getType() != Material.AIR && !ComposterGUI.isCoal(cursor.getType())) {
                    e.setCancelled(true);
                }
            } else {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent e) {
        if (!this.isOurGUI(e.getView())) {
            return;
        }
        HumanEntity he = e.getPlayer();
        double best = Double.MAX_VALUE;
        ComposterData target = null;
        for (ComposterData d : this.manager.all()) {
            if (!d.location.getWorld().equals((Object)he.getWorld())) continue;
            double dist = d.location.add(0.5, 1.75, 0.5).distanceSquared(he.getLocation());
            d.location.subtract(0.5, 1.75, 0.5);
            if (!(dist < best) || !(dist < 100.0)) continue;
            best = dist;
            target = d;
        }
        if (target == null) {
            he.sendMessage(String.valueOf(ChatColor.RED) + "Could not link GUI to a composter. No changes saved.");
            return;
        }
        Inventory top = e.getView().getTopInventory();
        ComposterGUI.applyFromInventory(top, target);
        this.manager.spawnOrRefreshHologram(target);
        he.sendMessage(String.valueOf(ChatColor.GREEN) + "Custom Composter updated.");
    }
}

