/*
 * Decompiled with CFR 0.152.
 */
package com.mrpotato.autocomposter.tasks;

import com.mrpotato.autocomposter.data.ComposterData;
import com.mrpotato.autocomposter.data.ComposterManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.scheduler.BukkitRunnable;

public class PlanterTask
extends BukkitRunnable {
    private final ComposterManager manager;

    public PlanterTask(ComposterManager manager) {
        this.manager = manager;
    }

    public void run() {
        long now = System.currentTimeMillis();
        for (ComposterData data : this.manager.all()) {
            if (now < data.nextCheckAtMillis) continue;
            data.nextCheckAtMillis = now + 5000L;
            this.tryPlantAround(data);
        }
    }

    private void tryPlantAround(ComposterData data) {
        World world = data.location.getWorld();
        if (world == null) {
            return;
        }
        if (!world.isChunkLoaded(data.location.getBlockX() >> 4, data.location.getBlockZ() >> 4)) {
            return;
        }
        int totalSeeds = data.totalSeeds();
        if (totalSeeds <= 0) {
            return;
        }
        if (data.plantedSinceCoal == 0 && data.coal <= 0) {
            return;
        }
        List<Block> spots = this.findPlantableSpots(world, data.location, 12);
        if (spots.isEmpty()) {
            return;
        }
        Collections.shuffle(spots);
        int planted = 0;
        for (Block farmland : spots) {
            Material toPlant;
            if (data.totalSeeds() <= 0) break;
            if (data.plantedSinceCoal >= 10) {
                if (data.coal <= 0) break;
                --data.coal;
                data.plantedSinceCoal = 0;
            }
            if ((toPlant = this.chooseSeedBlock(data)) == null) break;
            Block above = farmland.getRelative(0, 1, 0);
            if (!above.getType().isAir()) continue;
            above.setType(toPlant, false);
            BlockData bd = above.getBlockData();
            if (bd instanceof Ageable) {
                Ageable age = (Ageable)bd;
                age.setAge(0);
                above.setBlockData((BlockData)age, false);
            }
            this.decrementSeed(data, toPlant);
            ++data.plantedSinceCoal;
            ++planted;
        }
        if (planted > 0) {
            this.manager.spawnOrRefreshHologram(data);
        }
    }

    private List<Block> findPlantableSpots(World world, Location center, int radius) {
        ArrayList<Block> list = new ArrayList<Block>();
        int cx = center.getBlockX();
        int cy = center.getBlockY();
        int cz = center.getBlockZ();
        int r = radius;
        for (int x = cx - r; x <= cx + r; ++x) {
            for (int z = cz - r; z <= cz + r; ++z) {
                if ((x - cx) * (x - cx) + (z - cz) * (z - cz) > r * r) continue;
                for (int y = cy - 2; y <= cy + 2; ++y) {
                    Block above;
                    Block b = world.getBlockAt(x, y, z);
                    if (b.getType() != Material.FARMLAND || !(above = b.getRelative(0, 1, 0)).getType().isAir()) continue;
                    list.add(b);
                }
            }
        }
        return list;
    }

    private Material chooseSeedBlock(ComposterData data) {
        int w = data.wheatSeeds;
        int c = data.carrotSeeds;
        int p = data.potatoSeeds;
        if (w >= c && w >= p && w > 0) {
            return Material.WHEAT;
        }
        if (c >= w && c >= p && c > 0) {
            return Material.CARROTS;
        }
        if (p > 0) {
            return Material.POTATOES;
        }
        return null;
    }

    private void decrementSeed(ComposterData data, Material planted) {
        switch (planted) {
            case WHEAT: {
                data.wheatSeeds = Math.max(0, data.wheatSeeds - 1);
                break;
            }
            case CARROTS: {
                data.carrotSeeds = Math.max(0, data.carrotSeeds - 1);
                break;
            }
            case POTATOES: {
                data.potatoSeeds = Math.max(0, data.potatoSeeds - 1);
                break;
            }
        }
    }
}

