/*
 * Decompiled with CFR 0.152.
 */
package com.mrpotato.autocomposter.util;

import com.mrpotato.autocomposter.CustomComposterPlugin;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public final class ItemUtil {
    private static final NamespacedKey KEY = new NamespacedKey((Plugin)CustomComposterPlugin.get(), "is_custom_composter");

    private ItemUtil() {
    }

    public static ItemStack createCustomComposterItem() {
        ItemStack item = new ItemStack(Material.COMPOSTER);
        ItemMeta meta = item.getItemMeta();
        meta.displayName((Component)Component.text((String)"Custom Composter", (TextColor)NamedTextColor.GREEN));
        meta.lore(List.of(Component.text((String)"Right-click to open GUI", (TextColor)NamedTextColor.GRAY), Component.text((String)"Plants seeds within 12 blocks", (TextColor)NamedTextColor.DARK_GRAY), Component.text((String)"Fuel: 1 coal per 10 seeds", (TextColor)NamedTextColor.DARK_GRAY), Component.text((String)"5s cooldown between checks", (TextColor)NamedTextColor.DARK_GRAY)));
        meta.getPersistentDataContainer().set(KEY, PersistentDataType.BYTE, (Object)1);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        item.setItemMeta(meta);
        return item;
    }

    public static boolean isCustomComposter(ItemStack item) {
        if (item == null || item.getType() != Material.COMPOSTER) {
            return false;
        }
        if (!item.hasItemMeta()) {
            return false;
        }
        Byte b = (Byte)item.getItemMeta().getPersistentDataContainer().get(KEY, PersistentDataType.BYTE);
        return b != null && b == 1;
    }
}

