/*
 * Decompiled with CFR 0.152.
 */
package band.kessokuteatime.nightautoconfig.config;

import band.kessokuteatime.nightautoconfig.NightAutoConfig;
import band.kessokuteatime.nightautoconfig.config.base.ConfigType;
import band.kessokuteatime.nightautoconfig.serde.NightDeserializers;
import band.kessokuteatime.nightautoconfig.serde.NightSerializers;
import band.kessokuteatime.nightautoconfig.util.AnnotationUtil;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.file.GenericBuilder;
import com.electronwill.nightconfig.core.serde.ObjectDeserializer;
import com.electronwill.nightconfig.core.serde.ObjectDeserializerBuilder;
import com.electronwill.nightconfig.core.serde.ObjectSerializer;
import com.electronwill.nightconfig.core.serde.ObjectSerializerBuilder;
import com.electronwill.nightconfig.core.serde.ValueDeserializerProvider;
import com.electronwill.nightconfig.core.serde.ValueSerializerProvider;
import com.electronwill.nightconfig.core.serde.annotations.SerdeDefault;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.UnaryOperator;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.util.Utils;
import org.jetbrains.annotations.NotNull;

public class NightConfigSerializer<T extends ConfigData>
implements ConfigSerializer<T> {
    protected final me.shedaniel.autoconfig.annotation.Config definition;
    protected final Class<T> configClass;
    protected final ConfigType type;
    protected final GenericBuilder<Config, FileConfig> builder;

    public NightConfigSerializer(me.shedaniel.autoconfig.annotation.Config definition, Class<T> configClass, ConfigType type, GenericBuilder<Config, FileConfig> builder) {
        this.definition = definition;
        this.configClass = configClass;
        this.type = type;
        this.builder = builder;
    }

    public void serialize(@NotNull T t) throws ConfigSerializer.SerializationException {
        Path path = this.type.getConfigPath(this.definition);
        try {
            this.createFile(path);
        }
        catch (IOException e) {
            throw new ConfigSerializer.SerializationException((Throwable)e);
        }
        try {
            FileConfig config = ((FileConfig)this.serializer(this.configClass).serializeFields(t, () -> this.builder.build())).checked();
            config.save();
            config.close();
        }
        catch (Exception e) {
            NightAutoConfig.LOGGER.error("Serialization failed for config {}! This will cause the program to stop writing anything to the file.", (Object)this.type.getRelativeConfigPath(this.definition));
            NightAutoConfig.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public T deserialize() throws ConfigSerializer.SerializationException {
        Path path = this.type.getConfigPath(this.definition);
        try {
            this.createFile(path);
        }
        catch (IOException e) {
            throw new ConfigSerializer.SerializationException((Throwable)e);
        }
        try {
            FileConfig config = this.builder.build();
            config.load();
            if (config.isEmpty()) {
                return this.createDefault();
            }
            return (T)((ConfigData)this.deserializer(this.configClass).deserializeFields((UnmodifiableConfig)config, this::createDefault));
        }
        catch (Exception e) {
            NightAutoConfig.LOGGER.error("Deserialization failed for config {}! This will cause the program to ignore the existing modifications and use default values. This might be caused by a missing of {} on restricting value fallbacks.", (Object)this.type.getRelativeConfigPath(this.definition), SerdeDefault.class);
            NightAutoConfig.LOGGER.error(e.getMessage(), (Throwable)e);
            return this.createDefault();
        }
    }

    public T createDefault() {
        return (T)((ConfigData)Utils.constructUnsafely(this.configClass));
    }

    private void createFile(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
        }
    }

    private ObjectSerializer serializer(Class<?> cls) {
        ObjectSerializerBuilder builder = ObjectSerializer.builder();
        NightSerializers.provideToBuilder(builder);
        List<ValueSerializerProvider<?, ?>> providers = AnnotationUtil.getSerializerProviders(cls);
        providers.forEach(arg_0 -> ((ObjectSerializerBuilder)builder).withSerializerProvider(arg_0));
        return builder.build();
    }

    private ObjectDeserializer deserializer(Class<?> cls) {
        ObjectDeserializerBuilder builder = ObjectDeserializer.builder();
        NightDeserializers.provideToBuilder(builder);
        List<ValueDeserializerProvider<?, ?>> providers = AnnotationUtil.getDeserializerProviders(cls);
        providers.forEach(arg_0 -> ((ObjectDeserializerBuilder)builder).withDeserializerProvider(arg_0));
        return builder.build();
    }

    public record Builder(ConfigType type, UnaryOperator<GenericBuilder<Config, FileConfig>> genericBuilder) {
        public Builder(ConfigType type) {
            this(type, UnaryOperator.identity());
        }

        public Builder type(ConfigType type) {
            return new Builder(type, this.genericBuilder);
        }

        public Builder then(UnaryOperator<GenericBuilder<Config, FileConfig>> then) {
            return new Builder(this.type, b -> (GenericBuilder)then.apply((GenericBuilder)this.genericBuilder.apply((GenericBuilder<Config, FileConfig>)b)));
        }

        public <T extends ConfigData> NightConfigSerializer<T> build(me.shedaniel.autoconfig.annotation.Config definition, Class<T> configClass) {
            return new NightConfigSerializer<T>(definition, configClass, this.type, (GenericBuilder<Config, FileConfig>)((GenericBuilder)this.genericBuilder.apply((GenericBuilder<Config, FileConfig>)FileConfig.builder((Path)this.type.getConfigPath(definition)))));
        }
    }
}

