/*
 * Decompiled with CFR 0.152.
 */
package band.kessokuteatime.nightautoconfig.config.base;

import band.kessokuteatime.nightautoconfig.config.NightConfigSerializer;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.file.GenericBuilder;
import com.electronwill.nightconfig.hocon.HoconFormat;
import com.electronwill.nightconfig.json.JsonFormat;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.electronwill.nightconfig.yaml.YamlFormat;
import java.nio.file.Path;
import java.util.function.UnaryOperator;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.util.Utils;
import net.neoforged.fml.loading.FMLPaths;

public enum ConfigType {
    JSON("json"),
    YAML("yaml"),
    TOML("toml"),
    HOCON("conf");

    private final String suffix;
    public static final ConfigType DEFAULT_SIMPLE;
    public static final ConfigType DEFAULT_COMMENTED;

    private ConfigType(String suffix) {
        this.suffix = suffix;
    }

    public String suffix() {
        return this.suffix;
    }

    public String getFileName(Config definition) {
        return definition.name() + "." + this.suffix();
    }

    public Path getConfigPath(Config definition) {
        return Utils.getConfigFolder().resolve(this.getFileName(definition));
    }

    public Path getRelativeConfigPath(Config definition) {
        return FMLPaths.CONFIGDIR.get().relativize(this.getConfigPath(definition));
    }

    public NightConfigSerializer.Builder builder() {
        return new NightConfigSerializer.Builder(this);
    }

    public <T extends ConfigData> ConfigSerializer.Factory<T> serializer(UnaryOperator<GenericBuilder<com.electronwill.nightconfig.core.Config, FileConfig>> genericBuilderConstructor) {
        return (definition, configClass) -> this.builder().then(genericBuilderConstructor).build(definition, configClass);
    }

    public <T extends ConfigData> NightConfigSerializer<T> defaultSerializer(Config definition, Class<T> configClass) {
        return this.builder().then(GenericBuilder::preserveInsertionOrder).build(definition, configClass);
    }

    public <T extends ConfigData> NightConfigSerializer<T> fileWatcherSerializer(Config definition, Class<T> configClass) {
        return this.builder().then(GenericBuilder::preserveInsertionOrder).then(GenericBuilder::autosave).then(GenericBuilder::autoreload).build(definition, configClass);
    }

    public ConfigFormat<?> format() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> JsonFormat.fancyInstance();
            case 1 -> YamlFormat.defaultInstance();
            case 2 -> TomlFormat.instance();
            case 3 -> HoconFormat.instance();
        };
    }

    static {
        DEFAULT_SIMPLE = JSON;
        DEFAULT_COMMENTED = TOML;
    }
}

