/*
 * Decompiled with CFR 0.152.
 */
package band.kessokuteatime.nightautoconfig.example.config;

import com.electronwill.nightconfig.core.serde.annotations.SerdeComment;
import com.electronwill.nightconfig.core.serde.annotations.SerdeCommentsContainer;
import com.electronwill.nightconfig.core.serde.annotations.SerdeDefault;
import com.electronwill.nightconfig.core.serde.annotations.SerdeKey;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

@Config(name="example")
public class NightExampleConfig
implements ConfigData {
    private final transient Supplier<Integer> exampleIntProvider = () -> 10;
    @SerdeDefault(provider="exampleIntProvider")
    public int exampleInt = this.exampleIntProvider.get();
    private final transient Supplier<Long> exampleLongProvider = () -> 100L;
    @SerdeCommentsContainer(value={@SerdeComment(value="This is a comment."), @SerdeComment(value="This is another comment.")})
    @SerdeDefault(provider="exampleLongProvider")
    public long exampleLong = this.exampleLongProvider.get();
    private final transient Supplier<Double> exampleDoubleProvider = () -> 3.14159;
    @SerdeDefault(provider="exampleDoubleProvider")
    public double exampleDouble = this.exampleDoubleProvider.get();
    private final transient Supplier<Float> exampleFloatProvider = () -> Float.valueOf(2.71828f);
    @SerdeDefault(provider="exampleFloatProvider")
    public float exampleFloat = this.exampleFloatProvider.get().floatValue();
    private final transient Supplier<Boolean> exampleBooleanProvider = () -> true;
    @SerdeDefault(provider="exampleBooleanProvider")
    public boolean exampleBoolean = this.exampleBooleanProvider.get();
    private final transient Supplier<Color> exampleColorProvider = () -> Color.ORANGE;
    @SerdeDefault(provider="exampleColorProvider")
    public Color exampleColor = this.exampleColorProvider.get();
    private final transient Supplier<String> exampleStringProvider = () -> "Hello, world!";
    @SerdeDefault(provider="exampleStringProvider")
    public String exampleString = this.exampleStringProvider.get();
    private final transient Supplier<String> exampleString2Provider = () -> "Another string.";
    @SerdeDefault(provider="exampleString2Provider")
    @SerdeKey(value="stringWithCustomKey")
    public String exampleString2 = this.exampleString2Provider.get();
    private final transient Supplier<String> categorizedStringProvider = () -> "Categorized!";
    @SerdeDefault(provider="categorizedStringProvider")
    @ConfigEntry.Category(value="category")
    public String categorizedString = this.categorizedStringProvider.get();
    private final transient Supplier<List<String>> exampleStringListProvider = () -> List.of("one", "two", "three");
    @SerdeDefault(provider="exampleStringListProvider")
    public List<String> exampleStringList = this.exampleStringListProvider.get();
    private final transient Supplier<Map<String, Integer>> exampleStringIntMapProvider = () -> new LinkedHashMap<String, Integer>(Map.of("one", 1, "two", 2, "three", 3));
    @SerdeDefault(provider="exampleStringIntMapProvider")
    public Map<String, Integer> exampleStringIntMap = this.exampleStringIntMapProvider.get();
    private final transient Supplier<InnerConfig> innerConfigSupplier = InnerConfig::new;
    @SerdeComment(value="This is a comment too.")
    @SerdeDefault(provider="innerConfigSupplier")
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="inner")
    public InnerConfig innerConfig = this.innerConfigSupplier.get();

    public static class InnerConfig {
        private final transient Supplier<Integer> innerIntProvider = () -> 42;
        @SerdeDefault(provider="innerIntProvider")
        public int innerInt = this.innerIntProvider.get();
        private final transient Supplier<String> innerStringProvider = () -> "S.T.A.Y";
        @SerdeDefault(provider="innerStringProvider")
        public String innerString = this.innerStringProvider.get();
        private final transient Supplier<ExampleEnum> innerEnumProvider = () -> ExampleEnum.SECOND;
        @SerdeDefault(provider="innerEnumProvider")
        public ExampleEnum innerEnum = this.innerEnumProvider.get();
    }

    public static enum ExampleEnum {
        FIRST,
        SECOND,
        THIRD,
        FOURTH,
        FIFTH,
        SIXTH,
        SEVENTH,
        EIGHTH,
        NINTH,
        TENTH;

    }
}

