/*
 * Decompiled with CFR 0.152.
 */
package band.kessokuteatime.nightautoconfig.util;

import java.util.IdentityHashMap;

public class TypeUtil {
    private static final IdentityHashMap<Class<?>, TypeAndOrder> PRIMITIVE_TO_WRAPPER = new IdentityHashMap();
    private static final IdentityHashMap<Class<?>, TypeAndOrder> WRAPPER_TO_PRIMITIVE = new IdentityHashMap();

    public static boolean isPrimitiveOrWrapper(Class<?> type) {
        return type.isPrimitive() || WRAPPER_TO_PRIMITIVE.get(type) != null;
    }

    public static boolean isPrimitiveOrWrapperNumber(Class<?> type) {
        return TypeUtil.isPrimitiveOrWrapper(type) && type != Boolean.class && type != Boolean.TYPE && type != Character.class && type != Character.TYPE;
    }

    static void addPrimitiveAndWrapper(Class<?> primitiveType, Class<?> wrapperType) {
        PRIMITIVE_TO_WRAPPER.put(primitiveType, new TypeAndOrder(PRIMITIVE_TO_WRAPPER.size(), wrapperType));
        WRAPPER_TO_PRIMITIVE.put(wrapperType, new TypeAndOrder(WRAPPER_TO_PRIMITIVE.size(), primitiveType));
    }

    static {
        TypeUtil.addPrimitiveAndWrapper(Boolean.TYPE, Boolean.class);
        TypeUtil.addPrimitiveAndWrapper(Byte.TYPE, Byte.class);
        TypeUtil.addPrimitiveAndWrapper(Short.TYPE, Short.class);
        TypeUtil.addPrimitiveAndWrapper(Character.TYPE, Character.class);
        TypeUtil.addPrimitiveAndWrapper(Integer.TYPE, Integer.class);
        TypeUtil.addPrimitiveAndWrapper(Long.TYPE, Long.class);
        TypeUtil.addPrimitiveAndWrapper(Float.TYPE, Float.class);
        TypeUtil.addPrimitiveAndWrapper(Double.TYPE, Double.class);
    }

    private static final class TypeAndOrder {
        final int order;
        final Class<?> type;

        TypeAndOrder(int order, Class<?> type) {
            this.order = order;
            this.type = type;
        }

        boolean canAssignValue(TypeAndOrder valueType) {
            if (this.order == 0) {
                return valueType.order == 0;
            }
            if (valueType.order == 0) {
                return false;
            }
            return this.order >= valueType.order;
        }

        public String toString() {
            return "TypeAndOrder [order=" + this.order + ", type=" + String.valueOf(this.type) + "]";
        }
    }
}

