/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.rival.procedures;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mcreator.rival.entity.DayiciUstaEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DayiciUstaOnEntityTickUpdateProcedure {
    private static final Map<UUID, Set<Integer>> triggeredThresholdsMap = new HashMap<UUID, Set<Integer>>();
    private static final int[] HEALTH_THRESHOLDS = new int[]{950, 900, 800, 700, 500, 400, 300, 200, 100};

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        DayiciUstaOnEntityTickUpdateProcedure.execute((Event)event, (Entity)event.getEntity());
    }

    public static void execute(Entity entity) {
        DayiciUstaOnEntityTickUpdateProcedure.execute(null, entity);
    }

    private static void execute(@Nullable Event event, Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity instanceof DayiciUstaEntity && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            DayiciUstaEntity dayiciEntity = (DayiciUstaEntity)entity;
            UUID entityId = entity.m_20148_();
            float health = livingEntity.m_21223_();
            if (!triggeredThresholdsMap.containsKey(entityId)) {
                triggeredThresholdsMap.put(entityId, new HashSet());
            }
            Set<Integer> triggeredThresholds = triggeredThresholdsMap.get(entityId);
            for (int threshold : HEALTH_THRESHOLDS) {
                if (!(health < (float)threshold) || triggeredThresholds.contains(threshold)) continue;
                dayiciEntity.setAnimation("attack2");
                DayiciUstaOnEntityTickUpdateProcedure.summonLightningPattern(entity);
                triggeredThresholds.add(threshold);
                break;
            }
        }
    }

    private static void summonLightningPattern(Entity entity) {
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        Level level = entity.m_9236_();
        float yRot = entity.m_146908_();
        double radians = Math.toRadians(yRot);
        double dirX = -Math.sin(radians);
        double dirZ = Math.cos(radians);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX, y, z + dirZ);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 2.0, y, z + dirZ * 2.0 + dirX);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 2.0, y, z + dirZ * 2.0 - dirX);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 2.0, y, z + dirZ * 2.0);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 3.0, y, z + dirZ * 3.0 + dirX * 2.0);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 3.0, y, z + dirZ * 3.0 + dirX);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 3.0, y, z + dirZ * 3.0);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 3.0, y, z + dirZ * 3.0 - dirX);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 3.0, y, z + dirZ * 3.0 - dirX * 2.0);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 3.0, y, z + dirZ * 3.0 - dirX * 3.0);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 3.0, y, z + dirZ * 3.0 - dirX * 2.0);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 3.0, y, z + dirZ * 3.0 - dirX);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 3.0, y, z + dirZ * 3.0);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 3.0, y, z + dirZ * 3.0 + dirX);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 3.0, y, z + dirZ * 3.0 + dirX * 2.0);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 3.0, y, z + dirZ * 3.0 + dirX * 3.0);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 4.0, y, z + dirZ * 4.0 - dirX * 4.0);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 4.0, y, z + dirZ * 4.0 - dirX * 3.0);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 4.0, y, z + dirZ * 4.0 - dirX * 2.0);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 4.0, y, z + dirZ * 4.0 - dirX);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 4.0, y, z + dirZ * 4.0);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 4.0, y, z + dirZ * 4.0 + dirX * 4.0);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 4.0, y, z + dirZ * 4.0 + dirX * 3.0);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 4.0, y, z + dirZ * 4.0 + dirX * 2.0);
            DayiciUstaOnEntityTickUpdateProcedure.spawnLightningAt(serverLevel, x + dirX * 4.0, y, z + dirZ * 4.0 + dirX);
        }
    }

    private static void spawnLightningAt(ServerLevel serverLevel, double x, double y, double z) {
        LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)serverLevel);
        bolt.m_20219_(Vec3.m_82539_((Vec3i)new BlockPos((int)x, (int)y, (int)z)));
        serverLevel.m_7967_((Entity)bolt);
    }
}

