/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.rival.procedures;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mcreator.rival.entity.DayiciUstaPhase2Entity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DayiciUstaPhase2OnEntityTickUpdateProcedure {
    private static final Map<UUID, Set<Integer>> triggeredThresholdsMap = new HashMap<UUID, Set<Integer>>();
    private static final int[] HEALTH_THRESHOLDS = new int[]{950, 900, 800, 700, 500, 400, 300, 200, 100};

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        DayiciUstaPhase2OnEntityTickUpdateProcedure.execute((Event)event, (Entity)event.getEntity());
    }

    public static void execute(Entity entity) {
        DayiciUstaPhase2OnEntityTickUpdateProcedure.execute(null, entity);
    }

    private static void execute(@Nullable Event event, Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity instanceof DayiciUstaPhase2Entity && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            DayiciUstaPhase2Entity dayiciPhase2Entity = (DayiciUstaPhase2Entity)entity;
            UUID entityId = entity.m_20148_();
            float health = livingEntity.m_21223_();
            if (!triggeredThresholdsMap.containsKey(entityId)) {
                triggeredThresholdsMap.put(entityId, new HashSet());
            }
            Set<Integer> triggeredThresholds = triggeredThresholdsMap.get(entityId);
            for (int threshold : HEALTH_THRESHOLDS) {
                if (!(health < (float)threshold) || triggeredThresholds.contains(threshold)) continue;
                dayiciPhase2Entity.setAnimation("attack2");
                DayiciUstaPhase2OnEntityTickUpdateProcedure.shootFireballsPattern(entity);
                triggeredThresholds.add(threshold);
                break;
            }
        }
    }

    private static void shootFireballsPattern(Entity entity) {
        double x = entity.m_20185_();
        double y = entity.m_20186_() + 1.5;
        double z = entity.m_20189_();
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel && entity instanceof LivingEntity) {
            ServerLevel serverLevel = (ServerLevel)level;
            LivingEntity livingEntity = (LivingEntity)entity;
            Vec3 lookVec = livingEntity.m_20154_();
            double fireballSpeed = 0.1;
            double mainDirX = lookVec.f_82479_ * fireballSpeed;
            double mainDirY = lookVec.f_82480_ * fireballSpeed;
            double mainDirZ = lookVec.f_82481_ * fireballSpeed;
            Vec3 perpVec = lookVec.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
            DayiciUstaPhase2OnEntityTickUpdateProcedure.spawnLargeFireball(serverLevel, livingEntity, x, y, z, mainDirX, mainDirY, mainDirZ);
            DayiciUstaPhase2OnEntityTickUpdateProcedure.spawnLargeFireball(serverLevel, livingEntity, x, y, z, mainDirX + perpVec.f_82479_ * -0.25, mainDirY, mainDirZ + perpVec.f_82481_ * -0.25);
            DayiciUstaPhase2OnEntityTickUpdateProcedure.spawnLargeFireball(serverLevel, livingEntity, x, y, z, mainDirX + perpVec.f_82479_ * 0.25, mainDirY, mainDirZ + perpVec.f_82481_ * 0.25);
            DayiciUstaPhase2OnEntityTickUpdateProcedure.spawnLargeFireball(serverLevel, livingEntity, x, y, z, mainDirX + perpVec.f_82479_ * -0.5, mainDirY, mainDirZ + perpVec.f_82481_ * -0.5);
            DayiciUstaPhase2OnEntityTickUpdateProcedure.spawnLargeFireball(serverLevel, livingEntity, x, y, z, mainDirX + perpVec.f_82479_ * 0.5, mainDirY, mainDirZ + perpVec.f_82481_ * 0.5);
            DayiciUstaPhase2OnEntityTickUpdateProcedure.spawnLargeFireball(serverLevel, livingEntity, x, y, z, mainDirX + perpVec.f_82479_ * -0.75, mainDirY, mainDirZ + perpVec.f_82481_ * -0.75);
            DayiciUstaPhase2OnEntityTickUpdateProcedure.spawnLargeFireball(serverLevel, livingEntity, x, y, z, mainDirX + perpVec.f_82479_ * 0.75, mainDirY, mainDirZ + perpVec.f_82481_ * 0.75);
        }
    }

    private static void spawnLargeFireball(ServerLevel level, LivingEntity shooter, double x, double y, double z, double xVel, double yVel, double zVel) {
        SmallFireball fireball = (SmallFireball)EntityType.f_20527_.m_20615_((Level)level);
        if (fireball != null) {
            fireball.m_6034_(x, y, z);
            fireball.m_5602_((Entity)shooter);
            fireball.f_36813_ = xVel;
            fireball.f_36814_ = yVel;
            fireball.f_36815_ = zVel;
            level.m_7967_((Entity)fireball);
        }
    }
}

