/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.luminousworld.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.luminousworld.client.model.Modeldeer;
import net.mcreator.luminousworld.entity.DeerEntity;
import net.mcreator.luminousworld.procedures.DeerIsBabyConditionProcedure;
import net.mcreator.luminousworld.procedures.ZebraModelVisualScaleProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class DeerRenderer
extends MobRenderer<DeerEntity, Modeldeer<DeerEntity>> {
    public DeerRenderer(EntityRendererProvider.Context context) {
        super(context, new Modeldeer(context.bakeLayer(Modeldeer.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<DeerEntity, Modeldeer<DeerEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"luminousworld:textures/entities/deer.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, DeerEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (DeerIsBabyConditionProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    Modeldeer model = new Modeldeer(Minecraft.getInstance().getEntityModels().bakeLayer(Modeldeer.LAYER_LOCATION));
                    ((Modeldeer)this.getParentModel()).copyPropertiesTo(model);
                    model.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, partialTicks);
                    model.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                    model.renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(DeerEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)ZebraModelVisualScaleProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
    }

    public ResourceLocation getTextureLocation(DeerEntity entity) {
        return ResourceLocation.parse((String)"luminousworld:textures/entities/fawn.png");
    }
}

