/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.luminousworld.entity;

import javax.annotation.Nullable;
import net.mcreator.luminousworld.init.LuminousworldModEntities;
import net.mcreator.luminousworld.procedures.CrabLookProcedure;
import net.mcreator.luminousworld.procedures.GoldenHermitDiesProcedure;
import net.mcreator.luminousworld.procedures.GoldenHermitHurtProcedure;
import net.mcreator.luminousworld.procedures.GoldenHermitTickProcedure;
import net.mcreator.luminousworld.procedures.GoldenKingHermitNaturalEntitySpawningConditionProcedure;
import net.mcreator.luminousworld.procedures.RareCrabLookProcedure;
import net.mcreator.luminousworld.procedures.StepFixProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GoldenKingHermitEntity
extends Monster
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(GoldenKingHermitEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(GoldenKingHermitEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(GoldenKingHermitEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> DATA_JustAttacked = SynchedEntityData.defineId(GoldenKingHermitEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_HalfHealth = SynchedEntityData.defineId(GoldenKingHermitEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_counter = SynchedEntityData.defineId(GoldenKingHermitEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_stop = SynchedEntityData.defineId(GoldenKingHermitEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_IsHiding = SynchedEntityData.defineId(GoldenKingHermitEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public GoldenKingHermitEntity(EntityType<GoldenKingHermitEntity> type, Level world) {
        super(type, world);
        this.xpReward = 50;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT, (Object)false);
        builder.define(ANIMATION, (Object)"undefined");
        builder.define(TEXTURE, (Object)"goldenhermit");
        builder.define(DATA_JustAttacked, (Object)false);
        builder.define(DATA_HalfHealth, (Object)false);
        builder.define(DATA_counter, (Object)0);
        builder.define(DATA_stop, (Object)false);
        builder.define(DATA_IsHiding, (Object)false);
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false){

            public boolean canUse() {
                double x = GoldenKingHermitEntity.this.getX();
                double y = GoldenKingHermitEntity.this.getY();
                double z = GoldenKingHermitEntity.this.getZ();
                GoldenKingHermitEntity entity = GoldenKingHermitEntity.this;
                Level world = GoldenKingHermitEntity.this.level();
                return super.canUse() && RareCrabLookProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = GoldenKingHermitEntity.this.getX();
                double y = GoldenKingHermitEntity.this.getY();
                double z = GoldenKingHermitEntity.this.getZ();
                GoldenKingHermitEntity entity = GoldenKingHermitEntity.this;
                Level world = GoldenKingHermitEntity.this.level();
                return super.canContinueToUse() && RareCrabLookProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 2.25 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = GoldenKingHermitEntity.this.getX();
                double y = GoldenKingHermitEntity.this.getY();
                double z = GoldenKingHermitEntity.this.getZ();
                GoldenKingHermitEntity entity = GoldenKingHermitEntity.this;
                Level world = GoldenKingHermitEntity.this.level();
                return super.canUse() && RareCrabLookProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = GoldenKingHermitEntity.this.getX();
                double y = GoldenKingHermitEntity.this.getY();
                double z = GoldenKingHermitEntity.this.getZ();
                GoldenKingHermitEntity entity = GoldenKingHermitEntity.this;
                Level world = GoldenKingHermitEntity.this.level();
                return super.canContinueToUse() && RareCrabLookProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean canUse() {
                double x = GoldenKingHermitEntity.this.getX();
                double y = GoldenKingHermitEntity.this.getY();
                double z = GoldenKingHermitEntity.this.getZ();
                GoldenKingHermitEntity entity = GoldenKingHermitEntity.this;
                Level world = GoldenKingHermitEntity.this.level();
                return super.canUse() && CrabLookProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = GoldenKingHermitEntity.this.getX();
                double y = GoldenKingHermitEntity.this.getY();
                double z = GoldenKingHermitEntity.this.getZ();
                GoldenKingHermitEntity entity = GoldenKingHermitEntity.this;
                Level world = GoldenKingHermitEntity.this.level();
                return super.canContinueToUse() && CrabLookProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = GoldenKingHermitEntity.this.getX();
                double y = GoldenKingHermitEntity.this.getY();
                double z = GoldenKingHermitEntity.this.getZ();
                GoldenKingHermitEntity entity = GoldenKingHermitEntity.this;
                Level world = GoldenKingHermitEntity.this.level();
                return super.canUse() && RareCrabLookProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = GoldenKingHermitEntity.this.getX();
                double y = GoldenKingHermitEntity.this.getY();
                double z = GoldenKingHermitEntity.this.getZ();
                GoldenKingHermitEntity entity = GoldenKingHermitEntity.this;
                Level world = GoldenKingHermitEntity.this.level();
                return super.canContinueToUse() && RareCrabLookProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new FloatGoal((Mob)this));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.sand.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public boolean hurt(DamageSource source, float amount) {
        GoldenHermitHurtProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        Entity immediatesourceentity = source.getDirectEntity();
        return super.hurt(source, amount);
    }

    public void die(DamageSource source) {
        super.die(source);
        GoldenHermitDiesProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this, source.getEntity());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        StepFixProcedure.execute((Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
        compound.putBoolean("DataJustAttacked", ((Boolean)this.entityData.get(DATA_JustAttacked)).booleanValue());
        compound.putBoolean("DataHalfHealth", ((Boolean)this.entityData.get(DATA_HalfHealth)).booleanValue());
        compound.putInt("Datacounter", ((Integer)this.entityData.get(DATA_counter)).intValue());
        compound.putBoolean("Datastop", ((Boolean)this.entityData.get(DATA_stop)).booleanValue());
        compound.putBoolean("DataIsHiding", ((Boolean)this.entityData.get(DATA_IsHiding)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
        if (compound.contains("DataJustAttacked")) {
            this.entityData.set(DATA_JustAttacked, (Object)compound.getBoolean("DataJustAttacked"));
        }
        if (compound.contains("DataHalfHealth")) {
            this.entityData.set(DATA_HalfHealth, (Object)compound.getBoolean("DataHalfHealth"));
        }
        if (compound.contains("Datacounter")) {
            this.entityData.set(DATA_counter, (Object)compound.getInt("Datacounter"));
        }
        if (compound.contains("Datastop")) {
            this.entityData.set(DATA_stop, (Object)compound.getBoolean("Datastop"));
        }
        if (compound.contains("DataIsHiding")) {
            this.entityData.set(DATA_IsHiding, (Object)compound.getBoolean("DataIsHiding"));
        }
    }

    public void baseTick() {
        super.baseTick();
        GoldenHermitTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.0f);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)LuminousworldModEntities.GOLDEN_KING_HERMIT.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return GoldenKingHermitNaturalEntitySpawningConditionProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.27);
        builder = builder.add(Attributes.MAX_HEALTH, 210.0);
        builder = builder.add(Attributes.ARMOR, 15.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 15.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 2.5);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (event.isMoving() || !(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("walk"));
            }
            if (this.isDeadOrDying()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("death"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 35) {
            this.remove(Entity.RemovalReason.KILLED);
            this.dropExperience((Entity)this);
        }
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

