/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.admin;

import io.github.sluggly.timemercenaries.TimeMercenaryAdvancements;
import io.github.sluggly.timemercenaries.capability.PlayerCapability;
import io.github.sluggly.timemercenaries.data.DataTester;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.lore.Lore;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.mercenary.MercenaryPlayerData;
import io.github.sluggly.timemercenaries.mercenary.Quest;
import io.github.sluggly.timemercenaries.mercenary.Trait;
import io.github.sluggly.timemercenaries.missions.Mission;
import io.github.sluggly.timemercenaries.module.Module;
import io.github.sluggly.timemercenaries.network.PacketHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class Admin {
    public static boolean ADMIN_SERVER_CONSOLE_LOG = false;
    public static boolean ADMIN_RESET_ON_LOGIN = false;
    public static boolean CLIENT_IS_ADMIN_MODE_ACTIVATED = false;
    public static boolean CLIENT_ADMIN_NO_ITEM_REQUIRED = false;
    public static boolean CLIENT_ADMIN_MISSION_INSTANT = false;
    public static HashMap<ServerPlayer, Admin_Config> administratorsMap = new HashMap();

    public static boolean isPlayerAdministrator(ServerPlayer player) {
        return administratorsMap.containsKey(player);
    }

    public static boolean hasPlayerNoRequiredItem(ServerPlayer player) {
        if (!Admin.isPlayerAdministrator(player)) {
            return false;
        }
        return Admin.administratorsMap.get((Object)player).ADMIN_NO_ITEM_REQUIRED;
    }

    public static boolean arePlayerMissionsInstant(ServerPlayer player) {
        if (!Admin.isPlayerAdministrator(player)) {
            return false;
        }
        return Admin.administratorsMap.get((Object)player).ADMIN_MISSION_INSTANT;
    }

    public static void toggleServerConsoleLog(ServerPlayer player) {
        ADMIN_SERVER_CONSOLE_LOG = !ADMIN_SERVER_CONSOLE_LOG;
        PlayerData playerData = PlayerData.getPlayerData((Player)player);
        if (ADMIN_SERVER_CONSOLE_LOG) {
            PacketHandler.sendToPlayer("AdminLog", playerData, player);
        } else {
            PacketHandler.sendToPlayer("AdminLogNo", playerData, player);
        }
        PacketHandler.sendToPlayer("RefreshData", playerData, player);
    }

    public static void playerRequestError(Player player, String errorMessage) {
        if (ADMIN_SERVER_CONSOLE_LOG) {
            String callingMethodName = Thread.currentThread().getStackTrace()[2].getMethodName();
            System.out.println("Error from the player " + player.m_6302_() + " : " + errorMessage + " (called from " + callingMethodName + ")");
        }
    }

    public static void adminResetPlayerData(ServerPlayer player) {
        if (Admin.isPlayerAdministrator(player)) {
            player.getCapability(PlayerCapability.PLAYER_DATA).ifPresent(cap -> {
                PlayerData freshData = new PlayerData((Player)player, null);
                cap.getPlayerData().playerDataTag = freshData.playerDataTag;
                if (ADMIN_SERVER_CONSOLE_LOG) {
                    System.out.println(player.m_6302_() + " Data Reset.");
                }
                PacketHandler.sendToPlayer("CloseScreen", cap.getPlayerData().playerDataTag, player);
            });
        }
    }

    public static void adminLevelUp(ServerPlayer player, String mercenaryName) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            int currentLevel = MercenaryPlayerData.getMercenaryLevel(playerData, mercenaryName);
            int currentExpNextLevel = Mercenary.getRequiredExpLevel(currentLevel + 1);
            MercenaryPlayerData.setMercenaryExp(playerData, mercenaryName, currentExpNextLevel);
            PacketHandler.sendToPlayer("RefreshData", playerData, player);
            TimeMercenaryAdvancements.checkAndTestGrantAdvancement(player, "Level Up");
        }
    }

    public static void adminKill(ServerPlayer player, String mercenaryName) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            int currentHealth = MercenaryPlayerData.getMercenaryCurrentHealth(playerData, mercenaryName);
            MercenaryPlayerData.damageMercenary(playerData, mercenaryName, currentHealth);
            PacketHandler.sendToPlayer("RefreshData", playerData, player);
        }
    }

    public static void adminResurrect(ServerPlayer player, String mercenaryName) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            MercenaryPlayerData.healMercenaryFull(playerData, mercenaryName);
            PacketHandler.sendToPlayer("RefreshData", playerData, player);
        }
    }

    public static void adminDamage(ServerPlayer player, String mercenaryName) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            MercenaryPlayerData.damageMercenary(playerData, mercenaryName, 1);
            PacketHandler.sendToPlayer("RefreshData", playerData, player);
        }
    }

    public static void adminHeal(ServerPlayer player, String mercenaryName) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            MercenaryPlayerData.healMercenary(playerData, mercenaryName, 1);
            PacketHandler.sendToPlayer("RefreshData", playerData, player);
        }
    }

    public static void adminNext(ServerPlayer player, String index) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            int num = Integer.parseInt(index);
            String mercenaryName = MercenaryPlayerData.getRecruitsAvailable(playerData)[num];
            int indexInArray = 0;
            for (String tmpMercenaryName : Mercenary.getMercenariesName()) {
                if (tmpMercenaryName.equals(mercenaryName)) break;
                ++indexInArray;
            }
            String nextMercenaryName = Mercenary.getMercenariesName().get((indexInArray + 1) % Mercenary.getMercenariesName().size());
            MercenaryPlayerData.setRecruitMercenary(playerData, nextMercenaryName, num);
            PacketHandler.sendToPlayer("RefreshData", playerData, player);
        }
    }

    public static void adminItems(ServerPlayer player) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            boolean bl = Admin.administratorsMap.get((Object)player).ADMIN_NO_ITEM_REQUIRED = !Admin.administratorsMap.get((Object)player).ADMIN_NO_ITEM_REQUIRED;
            if (Admin.administratorsMap.get((Object)player).ADMIN_NO_ITEM_REQUIRED) {
                PacketHandler.sendToPlayer("AdminItems", playerData, player);
            } else {
                PacketHandler.sendToPlayer("AdminItemsNo", playerData, player);
            }
            PacketHandler.sendToPlayer("RefreshData", playerData, player);
        }
    }

    public static void adminInstant(ServerPlayer player) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            boolean bl = Admin.administratorsMap.get((Object)player).ADMIN_MISSION_INSTANT = !Admin.administratorsMap.get((Object)player).ADMIN_MISSION_INSTANT;
            if (Admin.administratorsMap.get((Object)player).ADMIN_MISSION_INSTANT) {
                playerData.missionTimeLeft.replaceAll((n, v) -> 5);
                PacketHandler.sendToPlayer("AdminInstant", playerData, player);
            } else {
                PacketHandler.sendToPlayer("AdminInstantNo", playerData, player);
            }
            PacketHandler.sendToPlayer("RefreshData", playerData, player);
        }
    }

    public static void adminResetAdvancements(ServerPlayer player) {
        if (Admin.isPlayerAdministrator(player)) {
            TimeMercenaryAdvancements.resetAllAdvancements(player);
        }
    }

    public static void adminResetModules(ServerPlayer player) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            for (String key : Module.getModulesTag(playerData).m_128431_()) {
                Module.setModule(playerData, key, false);
            }
            PacketHandler.sendToPlayer("RefreshData", playerData, player);
        }
    }

    public static void adminRerollRecruits(ServerPlayer player) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            MercenaryPlayerData.generateRecruitsForPlayer(playerData);
            PacketHandler.sendToPlayer("RefreshData", playerData, player);
        }
    }

    public static void adminRerollMission(ServerPlayer player, String mercenaryName, String index) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            int num = Integer.parseInt(index);
            List<ResourceLocation> missions = MercenaryPlayerData.getMercenaryMissionsAvailable(playerData, mercenaryName);
            ResourceLocation missionId = missions.get(num);
            if (MercenaryPlayerData.isMercenaryMissionAvailable(playerData, mercenaryName, missionId)) {
                MercenaryPlayerData.rerollMercenaryMission(playerData, mercenaryName, missionId);
                MercenaryPlayerData.resetMercenaryMissionReroll(playerData, mercenaryName);
                PacketHandler.sendToPlayer("RefreshData", playerData, player);
            }
        }
    }

    public static void adminUnlockAllMercenaryTraits(ServerPlayer player, String mercenaryName) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            for (Map.Entry<String, Trait> entry : Trait.getTraitsMap()) {
                int level = entry.getValue().maxLevel <= 0 ? 100 : entry.getValue().maxLevel;
                MercenaryPlayerData.setMercenaryTraitLevel(playerData, mercenaryName, entry.getKey(), level);
            }
            PacketHandler.sendToPlayer("RefreshData", playerData, player);
        }
    }

    public static void adminSuccessMission(ServerPlayer player, String mercenaryName) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            MercenaryPlayerData.setMercenaryMissionStatus(playerData, mercenaryName, "Success");
            playerData.setState("EndMission");
            PacketHandler.sendToPlayer("OpenEndMissionScreen", playerData, player);
        }
    }

    public static void adminFailMission(ServerPlayer player, String mercenaryName) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            ResourceLocation missionId = MercenaryPlayerData.getMercenaryChosenMission(playerData, mercenaryName);
            Mission mission = Mission.getMissionFromId(missionId);
            assert (mission != null);
            int failDamage = mission.failDamage;
            MercenaryPlayerData.damageMercenary(playerData, mercenaryName, failDamage);
            if (MercenaryPlayerData.isMercenaryDead(playerData, mercenaryName)) {
                MercenaryPlayerData.setMercenaryMissionStatus(playerData, mercenaryName, "Death");
            } else {
                MercenaryPlayerData.setMercenaryMissionStatus(playerData, mercenaryName, "Failed");
            }
            playerData.setState("EndMission");
            PacketHandler.sendToPlayer("OpenEndMissionScreen", playerData, player);
        }
    }

    public static void adminRunTests() {
        DataTester.runTests();
    }

    public static void adminResetCoins(ServerPlayer player) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            MercenaryPlayerData.setMercenaryCoins(playerData, "Vael", 0);
            PacketHandler.sendToPlayer("RefreshData", playerData, player);
        }
    }

    public static void adminAddCoins(ServerPlayer player) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            MercenaryPlayerData.addMercenaryCoins(playerData, "Vael", 50);
            PacketHandler.sendToPlayer("RefreshData", playerData, player);
        }
    }

    public static void rerollShop(ServerPlayer player, String mercenaryName) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            MercenaryPlayerData.rerollMercenaryShop(playerData, mercenaryName);
            PacketHandler.sendToPlayer("RefreshData", playerData, player);
        }
    }

    public static void rerollQuest(ServerPlayer player, String mercenaryName, int index) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            MercenaryPlayerData.rerollMercenaryQuest(playerData, mercenaryName, index);
            PacketHandler.sendToPlayer("RefreshData", playerData, player);
        }
    }

    public static void progressQuest(ServerPlayer player, String mercenaryName) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            CompoundTag chosenQuest = MercenaryPlayerData.getMercenaryChosenQuestTag(playerData, mercenaryName);
            chosenQuest.m_128405_("RequirementProgress", chosenQuest.m_128451_("RequirementProgress") + 1);
            Quest.checkIfQuestIsDone(playerData);
            PacketHandler.sendToPlayer("RefreshData", playerData, player);
        }
    }

    public static void skipTutorial(ServerPlayer player) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            Lore.setPlayerLoreProgress(playerData, 1.0f);
            if (ADMIN_SERVER_CONSOLE_LOG) {
                System.out.println(player.m_6302_() + " Skipped Tutorial.");
            }
            PacketHandler.sendToPlayer("OpenRecruitScreen", playerData, player);
        }
    }

    public static void nextLoreStep(ServerPlayer player) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            Lore.setPlayerNextLoreProgress(playerData);
            float currentProgress = Lore.getPlayerLoreProgress(playerData);
            if (ADMIN_SERVER_CONSOLE_LOG) {
                System.out.println(player.m_6302_() + " advanced to next lore step: " + currentProgress);
            }
            if (currentProgress >= 1.0f) {
                PacketHandler.sendToPlayer("OpenRecruitScreen", playerData, player);
            } else {
                PacketHandler.sendToPlayer("OpenTutorialScreen", playerData, player);
            }
        }
    }

    public static void changeLoreCount(ServerPlayer player, int increment) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            int totalCount = Lore.getPlayerLoreCount(playerData) + increment;
            Lore.setPlayerLoreCount(playerData, totalCount);
            if (ADMIN_SERVER_CONSOLE_LOG) {
                System.out.println(player.m_6302_() + " changed Lore count: " + totalCount);
            }
            PacketHandler.sendToPlayer("RefreshData", playerData, player);
        }
    }

    public static void feedMercenary(ServerPlayer player, String mercenaryName, int increment) {
        if (Admin.isPlayerAdministrator(player)) {
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            int currentHunger = MercenaryPlayerData.getMercenaryCurrentHunger(playerData, mercenaryName);
            MercenaryPlayerData.setMercenaryHunger(playerData, mercenaryName, currentHunger + increment);
            if (ADMIN_SERVER_CONSOLE_LOG) {
                System.out.println(player.m_6302_() + " fed mercenary: " + mercenaryName);
            }
            PacketHandler.sendToPlayer("RefreshData", playerData, player);
        }
    }

    public static void togglePlayerAdministrator(ServerPlayer player) {
        if (administratorsMap.containsKey(player)) {
            administratorsMap.remove(player);
        } else {
            administratorsMap.put(player, new Admin_Config());
        }
        PlayerData playerData = PlayerData.getPlayerData((Player)player);
        if (administratorsMap.containsKey(player)) {
            PacketHandler.sendToPlayer("Admin", playerData, player);
        } else {
            PacketHandler.sendToPlayer("AdminNo", playerData, player);
        }
        if (ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Toggled admin for player: " + player.m_6302_());
        }
        PacketHandler.sendToPlayer("RefreshData", playerData, player);
    }

    public static class Admin_Config {
        public boolean ADMIN_MISSION_INSTANT = false;
        public boolean ADMIN_NO_ITEM_REQUIRED = false;
    }
}

