/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.capability;

import io.github.sluggly.timemercenaries.entity.goal.PetGoal;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PetCompanionCapability {
    public static final ResourceLocation KEY = new ResourceLocation("timemercenaries", "pet_companion");
    public static final Capability<IPetCompanion> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPetCompanion>(){});

    public static Optional<IPetCompanion> get(Entity e) {
        return e.getCapability(CAPABILITY).resolve();
    }

    @SubscribeEvent
    public static void attachToEntities(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof Mob) {
            e.addCapability(KEY, (ICapabilityProvider)new Provider());
        }
    }

    @SubscribeEvent
    public static void onJoin(EntityJoinLevelEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        PetCompanionCapability.get((Entity)mob).ifPresent(p -> {
            if (p.isPet()) {
                PetGoal.attachPetGoals(mob);
                mob.m_21530_();
            }
        });
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        private final PetCompanion backend = new PetCompanion();
        private final LazyOptional<IPetCompanion> opt = LazyOptional.of(() -> this.backend);

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return cap == CAPABILITY ? this.opt.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.backend.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.backend.deserializeNBT(nbt);
        }
    }

    public static interface IPetCompanion
    extends INBTSerializable<CompoundTag> {
        public boolean isPet();

        public void setPet(boolean var1);

        @Nullable
        public UUID getOwner();

        public void setOwner(@Nullable UUID var1);

        public boolean isSitting();

        public void setSitting(boolean var1);
    }

    public static class PetCompanion
    implements IPetCompanion {
        private boolean pet;
        private boolean sitting;
        @Nullable
        private UUID owner;

        @Override
        public boolean isPet() {
            return this.pet;
        }

        @Override
        public void setPet(boolean v) {
            this.pet = v;
        }

        @Override
        @Nullable
        public UUID getOwner() {
            return this.owner;
        }

        @Override
        public void setOwner(@Nullable UUID id) {
            this.owner = id;
        }

        @Override
        public boolean isSitting() {
            return this.sitting;
        }

        @Override
        public void setSitting(boolean v) {
            this.sitting = v;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("pet", this.pet);
            tag.m_128379_("sit", this.sitting);
            if (this.owner != null) {
                tag.m_128362_("owner", this.owner);
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            this.pet = tag.m_128471_("pet");
            this.sitting = tag.m_128471_("sit");
            this.owner = tag.m_128441_("owner") ? tag.m_128342_("owner") : null;
        }
    }
}

