/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.data;

import io.github.sluggly.timemercenaries.client.data.MercenaryData;
import io.github.sluggly.timemercenaries.client.data.ModuleData;
import io.github.sluggly.timemercenaries.client.handler.ButtonHandler;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.mercenary.MercenaryPlayerData;
import io.github.sluggly.timemercenaries.missions.Mission;
import io.github.sluggly.timemercenaries.missions.MissionItem;
import io.github.sluggly.timemercenaries.module.Module;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class MissionData {
    public final String rarity;
    public final String description;
    public final String successDescription;
    public final ResourceLocation id;
    public final ResourceLocation backgroundTexture;
    public final int seed;
    public final int time;
    public final int timeColor;
    public final int experience;
    public final int failChance;
    public final int failColor;
    public final int failDamage;
    public final int deathColor;
    public final int experienceColor;
    public final int hungerCost;
    public final int hungerColor;
    public boolean canMissionStart;
    public final boolean isMissionRandom;
    public final MissionItem[] requiredItems;
    public final MissionItem[] rewardItems;
    public final MissionItem[] failItems;
    public MissionItem[] glitchItems;
    public int[] requiredItemsNumber;
    public int[] rewardItemsNumber;
    public int[] finalRewardItemsNumber;
    public int[] failItemsNumber;
    public int[] glitchItemsNumber;
    public final int mercenaryMultiplier;
    public final int difficultyMultiplier;
    public final int totalMultiplier;
    public final boolean didDimensionalGlitchModuleProc;
    public final boolean didProcurerTraitProc;
    public final String rewardButtonTooltip;
    public final String finalRewardButtonTooltip;
    public final String timeString;
    public final String failString;
    public final String failDamageString;
    public final String experienceString;
    public final String hungerString;
    public String glitchItemsTooltip;
    public final int color;
    public final MissionButton buttonSendMission;
    public MissionButton buttonRerollMission;
    public MissionButton buttonSameRerollMission;
    public MissionButton buttonDifficultyMission;
    public boolean shouldRenderSendButton;
    public boolean canMissionReroll;
    public boolean canMissionSameReroll;
    public final Font font;
    public final StringWidget nameWidget;
    public final StringWidget rewardItemTooltips;
    public final MissionItem sameRerollItem;
    public final String missionStatus;
    public boolean shouldRenderRerollButton;
    public boolean shouldRenderSameRerollButton;
    public boolean shouldRenderDifficultyButton;
    public boolean shouldRenderTotalCoins;
    public final boolean shouldRenderInitialCoin;
    public ItemStack difficultyMissionTexture;
    public final String difficulty;
    public final int difficultyIndex;
    public final int initialCoins;
    public final int totalCoins;

    public MissionData(Mission mission, PlayerData playerData, MercenaryData mercenaryData, ModuleData moduleData) {
        int i;
        this.id = mission.id;
        this.seed = MercenaryPlayerData.getMercenaryMissionSeed(playerData, mercenaryData.name, mission.id);
        this.rarity = mission.rarity;
        this.description = mission.description;
        this.successDescription = Mission.getMissionSuccessDescription();
        this.missionStatus = MercenaryPlayerData.getMercenaryMissionStatus(playerData, mercenaryData.name);
        this.backgroundTexture = mission.backgroundTexture;
        this.font = Minecraft.m_91087_().f_91062_;
        this.color = Mission.mapRarityToColor.get(this.rarity);
        this.requiredItems = mission.getRequiredItems(this.seed);
        this.rewardItems = mission.getSuccessItems(this.seed);
        this.failItems = mission.getFailedItems();
        this.mercenaryMultiplier = MercenaryPlayerData.getMercenaryLootMultiplier(playerData, mercenaryData.name);
        this.difficulty = MercenaryPlayerData.getMercenaryMissionDifficulty(playerData, mercenaryData.name, this.id);
        this.difficultyIndex = MercenaryPlayerData.getMercenaryMissionDifficultyIndex(playerData, mercenaryData.name, this.id);
        this.difficultyMultiplier = MercenaryPlayerData.getMercenaryMissionDifficultyMultiplier(playerData, mercenaryData.name, this.id);
        this.totalMultiplier = MercenaryPlayerData.getMercenaryMissionTotalMultiplier(playerData, mercenaryData.name, this.id);
        this.shouldRenderSendButton = true;
        this.shouldRenderDifficultyButton = false;
        this.shouldRenderTotalCoins = false;
        this.shouldRenderInitialCoin = moduleData.hasModule("Coin Module");
        this.initialCoins = MercenaryPlayerData.getMercenaryMissionCoins(playerData, mercenaryData.name, this.id);
        this.totalCoins = MercenaryPlayerData.getMercenaryMissionTotalCoins(playerData, mercenaryData.name, this.id);
        this.buttonSendMission = new MissionButton(this, 79, 20, ButtonHandler.Empty, ButtonHandler::handleSendButton, null);
        this.time = MercenaryPlayerData.getMercenaryMissionUpdatedTime(playerData, mercenaryData.name, Mission.getMissionTime(this.rarity, this.seed), this.difficultyIndex);
        this.timeString = Mission.getMissionLengthString(this.time);
        this.timeColor = Mission.getMissionDurationColor(this.time);
        this.experience = MercenaryPlayerData.getMercenaryMissionUpdatedExperience(playerData, mercenaryData.name, Mission.getMissionExperience(this.rarity, this.seed), this.difficultyIndex);
        this.experienceString = Mission.getExperienceString(this.experience);
        this.experienceColor = Mission.getExperienceColor(this.experience);
        this.failChance = MercenaryPlayerData.getMercenaryMissionUpdatedFailChance(playerData, mercenaryData.name, mission.failChance, this.difficultyIndex);
        this.failString = Mission.getFailChanceString(this.failChance);
        this.failColor = Mission.mapFailChanceColor.get(this.failString);
        this.failDamage = MercenaryPlayerData.getMercenaryMissionUpdatedDamages(mission.failDamage, this.difficultyIndex);
        this.failDamageString = Mission.getFailDamageString(this.failDamage);
        this.deathColor = Mission.mapDeathChanceColor.get(this.failDamageString);
        this.hungerCost = Mission.getMissionHungerCost(this.rarity, this.seed);
        this.hungerString = Mission.getHungerCostString(this.hungerCost);
        this.hungerColor = Mission.getHungerCostColor(this.hungerCost);
        this.didProcurerTraitProc = MercenaryPlayerData.doesMercenaryProcurerTraitProc(playerData, mercenaryData.name, this.id);
        if (this.didProcurerTraitProc) {
            this.canMissionStart = true;
            this.buttonSendMission.m_93666_((Component)Component.m_237113_((String)"Free !").m_130948_(Style.f_131099_.m_178520_(0x55FF55)));
            this.buttonSendMission.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"This mission is free thanks to the Procurer trait!")));
        } else {
            this.canMissionStart = Mission.checkIfPlayerHasResourcesToStartMission(this.id, playerData.player, false);
            if (this.canMissionStart) {
                this.buttonSendMission.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)mission.getRequiredItemsString(this.seed))));
            } else if (playerData.getCurrentState().equals("SendingMission")) {
                Object finalSendTooltip = Component.m_237113_((String)mission.getRequiredItemsString(this.seed));
                MutableComponent missingItems = Component.m_237113_((String)mission.getMissingMissionItemsString(this.seed, playerData.player)).m_130940_(ChatFormatting.RED);
                finalSendTooltip.m_7220_((Component)missingItems);
                this.buttonSendMission.m_257544_(Tooltip.m_257550_((Component)finalSendTooltip));
            } else {
                this.buttonSendMission.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)mission.getRequiredItemsString(this.seed))));
            }
        }
        this.isMissionRandom = Mission.isMissionRandom(this.id);
        this.rewardButtonTooltip = mission.getSuccessItemsString(this.seed, this.difficultyMultiplier, !moduleData.hasModule("Divination Module"));
        this.finalRewardButtonTooltip = MercenaryPlayerData.getMercenaryMissionStatus(playerData, mercenaryData.name).equals("Success") ? mission.getSuccessItemsString(this.seed, this.totalMultiplier, false) : mission.getFailItemsString(this.totalMultiplier);
        this.nameWidget = new StringWidget(0, 0, 60, 10, (Component)Component.m_237113_((String)this.rarity).m_130948_(Style.f_131099_.m_178520_(this.color)), this.font);
        this.nameWidget.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)this.description)));
        this.nameWidget.m_267729_();
        this.rewardItemTooltips = new StringWidget(0, 0, 20 * this.rewardItems.length, 20, (Component)Component.m_237119_(), this.font);
        this.rewardItemTooltips.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)mission.getSuccessItemsString(this.seed, this.difficultyMultiplier, !moduleData.hasModule("Divination Module")))));
        this.shouldRenderRerollButton = false;
        this.shouldRenderSameRerollButton = false;
        if (moduleData.hasModule("Dice Module")) {
            this.buttonRerollMission = new MissionButton(this, 20, 20, ButtonHandler.Empty, ButtonHandler::handleRerollMissionButton, "Reroll mission\n" + mercenaryData.rerollsLeft + " rerolls left.\nMission rerolls are free and refreshed after recruiting.");
            boolean bl = this.canMissionReroll = mercenaryData.rerollsLeft > 0;
        }
        if (moduleData.hasModule("D-Infinite Module")) {
            this.buttonSameRerollMission = new MissionButton(this, 20, 20, ButtonHandler.Empty, ButtonHandler::handleSameRerollMissionButton, "Reroll mission same rarity\n" + mercenaryData.rerollsLeft + " rerolls left.\nCost :\n - " + Mission.getSameRerollItemTooltip(this.rarity));
            this.canMissionSameReroll = Mission.checkIfPlayerCanRerollMission(playerData.player, this.id, false) && mercenaryData.rerollsLeft > 0;
        }
        this.sameRerollItem = new MissionItem(1, Mission.getRerollItem(this.rarity));
        if (MercenaryPlayerData.getMercenaryMissionStatus(playerData, mercenaryData.name).equals("Success")) {
            this.didDimensionalGlitchModuleProc = Module.doesDimensionalGlitchModuleProc(playerData, mercenaryData.name);
            if (this.didDimensionalGlitchModuleProc) {
                this.glitchItems = Mercenary.getMercenary(mercenaryData.name).getDimensionalGlitchSuccessItems(MercenaryPlayerData.getMercenarySeed(playerData, mercenaryData.name), this.rarity);
                this.glitchItemsTooltip = Mission.getItemTooltips(this.totalMultiplier, null, false, false, this.glitchItems);
            }
        } else {
            this.didDimensionalGlitchModuleProc = false;
        }
        if (moduleData.hasModule("Heroic Difficulty Module")) {
            this.shouldRenderDifficultyButton = true;
            this.buttonDifficultyMission = new MissionButton(this, 20, 20, ButtonHandler.Empty, ButtonHandler::handleChangeMissionDifficultyButton, MercenaryPlayerData.getMercenaryMissionDifficulty(playerData, mercenaryData.name, this.id));
            this.buttonDifficultyMission.f_93623_ = playerData.getCurrentState().equals("SendingMission");
            switch (this.difficulty) {
                case "Normal": {
                    this.difficultyMissionTexture = Items.f_42681_.m_7968_();
                    break;
                }
                case "Heroic": {
                    this.difficultyMissionTexture = Items.f_260451_.m_7968_();
                    break;
                }
                case "Mythic": {
                    this.difficultyMissionTexture = Items.f_42683_.m_7968_();
                }
            }
        }
        if (this.requiredItems != null) {
            this.requiredItemsNumber = new int[this.requiredItems.length];
            for (int i2 = 0; i2 < this.requiredItems.length; ++i2) {
                this.requiredItemsNumber[i2] = this.requiredItems[i2].number;
            }
        }
        if (this.failItems != null) {
            this.failItemsNumber = new int[this.failItems.length];
            for (int i3 = 0; i3 < this.failItems.length; ++i3) {
                this.failItemsNumber[i3] = this.failItems[i3].number * this.totalMultiplier;
            }
        }
        if (this.glitchItems != null) {
            this.glitchItemsNumber = new int[this.glitchItems.length];
            for (int i4 = 0; i4 < this.glitchItems.length; ++i4) {
                this.glitchItemsNumber[i4] = this.glitchItems[i4].number * this.totalMultiplier;
            }
        }
        this.rewardItemsNumber = new int[this.rewardItems.length];
        this.finalRewardItemsNumber = new int[this.rewardItems.length];
        for (i = 0; i < this.rewardItems.length; ++i) {
            this.rewardItemsNumber[i] = this.rewardItems[i].number * this.difficultyMultiplier;
        }
        for (i = 0; i < this.rewardItems.length; ++i) {
            this.finalRewardItemsNumber[i] = this.rewardItems[i].number * this.totalMultiplier;
        }
    }

    public static class MissionButton
    extends Button {
        public final MissionData missionData;
        public static final Button.CreateNarration DEFAULT_NARRATION = Supplier::get;

        public MissionButton(MissionData missionData, int pWidth, int pHeight, Component pMessage, Button.OnPress pOnPress, String tooltip) {
            super(0, 0, pWidth, pHeight, pMessage, pOnPress, DEFAULT_NARRATION);
            this.missionData = missionData;
            if (tooltip != null) {
                this.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)tooltip)));
            }
        }

        public MissionData getMissionData() {
            return this.missionData;
        }
    }
}

