/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.data;

import io.github.sluggly.timemercenaries.client.handler.ButtonHandler;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.mercenary.MercenaryPlayerData;
import io.github.sluggly.timemercenaries.missions.Mission;
import io.github.sluggly.timemercenaries.missions.MissionItem;
import java.util.LinkedHashSet;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class StatisticsData {
    public int commonStarted;
    public int commonSuccess;
    public int uncommonStarted;
    public int uncommonSuccess;
    public int rareStarted;
    public int rareSuccess;
    public int epicStarted;
    public int epicSuccess;
    public int legendaryStarted;
    public int legendarySuccess;
    public int fails;
    public int deaths;
    public int damageTaken;
    public int bribes;
    public int totemsUsed;
    public int totalCoins;
    public int commonItems;
    public int uncommonItems;
    public int rareItems;
    public int epicItems;
    public int legendaryItems;
    public int totalQuests;
    public int questsSuccess;
    public final LinkedHashSet<MissionItem> allRewardItems;
    public Button[] allRewardItemsButtons;

    public StatisticsData(PlayerData playerData, String mercenaryName) {
        CompoundTag statsTag = MercenaryPlayerData.getMercenaryStatisticsTag(playerData, mercenaryName);
        if (mercenaryName.equals("Vael")) {
            this.totalCoins = statsTag.m_128451_("TotalCoins");
            this.commonItems = statsTag.m_128451_("CommonItems");
            this.uncommonItems = statsTag.m_128451_("UncommonItems");
            this.rareItems = statsTag.m_128451_("RareItems");
            this.epicItems = statsTag.m_128451_("EpicItems");
            this.legendaryItems = statsTag.m_128451_("LegendaryItems");
            this.totalQuests = statsTag.m_128451_("TotalQuests");
            this.questsSuccess = statsTag.m_128451_("QuestsSuccess");
        } else {
            this.commonStarted = statsTag.m_128451_("CommonStarted");
            this.commonSuccess = statsTag.m_128451_("CommonSuccess");
            this.uncommonStarted = statsTag.m_128451_("UncommonStarted");
            this.uncommonSuccess = statsTag.m_128451_("UncommonSuccess");
            this.rareStarted = statsTag.m_128451_("RareStarted");
            this.rareSuccess = statsTag.m_128451_("RareSuccess");
            this.epicStarted = statsTag.m_128451_("EpicStarted");
            this.epicSuccess = statsTag.m_128451_("EpicSuccess");
            this.legendaryStarted = statsTag.m_128451_("LegendaryStarted");
            this.legendarySuccess = statsTag.m_128451_("LegendarySuccess");
            this.fails = statsTag.m_128451_("Fails");
            this.deaths = statsTag.m_128451_("Deaths");
            this.damageTaken = statsTag.m_128451_("DamageTaken");
            this.bribes = statsTag.m_128451_("Bribe");
            this.totemsUsed = statsTag.m_128451_("Totem");
        }
        this.allRewardItems = Mercenary.getMercenary(mercenaryName).getMercenaryAllPossibleRewards();
        if (!this.allRewardItems.isEmpty()) {
            this.allRewardItemsButtons = new Button[this.allRewardItems.size()];
            int index = 0;
            for (MissionItem item : this.allRewardItems) {
                this.allRewardItemsButtons[index] = new Button.Builder(ButtonHandler.Empty, ButtonHandler::doNothing).m_252987_(0, 0, 20, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)item.getItemTooltip()).m_130948_(Style.f_131099_.m_178520_(Mission.mapRarityToColor.get(item.rarity).intValue())))).m_253136_();
                ++index;
            }
        }
    }

    public int getTotalMissionsStarted() {
        return this.commonStarted + this.uncommonStarted + this.rareStarted + this.epicStarted + this.legendaryStarted;
    }

    public int getTotalMissionsSuccess() {
        return this.commonSuccess + this.uncommonSuccess + this.rareSuccess + this.epicSuccess + this.legendarySuccess;
    }

    public String getSuccessRate(int started, int success) {
        if (started == 0) {
            return "N/A";
        }
        return String.format("%.0f%%", (double)success / (double)started * 100.0);
    }
}

