/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.data;

import io.github.sluggly.timemercenaries.client.data.MercenaryData;
import io.github.sluggly.timemercenaries.client.handler.ButtonHandler;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.mercenary.MercenaryPlayerData;
import io.github.sluggly.timemercenaries.mercenary.Trait;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;

public class TraitData {
    public final Map<String, TraitButton> mapTraitButton = new HashMap<String, TraitButton>();

    public TraitData(MercenaryData mercenaryData, PlayerData playerdata) {
        for (int i = 0; i < Trait.getTraits().size(); ++i) {
            Trait trait = Trait.getTrait(i);
            TraitButton tmpButton = new TraitButton(trait.name, 20, 20, ButtonHandler.Empty, ButtonHandler::handleLevelUpTraitButton, trait.getDescription(mercenaryData.getTraitLevel(trait.name)));
            tmpButton.f_93623_ = MercenaryPlayerData.canMercenaryTraitLevelUp(playerdata, mercenaryData.name, trait.name);
            this.mapTraitButton.put(trait.name, tmpButton);
        }
    }

    public static class TraitButton
    extends Button {
        public final String trait;
        public static final Button.CreateNarration DEFAULT_NARRATION = Supplier::get;

        public TraitButton(String trait, int pWidth, int pHeight, Component pMessage, Button.OnPress pOnPress, String tooltip) {
            super(0, 0, pWidth, pHeight, pMessage, pOnPress, DEFAULT_NARRATION);
            this.trait = trait;
            if (tooltip != null) {
                this.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)tooltip)));
            }
        }

        public String getTrait() {
            return this.trait;
        }
    }
}

