/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.sluggly.timemercenaries.entity.Portal;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class PortalRenderer
extends EntityRenderer<Portal> {
    private static final ResourceLocation BLUE_PORTAL_TEXTURE = new ResourceLocation("timemercenaries", "textures/entity/blue_portal.png");
    private static final ResourceLocation RED_PORTAL_TEXTURE = new ResourceLocation("timemercenaries", "textures/entity/red_portal.png");
    private static final int FRAME_HEIGHT = 128;
    private static final int TOTAL_FRAMES = 7;
    private static final int ANIMATION_TICK_SPEED = 2;

    public PortalRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(Portal pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.m_85836_();
        float openCloseProgress = Math.min(20.0f, (float)Math.min(pEntity.age, pEntity.getPortalLife() - pEntity.age)) / 20.0f;
        pPoseStack.m_85841_(openCloseProgress, openCloseProgress, openCloseProgress);
        float yaw = Mth.m_14179_((float)pPartialTicks, (float)pEntity.f_19859_, (float)pEntity.m_146908_());
        float pitch = Mth.m_14179_((float)pPartialTicks, (float)pEntity.f_19860_, (float)pEntity.m_146909_());
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(-yaw));
        pPoseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        int currentFrame = pEntity.age / 2 % 7;
        float totalTextureHeight = 896.0f;
        float u0 = 0.0f;
        float u1 = 1.0f;
        float v0 = (float)(currentFrame * 128) / 896.0f;
        float v1 = (float)((currentFrame + 1) * 128) / 896.0f;
        VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(pEntity)));
        PoseStack.Pose pose = pPoseStack.m_85850_();
        float size = 1.5f;
        vertexconsumer.m_252986_(pose.m_252922_(), -size, -size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        vertexconsumer.m_252986_(pose.m_252922_(), -size, size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        vertexconsumer.m_252986_(pose.m_252922_(), size, size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        vertexconsumer.m_252986_(pose.m_252922_(), size, -size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_252939_(pose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        pPoseStack.m_85849_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull Portal pEntity) {
        if (pEntity.getPortalType() == Portal.PortalType.BLUE) {
            return BLUE_PORTAL_TEXTURE;
        }
        return RED_PORTAL_TEXTURE;
    }
}

