/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.compat;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import io.github.sluggly.timemercenaries.init.ItemInit;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.missions.Mission;
import io.github.sluggly.timemercenaries.missions.MissionDefinition;
import io.github.sluggly.timemercenaries.missions.MissionItem;
import io.github.sluggly.timemercenaries.missions.MissionManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@EmiEntrypoint
public class EmiTimeMercenariesPlugin
implements EmiPlugin {
    public static final EmiRecipeCategory MISSION_CATEGORY = new EmiRecipeCategory(new ResourceLocation("timemercenaries", "mission"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)ItemInit.DIMENSIONAL_TIME_CLOCK.get())));

    public void register(EmiRegistry registry) {
        registry.addCategory(MISSION_CATEGORY);
        registry.addWorkstation(MISSION_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ItemInit.DIMENSIONAL_TIME_CLOCK.get())));
        MissionManager.getMissionManager().getAllMissions().forEach((id, definition) -> {
            Mercenary mercenary = Mercenary.getMercenary(definition.mercenary());
            if (mercenary != null) {
                for (MissionItem successItem : definition.successItems()) {
                    if (successItem.entity != null || successItem.itemStack == null || successItem.itemStack.m_41619_()) continue;
                    registry.addRecipe((EmiRecipe)new EmiMissionRecipe((ResourceLocation)id, mercenary, new Mission((ResourceLocation)id, (MissionDefinition)definition), successItem.itemStack));
                }
            }
        });
    }

    private static class EmiMissionRecipe
    implements EmiRecipe {
        private final ResourceLocation id;
        private final Mercenary mercenary;
        private final Mission mission;
        private final List<EmiIngredient> inputs;
        private final List<EmiStack> outputs;

        public EmiMissionRecipe(ResourceLocation id, Mercenary mercenary, Mission mission, ItemStack output) {
            this.id = new ResourceLocation(id.m_135827_(), "/" + id.m_135815_() + "/" + Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)output.m_41720_())).m_135815_());
            this.mercenary = mercenary;
            this.mission = mission;
            this.outputs = List.of(EmiStack.of((ItemStack)output));
            this.inputs = new ArrayList<EmiIngredient>();
            for (MissionItem item : mission.getRequiredItems(-1)) {
                this.inputs.add((EmiIngredient)EmiStack.of((ItemStack)item.itemStack, (long)item.number));
            }
        }

        public EmiRecipeCategory getCategory() {
            return MISSION_CATEGORY;
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public List<EmiIngredient> getInputs() {
            return this.inputs;
        }

        public List<EmiStack> getOutputs() {
            return this.outputs;
        }

        public int getDisplayWidth() {
            return 132;
        }

        public int getDisplayHeight() {
            return 73;
        }

        public void addWidgets(WidgetHolder widgets) {
            widgets.addTexture(new ResourceLocation("timemercenaries", "textures/gui/dimensional_time_clock_jei_screen.png"), 0, 0, 132, 73, 0, 0);
            widgets.addTexture(this.mercenary.texture, 2, 2, 48, 69, 0, 0, 48, 69, 256, 256);
            Font font = Minecraft.m_91087_().f_91062_;
            MutableComponent mercenaryName = Component.m_237113_((String)this.mercenary.name);
            int centerX = 26;
            int textWidth = font.m_92852_((FormattedText)mercenaryName);
            int textX = centerX - textWidth / 2;
            widgets.addText(mercenaryName.m_7532_(), textX, 2, this.mercenary.color, true);
            widgets.addText(Component.m_237113_((String)(this.mission.rarity + " Mission")).m_7532_(), 60, 25, this.mission.getTextColor(), true);
            widgets.addSlot((EmiIngredient)this.outputs.get(0), 84, 38).recipeContext((EmiRecipe)this);
        }
    }
}

