/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.compat;

import io.github.sluggly.timemercenaries.init.ItemInit;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.missions.Mission;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ItemObtainCategory
implements IRecipeCategory<ObtainMethod> {
    private final IDrawable icon;
    private static final Component TITLE = Component.m_237115_((String)"itemGroup.time_mercenary_tab");
    public static final ResourceLocation UID = new ResourceLocation("timemercenaries", "mission");
    public static final ResourceLocation TEXTURE = new ResourceLocation("timemercenaries", "textures/gui/dimensional_time_clock_jei_screen.png");
    public static final RecipeType<ObtainMethod> OBTAIN_METHOD_RECIPE_TYPE = new RecipeType(UID, ObtainMethod.class);

    public ItemObtainCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ItemInit.DIMENSIONAL_TIME_CLOCK.get()));
    }

    @NotNull
    public RecipeType<ObtainMethod> getRecipeType() {
        return OBTAIN_METHOD_RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return TITLE;
    }

    public int getWidth() {
        return 132;
    }

    public int getHeight() {
        return 73;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ObtainMethod recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 84, 38).addItemStack(recipe.getOutput());
    }

    public void draw(ObtainMethod recipe, @NotNull IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.m_280218_(TEXTURE, 0, 0, 0, 0, 132, 73);
        guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)recipe.mercenary.name), 26, 2, recipe.mercenary.color);
        guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)(recipe.mission.rarity + " Mission")), 95, 25, recipe.mission.getTextColor());
        guiGraphics.m_280163_(recipe.mercenary.texture, 2, 2, 0.0f, 0.0f, 48, 69, 256, 256);
    }

    public static class ObtainMethod
    implements IRecipeCategoryExtension {
        private final ItemStack output;
        public final Mercenary mercenary;
        public final Mission mission;

        public ObtainMethod(ItemStack output, String mercenaryName, Mission mission) {
            this.output = output;
            this.mercenary = Mercenary.getMercenary(mercenaryName);
            this.mission = mission;
        }

        public ItemStack getOutput() {
            return this.output;
        }
    }
}

