/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.config;

import io.github.sluggly.timemercenaries.client.KeyBindings;
import io.github.sluggly.timemercenaries.client.screen.ClientConfigScreen;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.forgespi.language.IModInfo;

public class ClientConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.BooleanValue PLAY_MISSION_FINISHED_SOUND;
    public static final ForgeConfigSpec.BooleanValue SHOW_MISSION_FINISHED_MESSAGE;
    public static final ForgeConfigSpec.BooleanValue MUTE_ALL_SOUNDS;
    public static final ForgeConfigSpec.BooleanValue PLAY_MERCENARY_VOICELINES;
    public static final ForgeConfigSpec.BooleanValue SHOW_MERCENARY_VOICELINE_TRANSCRIPTS;
    public static final ForgeConfigSpec.BooleanValue SHOW_ARENA_TEAMS_HUD;
    public static final ForgeConfigSpec.DoubleValue ARENA_TEAMS_HUD_SCALE;

    public static void handleOpenModConfigScreenKeybind(Minecraft mc) {
        if (KeyBindings.INSTANCE.openConfigKey.m_90857_()) {
            IModInfo modInfo = ((ModContainer)ModList.get().getModContainerById("timemercenaries").get()).getModInfo();
            Optional screenFactory = ConfigScreenHandler.getScreenFactoryFor((IModInfo)modInfo);
            screenFactory.ifPresent(factory -> {
                Screen configScreen = (Screen)factory.apply(mc, mc.f_91080_);
                mc.m_91152_(configScreen);
            });
        }
    }

    public static void initClientConfig() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SPEC, "timemercenaries-client.toml");
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> new ClientConfigScreen((Screen)screen)));
    }

    static {
        BUILDER.comment("Client Settings").push("Client");
        BUILDER.push("Notifications");
        PLAY_MISSION_FINISHED_SOUND = BUILDER.comment("Set to true to play a sound when a mercenary's mission is complete.").define("playMissionFinishedSound", true);
        SHOW_MISSION_FINISHED_MESSAGE = BUILDER.comment("Set to true to show a chat message when a mercenary's mission is complete.").define("showMissionFinishedMessage", true);
        BUILDER.push("Sounds");
        MUTE_ALL_SOUNDS = BUILDER.comment("Set to true to mute all sounds from this mod.").define("muteAllSounds", false);
        PLAY_MERCENARY_VOICELINES = BUILDER.comment("Set to true to allow mercenaries to play voice lines for certain events.").define("playMercenaryVoicelines", true);
        SHOW_MERCENARY_VOICELINE_TRANSCRIPTS = BUILDER.comment("Set to true to show a chat message transcript of mercenary voice lines.").define("showMercenaryVoicelineTranscripts", false);
        BUILDER.pop();
        BUILDER.push("Arena");
        SHOW_ARENA_TEAMS_HUD = BUILDER.comment("Set to true to show the teams health bar in the Arena.").define("showArenaTeamsHud", true);
        ARENA_TEAMS_HUD_SCALE = BUILDER.comment("Set the scale of the teams HUD in the Arena.").defineInRange("arenaTeamsHudScale", 0.75, 0.1, 3.0);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

