/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.data;

import io.github.sluggly.timemercenaries.admin.Admin;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.lore.Lore;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.mercenary.MercenaryPlayerData;
import io.github.sluggly.timemercenaries.mercenary.Shopkeeper;
import io.github.sluggly.timemercenaries.mercenary.Trait;
import io.github.sluggly.timemercenaries.module.Module;
import io.github.sluggly.timemercenaries.utils.NBTKeys;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class DataUpdate {
    public static void checkAndUpdatePlayerCustomData(PlayerData playerData) {
        if (playerData != null) {
            if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                System.out.println("Check Version Update");
            }
            DataUpdate.checkIfOutdatedVersion(playerData);
            if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                System.out.println("Check Missing Mercenary");
            }
            DataUpdate.checkIfMissingMercenary(playerData);
            if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                System.out.println("Check Missing Trait");
            }
            DataUpdate.checkIfMissingTrait(playerData);
            if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                System.out.println("Check Missing Module");
            }
            DataUpdate.checkIfMissingModule(playerData);
            if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                System.out.println("Check Version Sync");
            }
            DataUpdate.checkIfModVersionChanged(playerData);
            if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                System.out.println("All Checks Done");
            }
        }
    }

    public static void checkIfOutdatedVersion(PlayerData playerData) {
        DataUpdate.updateToVersion1(playerData);
        DataUpdate.updateToVersion2(playerData);
        DataUpdate.updateToVersion3(playerData);
        DataUpdate.updateToVersion4(playerData);
        DataUpdate.updateToVersion5(playerData);
    }

    public static void checkIfMissingMercenary(PlayerData playerData) {
        CompoundTag mercenariesTag = MercenaryPlayerData.getMercenariesTag(playerData);
        for (String mercenaryName : Mercenary.getMercenariesName()) {
            if (mercenariesTag.m_128441_(mercenaryName)) continue;
            MercenaryPlayerData.addNewMercenaryToTag(playerData, mercenaryName, mercenariesTag);
            if (!Admin.ADMIN_SERVER_CONSOLE_LOG) continue;
            System.out.println(" - Added new mercenary : " + mercenaryName);
        }
    }

    public static void checkIfMissingTrait(PlayerData playerData) {
        for (String mercenaryName : MercenaryPlayerData.getMercenariesTag(playerData).m_128431_()) {
            if (mercenaryName.equals("Vael")) continue;
            CompoundTag traitsData = MercenaryPlayerData.getMercenaryTraitsTag(playerData, mercenaryName);
            for (Map.Entry<String, Trait> entry : Trait.getTraitsMap()) {
                if (traitsData.m_128441_(entry.getKey())) continue;
                traitsData.m_128405_(entry.getKey(), 0);
                if (!Admin.ADMIN_SERVER_CONSOLE_LOG) continue;
                System.out.println(" - Added new trait information : " + entry.getKey() + " to mercenary " + mercenaryName);
            }
        }
    }

    public static void checkIfMissingModule(PlayerData playerData) {
        CompoundTag moduleData = Module.getModulesTag(playerData);
        for (Map.Entry<String, Module> entry : Module.getModules()) {
            if (moduleData.m_128441_(entry.getKey())) continue;
            moduleData.m_128379_(entry.getKey(), false);
            if (!Admin.ADMIN_SERVER_CONSOLE_LOG) continue;
            System.out.println(" - Added new module information : " + entry.getKey());
        }
    }

    public static void checkIfModVersionChanged(PlayerData playerData) {
        String dataVersion = playerData.playerDataTag.m_128461_("ModVersion");
        if (!dataVersion.equals("0.14.2")) {
            playerData.playerDataTag.m_128359_("ModVersion", "0.14.2");
            DataUpdate.resetToDefaultState(playerData);
            if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                System.out.println(" - Version updated : " + dataVersion + " -> 0.14.2");
            }
        }
    }

    public static void resetToDefaultState(PlayerData playerData) {
        MercenaryPlayerData.resetAllMercenaryCurrentMission(playerData);
        playerData.setState("Recruiting");
        playerData.playerDataTag.m_128359_("CurrentMercenary", "None");
    }

    public static void updateToVersion1(PlayerData playerData) {
        CompoundTag customData = playerData.getCompoundTag();
        if (!customData.m_128441_("Version")) {
            CompoundTag mercenaryData;
            CompoundTag mercenaryArray;
            int nbMercenaries;
            CompoundTag tmpMercenary;
            Object expArray;
            Tag tmpTag;
            if (!customData.m_128441_("State")) {
                customData.m_128359_("State", "Recruiting");
            }
            if (!customData.m_128441_("MissionsAvailable")) {
                customData.m_128385_("MissionsAvailable", new int[]{-1, -1, -1});
            }
            if (customData.m_128441_("ChosenRecruit")) {
                tmpTag = customData.m_128423_("ChosenRecruit");
                assert (tmpTag != null);
                if (tmpTag.m_7060_() == 3) {
                    int indexChosen = customData.m_128451_("ChosenRecruit");
                    customData.m_128473_("ChosenRecruit");
                    if (indexChosen != -1) {
                        String name = Mercenary.getMercenariesName().get(indexChosen);
                        customData.m_128359_("ChosenRecruit", Mercenary.getMercenary((String)name).name);
                    } else {
                        customData.m_128359_("ChosenRecruit", "None");
                    }
                }
            } else {
                customData.m_128359_("ChosenRecruit", "None");
            }
            if (customData.m_128441_("RecruitsAvailable")) {
                tmpTag = customData.m_128423_("RecruitsAvailable");
                assert (tmpTag != null);
                if (tmpTag.m_7060_() == 11) {
                    int[] mercenaryArray2 = customData.m_128465_("RecruitsAvailable");
                    customData.m_128473_("RecruitsAvailable");
                    CompoundTag compoundMercenaryArray = new CompoundTag();
                    if (mercenaryArray2[0] != -1) {
                        String name1 = Mercenary.getMercenariesName().get(mercenaryArray2[0]);
                        String name2 = Mercenary.getMercenariesName().get(mercenaryArray2[1]);
                        String name3 = Mercenary.getMercenariesName().get(mercenaryArray2[2]);
                        compoundMercenaryArray.m_128359_("Recruit1", Mercenary.getMercenary((String)name1).name);
                        compoundMercenaryArray.m_128359_("Recruit2", Mercenary.getMercenary((String)name2).name);
                        compoundMercenaryArray.m_128359_("Recruit3", Mercenary.getMercenary((String)name3).name);
                        customData.m_128365_("RecruitsAvailable", (Tag)compoundMercenaryArray);
                    } else {
                        MercenaryPlayerData.generateRecruitsForPlayer(playerData);
                    }
                }
            } else {
                MercenaryPlayerData.generateRecruitsForPlayer(playerData);
            }
            if (!customData.m_128441_("Mercenaries")) {
                int nbMercenaries2 = Mercenary.getMercenariesName().size();
                CompoundTag mercenaryArray3 = new CompoundTag();
                if (!customData.m_128441_("Exp")) {
                    expArray = new int[nbMercenaries2];
                } else {
                    expArray = customData.m_128465_("Exp");
                    customData.m_128473_("Exp");
                }
                for (int index = 0; index < nbMercenaries2; ++index) {
                    int[] traitsArray;
                    tmpMercenary = new CompoundTag();
                    tmpMercenary.m_128405_("Exp", (int)expArray[index]);
                    tmpMercenary.m_128379_("Totem", false);
                    CompoundTag tmpTraits = new CompoundTag();
                    int nbTraits = 5;
                    if (!customData.m_128441_("Traits")) {
                        traitsArray = new int[nbMercenaries2 * nbTraits];
                    } else {
                        traitsArray = customData.m_128465_("Traits");
                        customData.m_128473_("Traits");
                    }
                    int tmpIndex = 0;
                    for (Map.Entry<String, Trait> entry : Trait.getTraitsMap()) {
                        if (entry.getKey().equals("Random")) {
                            tmpTraits.m_128405_(entry.getKey(), 0);
                            continue;
                        }
                        tmpTraits.m_128405_(entry.getKey(), traitsArray[index * nbTraits + tmpIndex]);
                        ++tmpIndex;
                    }
                    tmpMercenary.m_128365_("Traits", (Tag)tmpTraits);
                    String name = Mercenary.getMercenariesName().get(index);
                    mercenaryArray3.m_128365_(Mercenary.getMercenary((String)name).name, (Tag)tmpMercenary);
                }
                customData.m_128365_("Mercenaries", (Tag)mercenaryArray3);
            }
            if ((nbMercenaries = Mercenary.getMercenariesName().size()) != (mercenaryArray = customData.m_128469_("Mercenaries")).m_128440_()) {
                expArray = Mercenary.getMercenariesEntrySet().iterator();
                while (expArray.hasNext()) {
                    CompoundTag tmpMercenary2;
                    Map.Entry entry = (Map.Entry)expArray.next();
                    Mercenary mercenary = (Mercenary)entry.getValue();
                    if (!mercenaryArray.m_128441_(mercenary.name)) {
                        tmpMercenary2 = new CompoundTag();
                        tmpMercenary2.m_128405_("Exp", 0);
                        tmpMercenary2.m_128379_("Totem", false);
                        CompoundTag tmpTraits = new CompoundTag();
                        for (Map.Entry<String, Trait> entryTrait : Trait.getTraitsMap()) {
                            tmpTraits.m_128405_(entryTrait.getKey(), 0);
                        }
                        tmpMercenary2.m_128365_("Traits", (Tag)tmpTraits);
                        mercenaryArray.m_128365_(mercenary.name, (Tag)tmpMercenary2);
                    }
                    tmpMercenary2 = mercenaryArray.m_128469_(mercenary.name);
                    tmpMercenary2.m_128405_("LevelsSpent", 0);
                    tmpMercenary2.m_128405_("ChosenMission", -1);
                    tmpMercenary2.m_128405_("TotalTime", 0);
                    tmpMercenary2.m_128405_("TimeLeft", 0);
                    tmpMercenary2.m_128379_("Bribed", false);
                    tmpMercenary2.m_128359_("MissionStatus", "None");
                    tmpMercenary2.m_128385_("MissionsAvailable", new int[]{-1, -1, -1});
                    Random random = new Random();
                    tmpMercenary2.m_128405_("Seed", random.nextInt(100000) + 1000);
                }
            }
            expArray = Mercenary.getMercenariesName().iterator();
            while (expArray.hasNext()) {
                String key = (String)expArray.next();
                tmpMercenary = customData.m_128469_(key);
                if (tmpMercenary.m_128441_("Totem")) continue;
                tmpMercenary.m_128379_("Totem", false);
            }
            CompoundTag modules = new CompoundTag();
            for (Map.Entry<String, Module> entry : Module.getModules()) {
                modules.m_128379_(entry.getKey(), false);
            }
            customData.m_128365_("Modules", (Tag)modules);
            for (String mercenaryName : customData.m_128469_("Mercenaries").m_128431_()) {
                mercenaryData = customData.m_128469_("Mercenaries").m_128469_(mercenaryName);
                if (!mercenaryData.m_128441_("RandomTraits")) continue;
                for (String trait : mercenaryData.m_128469_("Traits").m_128431_()) {
                    int levelNormal = mercenaryData.m_128469_("Traits").m_128451_(trait);
                    int levelRandom = mercenaryData.m_128469_("RandomTraits").m_128451_(trait);
                    mercenaryData.m_128469_("Traits").m_128405_(trait, levelNormal + levelRandom);
                }
                mercenaryData.m_128473_("RandomTraits");
            }
            for (String mercenaryName : customData.m_128469_("Mercenaries").m_128431_()) {
                mercenaryData = customData.m_128469_("Mercenaries").m_128469_(mercenaryName);
                if (!mercenaryData.m_128441_("MaxHealth")) {
                    mercenaryData.m_128405_("MaxHealth", Mercenary.getMercenary((String)mercenaryName).health);
                }
                if (mercenaryData.m_128441_("CurrentHealth")) continue;
                mercenaryData.m_128405_("CurrentHealth", Mercenary.getMercenary((String)mercenaryName).health);
            }
            for (String mercenaryName : customData.m_128469_("Mercenaries").m_128431_()) {
                CompoundTag traitsData = customData.m_128469_("Mercenaries").m_128469_(mercenaryName).m_128469_("Traits");
                int deathLevel = traitsData.m_128451_("Death");
                traitsData.m_128405_("Healthy", deathLevel);
                traitsData.m_128473_("Death");
            }
            for (String mercenaryName : customData.m_128469_("Mercenaries").m_128431_()) {
                mercenaryData = customData.m_128469_("Mercenaries").m_128469_(mercenaryName);
                if (mercenaryData.m_128441_("Reroll")) continue;
                mercenaryData.m_128405_("Reroll", 0);
            }
            for (String mercenaryName : customData.m_128469_("Mercenaries").m_128431_()) {
                mercenaryData = customData.m_128469_("Mercenaries").m_128469_(mercenaryName);
                if (mercenaryData.m_128441_("MissionsDifficulty")) continue;
                mercenaryData.m_128385_("MissionsDifficulty", new int[]{0, 0, 0});
            }
            if (customData.m_128441_("ChosenRecruit")) {
                customData.m_128359_("CurrentMercenary", customData.m_128461_("ChosenRecruit"));
                customData.m_128473_("ChosenRecruit");
            }
            if (customData.m_128441_("MissionStatus")) {
                customData.m_128473_("MissionStatus");
            }
            if (customData.m_128441_("ChosenMission")) {
                customData.m_128473_("ChosenMission");
            }
            if (customData.m_128441_("TimeLeft")) {
                customData.m_128473_("TimeLeft");
            }
            if (customData.m_128441_("Seed")) {
                customData.m_128473_("Seed");
            }
            if (customData.m_128441_("TotalTime")) {
                customData.m_128473_("TotalTime");
            }
            if (customData.m_128441_("MissionsAvailable")) {
                customData.m_128473_("MissionsAvailable");
            }
            if (customData.m_128441_("Bribed")) {
                customData.m_128473_("Bribed");
            }
            customData.m_128405_("Version", 1);
            if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                System.out.println(" - Updated to Version 1");
            }
        }
    }

    public static void updateToVersion2(PlayerData playerData) {
        CompoundTag customData = playerData.getCompoundTag();
        if (customData.m_128451_("Version") == 1) {
            CompoundTag mercenaryData;
            if (!customData.m_128441_("Coins")) {
                customData.m_128405_("Coins", 0);
            }
            if (!(mercenaryData = customData.m_128469_("Mercenaries").m_128469_("Vael")).m_128441_("ShopStatus")) {
                byte[] byteArray = new byte[Shopkeeper.maxItems];
                mercenaryData.m_128365_("ShopStatus", (Tag)new ByteArrayTag(byteArray));
            }
            if (!customData.m_128441_("Lore")) {
                CompoundTag lore = new CompoundTag();
                lore.m_128350_("Progress", 0.0f);
                customData.m_128365_("Lore", (Tag)lore);
            }
            for (String mercenaryName : customData.m_128469_("Mercenaries").m_128431_()) {
                CompoundTag mercenaryDataTag = customData.m_128469_("Mercenaries").m_128469_(mercenaryName);
                mercenaryDataTag.m_128473_("ChosenMission");
                mercenaryDataTag.m_128359_("ChosenMission", NBTKeys.MISSION_EMPTY_ID.toString());
                mercenaryDataTag.m_128473_("MissionsAvailable");
                CompoundTag missionsAvailable = new CompoundTag();
                for (int i = 1; i <= 3; ++i) {
                    CompoundTag tmpMission = new CompoundTag();
                    tmpMission.m_128359_("Id", NBTKeys.MISSION_EMPTY_ID.toString());
                    tmpMission.m_128405_("Difficulty", 0);
                    tmpMission.m_128405_("Seed", 0);
                    missionsAvailable.m_128365_("Mission" + i, (Tag)tmpMission);
                }
                mercenaryDataTag.m_128365_("MissionsAvailable", (Tag)missionsAvailable);
            }
            mercenaryData = customData.m_128469_("Mercenaries").m_128469_("Vael");
            if (!mercenaryData.m_128441_("QuestsAvailable")) {
                CompoundTag availableQuests = new CompoundTag();
                for (int i = 1; i <= 3; ++i) {
                    availableQuests.m_128365_("Quest" + i, (Tag)MercenaryPlayerData.getEmptyMercenaryQuestTag());
                }
                mercenaryData.m_128365_("QuestsAvailable", (Tag)availableQuests);
                mercenaryData.m_128359_("ChosenQuest", NBTKeys.MISSION_EMPTY_ID.toString());
                mercenaryData.m_128359_("QuestStatus", NBTKeys.MISSION_EMPTY_ID.toString());
            }
            customData.m_128405_("Version", 2);
            DataUpdate.resetToDefaultState(playerData);
            if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                System.out.println(" - Updating to Version 2");
            }
        }
    }

    public static void updateToVersion3(PlayerData playerData) {
        CompoundTag customData = playerData.getCompoundTag();
        if (customData.m_128451_("Version") == 2) {
            for (String mercenaryName : customData.m_128469_("Mercenaries").m_128431_()) {
                CompoundTag mercenaryDataTag = customData.m_128469_("Mercenaries").m_128469_(mercenaryName);
                mercenaryDataTag.m_128365_("Statistics", (Tag)MercenaryPlayerData.getMercenaryStatisticsTag(playerData, mercenaryName));
            }
            if (customData.m_128441_("Coins")) {
                int currentCoins = customData.m_128451_("Coins");
                CompoundTag vaelTag = MercenaryPlayerData.getMercenaryTag(playerData, "Vael");
                vaelTag.m_128405_("Coins", currentCoins);
                customData.m_128473_("Coins");
            }
            CompoundTag loreTag = Lore.getPlayerLoreTag(playerData);
            loreTag.m_128405_("Count", 0);
            for (String mercenaryName : customData.m_128469_("Mercenaries").m_128431_()) {
                if (mercenaryName.equals("Vael")) continue;
                CompoundTag mercenaryDataTag = customData.m_128469_("Mercenaries").m_128469_(mercenaryName);
                mercenaryDataTag.m_128405_("Hunger", 10);
                mercenaryDataTag.m_128379_("Fed", false);
            }
            for (String mercenaryName : customData.m_128469_("Mercenaries").m_128431_()) {
                if (mercenaryName.equals("Vael")) continue;
                CompoundTag traitTag = MercenaryPlayerData.getMercenaryTraitsTag(playerData, mercenaryName);
                if (traitTag.m_128441_("Random")) {
                    traitTag.m_128405_("Scavenger", traitTag.m_128451_("Random"));
                    traitTag.m_128473_("Random");
                }
                if (traitTag.m_128441_("Fail")) {
                    traitTag.m_128405_("Reliable", traitTag.m_128451_("Fail"));
                    traitTag.m_128473_("Fail");
                }
                if (traitTag.m_128441_("Double")) {
                    traitTag.m_128405_("Greedy", traitTag.m_128451_("Double"));
                    traitTag.m_128473_("Double");
                }
                if (traitTag.m_128441_("Regen")) {
                    traitTag.m_128405_("Regeneration", traitTag.m_128451_("Regen"));
                    traitTag.m_128473_("Regen");
                }
                if (traitTag.m_128441_("Healthy")) {
                    traitTag.m_128405_("Sturdiness", traitTag.m_128451_("Healthy"));
                    traitTag.m_128473_("Healthy");
                }
                if (!traitTag.m_128441_("Experience")) continue;
                traitTag.m_128405_("Knowledgeable", traitTag.m_128451_("Experience"));
                traitTag.m_128473_("Experience");
            }
            customData.m_128405_("Version", 3);
            DataUpdate.resetToDefaultState(playerData);
            if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                System.out.println(" - Updating to Version 3");
            }
        }
    }

    public static void updateToVersion4(PlayerData playerData) {
        CompoundTag customData = playerData.getCompoundTag();
        if (customData.m_128451_("Version") == 3) {
            CompoundTag mercenariesTag = MercenaryPlayerData.getMercenariesTag(playerData);
            CompoundTag vaelTag = mercenariesTag.m_128469_("Vael");
            if (!vaelTag.m_128441_("MissionStatus")) {
                vaelTag.m_128359_("MissionStatus", "None");
                vaelTag.m_128405_("TotalTime", 0);
                vaelTag.m_128405_("TimeLeft", 0);
            }
            customData.m_128405_("Version", 4);
            if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                System.out.println(" - Updating to Version 4");
            }
        }
    }

    public static void updateToVersion5(PlayerData playerData) {
        CompoundTag customData = playerData.getCompoundTag();
        if (customData.m_128451_("Version") == 4) {
            CompoundTag playerInfoTag = playerData.getPlayerInformation();
            if (playerInfoTag.m_128441_("LastCoordX")) {
                playerInfoTag.m_128473_("LastCoordX");
                playerInfoTag.m_128473_("LastCoordY");
                playerInfoTag.m_128473_("LastCoordZ");
                playerInfoTag.m_128473_("LastDimension");
            }
            customData.m_128405_("Version", 5);
            if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                System.out.println(" - Updating to Version 5");
            }
        }
    }
}

