/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.data;

import io.github.sluggly.timemercenaries.admin.Admin;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.item.DimensionalTimeClock;
import io.github.sluggly.timemercenaries.item.artefacts.VoidWovenLeggings;
import io.github.sluggly.timemercenaries.lore.Lore;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.mercenary.Quest;
import io.github.sluggly.timemercenaries.mercenary.Shopkeeper;
import io.github.sluggly.timemercenaries.mercenary.Trait;
import io.github.sluggly.timemercenaries.missions.Mission;
import io.github.sluggly.timemercenaries.module.Module;
import io.github.sluggly.timemercenaries.network.CtoSPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class PlayerActionHandler {
    public static void handlePlayerAction(@NotNull CtoSPacket message, ServerPlayer player) {
        String action = message.action;
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Received action: " + action + " from player: " + player.m_6302_());
        }
        CompoundTag data = message.data;
        switch (action) {
            case "Recruit": {
                Mercenary.playerRecruitMercenary(player, data.m_128461_("Mercenary"));
                break;
            }
            case "SendMission": {
                Mission.sendMission(player, data.m_128461_("Mercenary"), new ResourceLocation(message.data.m_128461_("Mission")));
                break;
            }
            case "RerollMission": {
                Mission.rerollMission(player, data.m_128461_("Mercenary"), new ResourceLocation(message.data.m_128461_("Mission")));
                break;
            }
            case "SameRerollMission": {
                Mission.sameRerollMission(player, data.m_128461_("Mercenary"), new ResourceLocation(message.data.m_128461_("Mission")));
                break;
            }
            case "SkipMission": {
                Mission.skipMission(player, data.m_128461_("Mercenary"));
                break;
            }
            case "SkipShop": {
                Shopkeeper.skipShop(player, data.m_128461_("Mercenary"));
                break;
            }
            case "FinishMission": {
                Mission.finishMission(player, data.m_128461_("Mercenary"));
                break;
            }
            case "LevelTrait": {
                Trait.levelUpTrait(player, data.m_128461_("Mercenary"), data.m_128461_("Trait"));
                break;
            }
            case "Bribe": {
                Mercenary.playerMercenaryBribe(player, data.m_128461_("Mercenary"));
                break;
            }
            case "Totem": {
                Mercenary.playerMercenaryTotem(player, data.m_128461_("Mercenary"));
                break;
            }
            case "Resurrect": {
                Mercenary.playerResurrectMercenary(player, data.m_128461_("Mercenary"));
                break;
            }
            case "ResetTraits": {
                Trait.playerMercenaryResetTraits(player, data.m_128461_("Mercenary"));
                break;
            }
            case "UseDimensionalTimeClock": {
                DimensionalTimeClock.checkIfPlayerCanUseClock((Player)player);
                break;
            }
            case "UnlockModule": {
                Module.unlockModule(player, Integer.parseInt(message.data.m_128461_("Module")));
                break;
            }
            case "GenerateMissionResults": {
                Mission.generateMissionResult(player, data.m_128461_("Mercenary"));
                break;
            }
            case "PrintNBT": {
                PlayerData.logCustomData((Player)player, true);
                break;
            }
            case "ScoutingReturn": {
                PlayerData.playerScoutingReturn(player);
                break;
            }
            case "SkippingReturn": {
                PlayerData.playerSkippingReturn(player);
                break;
            }
            case "MercenaryWaitingScreen": {
                PlayerData.playerGoToWaitingScreen(player, data.m_128461_("Mercenary"));
                break;
            }
            case "ChangeMissionDifficulty": {
                Mission.changeMissionDifficulty(player, data.m_128461_("Mercenary"), new ResourceLocation(data.m_128461_("Mission")));
                break;
            }
            case "OpenShop": {
                Shopkeeper.playerOpenShop(player);
                break;
            }
            case "OpenQuest": {
                Shopkeeper.playerOpenQuest(player);
                break;
            }
            case "BuyShopItem": {
                Shopkeeper.playerBuyShopItem(player, data.m_128451_("Index"));
                break;
            }
            case "AcceptQuest": {
                Quest.playerAcceptQuest(player, data.m_128461_("Mercenary"), data.m_128451_("Quest"));
                break;
            }
            case "AbandonQuest": {
                Quest.playerAbandonQuest(player, data.m_128461_("Mercenary"));
                break;
            }
            case "CompleteQuest": {
                Quest.playerCompleteQuest(player, data.m_128461_("Mercenary"));
                break;
            }
            case "VoidJump": {
                VoidWovenLeggings.playerVoidJump(player);
                break;
            }
            case "CompleteLoreStep": {
                Lore.completeLoreStep(player);
                break;
            }
            case "FeedMercenary": {
                Mercenary.playerFeedMercenary(player, data.m_128461_("Mercenary"));
                break;
            }
            case "ADMIN_RESET": {
                Admin.adminResetPlayerData(player);
                break;
            }
            case "ADMIN_LEVEL_UP": {
                Admin.adminLevelUp(player, data.m_128461_("Mercenary"));
                break;
            }
            case "ADMIN_KILL": {
                Admin.adminKill(player, data.m_128461_("Mercenary"));
                break;
            }
            case "ADMIN_RESURRECT": {
                Admin.adminResurrect(player, data.m_128461_("Mercenary"));
                break;
            }
            case "ADMIN_DAMAGE": {
                Admin.adminDamage(player, data.m_128461_("Mercenary"));
                break;
            }
            case "ADMIN_HEAL": {
                Admin.adminHeal(player, data.m_128461_("Mercenary"));
                break;
            }
            case "ADMIN_NEXT": {
                Admin.adminNext(player, data.m_128461_("Index"));
                break;
            }
            case "ADMIN_ITEMS": {
                Admin.adminItems(player);
                break;
            }
            case "ADMIN_INSTANT": {
                Admin.adminInstant(player);
                break;
            }
            case "ADMIN_RESET_ADVANCEMENTS": {
                Admin.adminResetAdvancements(player);
                break;
            }
            case "ADMIN_RESET_MODULES": {
                Admin.adminResetModules(player);
                break;
            }
            case "ADMIN_REROLL_RECRUITS": {
                Admin.adminRerollRecruits(player);
                break;
            }
            case "ADMIN_REROLL_MISSION": {
                Admin.adminRerollMission(player, data.m_128461_("Mercenary"), data.m_128461_("Index"));
                break;
            }
            case "ADMIN_MERCENARY_TRAITS": {
                Admin.adminUnlockAllMercenaryTraits(player, data.m_128461_("Mercenary"));
                break;
            }
            case "ADMIN_SUCCESS_MISSION": {
                Admin.adminSuccessMission(player, data.m_128461_("Mercenary"));
                break;
            }
            case "ADMIN_FAIL_MISSION": {
                Admin.adminFailMission(player, data.m_128461_("Mercenary"));
                break;
            }
            case "ADMIN_RESET_COINS": {
                Admin.adminResetCoins(player);
                break;
            }
            case "ADMIN_ADD_COINS": {
                Admin.adminAddCoins(player);
                break;
            }
            case "ADMIN_REROLL_SHOP": {
                Admin.rerollShop(player, data.m_128461_("Mercenary"));
                break;
            }
            case "ADMIN_REROLL_QUEST": {
                Admin.rerollQuest(player, data.m_128461_("Mercenary"), data.m_128451_("Index"));
                break;
            }
            case "ADMIN_PROGRESS_QUEST": {
                Admin.progressQuest(player, data.m_128461_("Mercenary"));
                break;
            }
            case "ADMIN_TESTS": {
                Admin.adminRunTests();
                break;
            }
            case "ADMIN_SKIP_TUTORIAL": {
                Admin.skipTutorial(player);
                break;
            }
            case "ADMIN_NEXT_LORE_STEP": {
                Admin.nextLoreStep(player);
                break;
            }
            case "ADMIN_CHANGE_LORE_COUNT": {
                Admin.changeLoreCount(player, data.m_128451_("Index"));
                break;
            }
            case "ADMIN_FEED_MERCENARY": {
                Admin.feedMercenary(player, data.m_128461_("Mercenary"), data.m_128451_("Index"));
            }
        }
    }
}

