/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.entity;

import io.github.sluggly.timemercenaries.init.EntityInit;
import io.github.sluggly.timemercenaries.item.artefacts.PrimalHuntingSpear;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ThrownPrimalSpear
extends AbstractArrow {
    private float damage = 2.0f;
    private int life = 0;
    private Map<Enchantment, Integer> enchantmentMap = new HashMap<Enchantment, Integer>();

    public ThrownPrimalSpear(EntityType<? extends ThrownPrimalSpear> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ThrownPrimalSpear(Level pLevel, LivingEntity pShooter, ItemStack pStack) {
        super((EntityType)EntityInit.THROWN_PRIMAL_SPEAR.get(), pShooter, pLevel);
        this.setEnchantments(pStack);
    }

    public void setDamage(float pDamage) {
        this.damage = pDamage;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.life;
        if (this.life >= 600) {
            this.m_146870_();
        }
        if (this.m_9236_().f_46443_ && this.m_6060_()) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public void setEnchantments(ItemStack stack) {
        int flameLevel;
        this.enchantmentMap = EnchantmentHelper.m_44831_((ItemStack)stack);
        int piercingLevel = this.enchantmentMap.getOrDefault(Enchantments.f_44961_, 0);
        if (piercingLevel > 0) {
            this.m_36767_((byte)piercingLevel);
        }
        if ((flameLevel = this.enchantmentMap.getOrDefault(Enchantments.f_44990_, 0).intValue()) > 0) {
            this.m_20254_(600);
        }
    }

    protected void m_5790_(@NotNull EntityHitResult pResult) {
        int impalingLevel;
        super.m_5790_(pResult);
        float finalDamage = this.damage;
        Entity hitEntity = pResult.m_82443_();
        Entity owner = this.m_19749_();
        int powerLevel = this.enchantmentMap.getOrDefault(Enchantments.f_44988_, 0);
        if (powerLevel > 0) {
            finalDamage += (float)powerLevel * 0.5f + 0.5f;
        }
        if ((impalingLevel = this.enchantmentMap.getOrDefault(Enchantments.f_44956_, 0).intValue()) > 0 && hitEntity instanceof LivingEntity && hitEntity.m_20070_()) {
            finalDamage += (float)impalingLevel * 2.5f;
        }
        if (hitEntity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)hitEntity;
            int currentStacks = PrimalHuntingSpear.getSpearHitCount(target);
            PrimalHuntingSpear.incrementSpearHitCount(target);
            float bonusDamage = (float)(++currentStacks - 1) * 0.5f;
            finalDamage += bonusDamage;
        }
        if (hitEntity.m_6469_(this.m_269291_().m_269418_((AbstractArrow)this, owner), finalDamage)) {
            int punchLevel = this.enchantmentMap.getOrDefault(Enchantments.f_44989_, 0);
            if (punchLevel > 0) {
                double basePunchStrength = (double)punchLevel * 0.6;
                double damageMultiplier = Math.min(1.0 + (double)this.damage / 5.0, 5.0);
                double finalPunchStrength = basePunchStrength * damageMultiplier;
                Vec3 pushVector = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(finalPunchStrength);
                if (pushVector.m_82556_() > 0.0) {
                    hitEntity.m_5997_(pushVector.f_82479_, 0.1, pushVector.f_82481_);
                }
            }
            if (this.enchantmentMap.getOrDefault(Enchantments.f_44990_, 0) > 0) {
                hitEntity.m_20254_(5);
            }
        }
        if (this.m_36796_() > 0) {
            return;
        }
        this.m_146870_();
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (!this.enchantmentMap.isEmpty()) {
            ItemStack tempStack = new ItemStack((ItemLike)Items.f_41852_);
            EnchantmentHelper.m_44865_(this.enchantmentMap, (ItemStack)tempStack);
            pCompound.m_128365_("Enchantments", (Tag)tempStack.m_41785_());
        }
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("Enchantments", 9)) {
            ListTag listTag = pCompound.m_128437_("Enchantments", 10);
            this.enchantmentMap = EnchantmentHelper.m_44882_((ListTag)listTag);
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }
}

