/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.entity.projectile;

import io.github.sluggly.timemercenaries.init.EntityInit;
import io.github.sluggly.timemercenaries.item.artefacts.RainbowTimecrystal;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class BeamProjectile
extends Projectile {
    private static final EntityDataAccessor<Float> START_X = SynchedEntityData.m_135353_(BeamProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> START_Y = SynchedEntityData.m_135353_(BeamProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> START_Z = SynchedEntityData.m_135353_(BeamProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> END_X = SynchedEntityData.m_135353_(BeamProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> END_Y = SynchedEntityData.m_135353_(BeamProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> END_Z = SynchedEntityData.m_135353_(BeamProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(BeamProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BEAM_TYPE_INDEX = SynchedEntityData.m_135353_(BeamProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float rotation = 0.0f;
    public static int numberOfColors = 10;
    private static final String BEAM_ID_KEY = "ActiveBeamId";

    public BeamProjectile(EntityType<BeamProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_20242_(true);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(START_X, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(START_Y, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(START_Z, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(END_X, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(END_Y, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(END_Z, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(COLOR, (Object)0xFFFFFF);
        this.m_20088_().m_135372_(BEAM_TYPE_INDEX, (Object)0);
    }

    public void setup(Vec3 start, Vec3 end, int colorRgb, int beamType) {
        this.m_20088_().m_135381_(START_X, (Object)Float.valueOf((float)start.f_82479_));
        this.m_20088_().m_135381_(START_Y, (Object)Float.valueOf((float)start.f_82480_));
        this.m_20088_().m_135381_(START_Z, (Object)Float.valueOf((float)start.f_82481_));
        this.m_20088_().m_135381_(END_X, (Object)Float.valueOf((float)end.f_82479_));
        this.m_20088_().m_135381_(END_Y, (Object)Float.valueOf((float)end.f_82480_));
        this.m_20088_().m_135381_(END_Z, (Object)Float.valueOf((float)end.f_82481_));
        this.m_20088_().m_135381_(COLOR, (Object)colorRgb);
        this.m_20088_().m_135381_(BEAM_TYPE_INDEX, (Object)beamType);
    }

    public Vec3 getStartPos() {
        return new Vec3((double)((Float)this.m_20088_().m_135370_(START_X)).floatValue(), (double)((Float)this.m_20088_().m_135370_(START_Y)).floatValue(), (double)((Float)this.m_20088_().m_135370_(START_Z)).floatValue());
    }

    public Vec3 getEndPos() {
        return new Vec3((double)((Float)this.m_20088_().m_135370_(END_X)).floatValue(), (double)((Float)this.m_20088_().m_135370_(END_Y)).floatValue(), (double)((Float)this.m_20088_().m_135370_(END_Z)).floatValue());
    }

    public int getColor() {
        return (Integer)this.m_20088_().m_135370_(COLOR);
    }

    public void updateBeam(Player owner) {
        Vec3 startPos = owner.m_146892_().m_82520_(0.0, -0.5, -0.4);
        Vec3 look = owner.m_20154_();
        Vec3 endPos = startPos.m_82549_(look.m_82490_(10.0));
        BlockHitResult hitResult = this.m_9236_().m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)owner));
        Vec3 finalEndPos = hitResult.m_82450_();
        this.m_20088_().m_135381_(START_X, (Object)Float.valueOf((float)startPos.f_82479_));
        this.m_20088_().m_135381_(START_Y, (Object)Float.valueOf((float)startPos.f_82480_));
        this.m_20088_().m_135381_(START_Z, (Object)Float.valueOf((float)startPos.f_82481_));
        this.m_20088_().m_135381_(END_X, (Object)Float.valueOf((float)finalEndPos.f_82479_));
        this.m_20088_().m_135381_(END_Y, (Object)Float.valueOf((float)finalEndPos.f_82480_));
        this.m_20088_().m_135381_(END_Z, (Object)Float.valueOf((float)finalEndPos.f_82481_));
    }

    public void dealDamageAndEffects() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        Player owner = (Player)this.m_19749_();
        if (owner == null) {
            return;
        }
        int beamType = (Integer)this.m_20088_().m_135370_(BEAM_TYPE_INDEX);
        float damage = 2.0f;
        ArrayList<MobEffect> effects = new ArrayList<MobEffect>();
        switch (beamType) {
            case 0: {
                damage = 0.5f;
                effects.add(MobEffects.f_19614_);
                effects.add(MobEffects.f_19613_);
                effects.add(MobEffects.f_19599_);
                effects.add(MobEffects.f_19597_);
                effects.add(MobEffects.f_19602_);
                effects.add(MobEffects.f_19604_);
                effects.add(MobEffects.f_19610_);
                effects.add(MobEffects.f_216964_);
                effects.add(MobEffects.f_19612_);
                effects.add(MobEffects.f_19620_);
                effects.add(MobEffects.f_19615_);
                break;
            }
            case 1: {
                effects.add(MobEffects.f_19614_);
                break;
            }
            case 2: {
                effects.add(MobEffects.f_19613_);
                break;
            }
            case 3: {
                effects.add(MobEffects.f_19599_);
                break;
            }
            case 4: {
                effects.add(MobEffects.f_19597_);
                break;
            }
            case 5: {
                damage = 5.0f;
                effects.add(MobEffects.f_19602_);
                break;
            }
            case 6: {
                effects.add(MobEffects.f_19604_);
                break;
            }
            case 7: {
                effects.add(MobEffects.f_19610_);
                break;
            }
            case 8: {
                effects.add(MobEffects.f_216964_);
                break;
            }
            case 9: {
                effects.add(MobEffects.f_19612_);
                break;
            }
            case 10: {
                effects.add(MobEffects.f_19620_);
                break;
            }
            case 11: {
                damage = 3.0f;
                effects.add(MobEffects.f_19615_);
            }
        }
        AABB beamBox = new AABB(this.getStartPos(), this.getEndPos()).m_82400_(-0.25);
        List hitEntities = this.m_9236_().m_6249_((Entity)owner, beamBox, e -> e.m_6084_() && e.m_6087_());
        for (Entity entity : hitEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_6469_(owner.m_269291_().m_269425_(), damage);
            livingEntity.m_20254_(3);
            if (effects.isEmpty()) continue;
            for (MobEffect effect : effects) {
                livingEntity.m_7292_(new MobEffectInstance(effect));
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20011_(new AABB(this.m_20185_() - 0.5, this.m_20186_(), this.m_20189_() - 0.5, this.m_20185_() + 0.5, this.m_20186_() + 1.0, this.m_20189_() + 0.5));
        if (this.m_9236_().f_46443_) {
            this.rotation += 25.0f;
        } else {
            Player owner = (Player)this.m_19749_();
            if (owner == null || !owner.m_6117_() || !(owner.m_21211_().m_41720_() instanceof RainbowTimecrystal)) {
                this.m_146870_();
            }
        }
    }

    protected void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_20088_().m_135381_(START_X, (Object)Float.valueOf(pCompound.m_128457_("StartX")));
        this.m_20088_().m_135381_(START_Y, (Object)Float.valueOf(pCompound.m_128457_("StartY")));
        this.m_20088_().m_135381_(START_Z, (Object)Float.valueOf(pCompound.m_128457_("StartZ")));
        this.m_20088_().m_135381_(END_X, (Object)Float.valueOf(pCompound.m_128457_("EndX")));
        this.m_20088_().m_135381_(END_Y, (Object)Float.valueOf(pCompound.m_128457_("EndY")));
        this.m_20088_().m_135381_(END_Z, (Object)Float.valueOf(pCompound.m_128457_("EndZ")));
        this.m_20088_().m_135381_(COLOR, (Object)pCompound.m_128451_("Color"));
        this.m_20088_().m_135381_(BEAM_TYPE_INDEX, (Object)pCompound.m_128451_("BeamType"));
    }

    protected void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("StartX", ((Float)this.m_20088_().m_135370_(START_X)).floatValue());
        pCompound.m_128350_("StartY", ((Float)this.m_20088_().m_135370_(START_Y)).floatValue());
        pCompound.m_128350_("StartZ", ((Float)this.m_20088_().m_135370_(START_Z)).floatValue());
        pCompound.m_128350_("EndX", ((Float)this.m_20088_().m_135370_(END_X)).floatValue());
        pCompound.m_128350_("EndY", ((Float)this.m_20088_().m_135370_(END_Y)).floatValue());
        pCompound.m_128350_("EndZ", ((Float)this.m_20088_().m_135370_(END_Z)).floatValue());
        pCompound.m_128405_("Color", ((Integer)this.m_20088_().m_135370_(COLOR)).intValue());
        pCompound.m_128405_("BeamType", ((Integer)this.m_20088_().m_135370_(BEAM_TYPE_INDEX)).intValue());
    }

    public static BeamProjectile getBeamForPlayer(Player player) {
        if (player.getPersistentData().m_128441_(BEAM_ID_KEY)) {
            int id = player.getPersistentData().m_128451_(BEAM_ID_KEY);
            Entity beam = player.m_9236_().m_6815_(id);
            if (beam instanceof BeamProjectile) {
                return (BeamProjectile)beam;
            }
        }
        return null;
    }

    public static BeamProjectile createBeamForPlayer(Player player) {
        BeamProjectile beam = new BeamProjectile((EntityType<BeamProjectile>)((EntityType)EntityInit.BEAM_PROJECTILE.get()), player.m_9236_());
        beam.m_5602_((Entity)player);
        Vec3 startPos = player.m_146892_().m_82520_(0.0, -0.5, -0.4);
        Vec3 look = player.m_20154_();
        BlockHitResult hitResult = player.m_9236_().m_45547_(new ClipContext(startPos, startPos.m_82549_(look.m_82490_(10.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        Vec3 endPos = hitResult.m_82450_();
        int beamTypeIndex = player.m_9236_().f_46441_.m_188503_(numberOfColors);
        int color = BeamProjectile.getColorForType(beamTypeIndex).getRGB();
        beam.m_5602_((Entity)player);
        beam.setup(startPos, endPos, color, beamTypeIndex);
        player.m_9236_().m_7967_((Entity)beam);
        player.getPersistentData().m_128405_(BEAM_ID_KEY, beam.m_19879_());
        return beam;
    }

    public static void destroyBeamForPlayer(Player player) {
        BeamProjectile beam = BeamProjectile.getBeamForPlayer(player);
        if (beam != null) {
            beam.m_146870_();
        }
        player.getPersistentData().m_128473_(BEAM_ID_KEY);
    }

    private static Color getColorForType(int index) {
        return switch (index) {
            case 1 -> Color.GREEN;
            case 2 -> Color.LIGHT_GRAY;
            case 3 -> Color.ORANGE;
            case 4 -> Color.RED;
            case 5 -> Color.BLACK;
            case 6 -> Color.PINK;
            case 7 -> Color.GRAY;
            case 8 -> Color.MAGENTA;
            case 9 -> Color.YELLOW;
            case 10 -> Color.CYAN;
            case 11 -> Color.DARK_GRAY;
            default -> Color.WHITE;
        };
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }
}

